/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.model.problems.VlogProblemKinds;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractCompilationErrorCheck;

@CheckVersion(value="17.1.10")
@CheckID(value="SYNTACTIC_PROBLEM")
@CheckName(value="SYNTACTIC_PROBLEM")
@CheckLabel(labels={RuleLabel.COMPILATION})
@CheckTitle(value="Syntactic Problems")
@CheckDescription(value="This check shows the syntactic problems reported during compilation.")
public class SyntacticProblemCheck
extends AbstractCompilationErrorCheck {
    public SyntacticProblemCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public String getErrorMessage() {
        return "There are syntactic compilation problems!";
    }

    @Override
    public void configure() {
        super.configure();
        for (String showValue : this.pShowValueAsStrings) {
            Severity severity = Severity.from((String)showValue);
            if (severity == null) {
                this.signalParamError("Invalid value: " + showValue + " for 'show' parameter", true);
                continue;
            }
            this.pShowValue.add(severity);
        }
    }

    @Override
    public List<DVTProblem> getIssues() {
        ArrayList<DVTProblem> result = new ArrayList<DVTProblem>();
        Collection allSyntaxErrors = DVTProblemManager.getInstance().getAllProblems(this.getIProject(), DVTProblemMatcher.all().setKind(VlogProblemKinds.SYNTAX_ERROR.getId()), null);
        Collection allSyntaxWarnings = DVTProblemManager.getInstance().getAllProblems(this.getIProject(), DVTProblemMatcher.all().setKind(VlogProblemKinds.SYNTAX_WARNING.getId()), null);
        if (allSyntaxErrors != null) {
            result.addAll(allSyntaxErrors);
        }
        if (allSyntaxWarnings != null) {
            result.addAll(allSyntaxWarnings);
        }
        return this.filterAndSort(result, false);
    }
}

