/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;

public abstract class AbstractAllDataTypeUsersCheck
extends OVMComplianceCheck {
    public AbstractAllDataTypeUsersCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected abstract String getFailMessage(String var1);

    @Override
    public void performCheckImpl() {
        try {
            this.fOVMProject.getRfProject().accept(new DataTypeVisitor());
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected int geParameterPortListSize(DataType dataType, RfNamedElement scope) {
        List<RfField> params = LintUtils.getParamsFromDataType(dataType, scope);
        if (params == null) {
            return 0;
        }
        int paramsInList = this.checkParameters(params, scope);
        return paramsInList;
    }

    protected int checkParameters(List<RfField> params, RfNamedElement scope) {
        int paramsInList = 0;
        for (RfField param : params) {
            if (!param.isInParameterPortList()) continue;
            ++paramsInList;
        }
        return paramsInList;
    }

    protected int checkNamedParamAssignments(DataType dt, RfNamedElement scope) {
        int specializationParamsSize = 0;
        Map<String, ArgInfo> namedParams = dt.getNamedParamAssignments();
        if (namedParams != null) {
            for (ArgInfo argInfo : namedParams.values()) {
                if (argInfo.getDataType() == null || argInfo.getDataType().getType() == null || argInfo.getDataType().getType().isEmpty()) continue;
                ++specializationParamsSize;
            }
        }
        return specializationParamsSize;
    }

    protected int getSpecializationParamsSize(DataType dt, RfNamedElement scope) {
        List<DataType> orderedParams;
        int specializationParamsSize = 0;
        if (dt.getInnerClassesInfo() != null && !dt.getInnerClassesInfo().isEmpty()) {
            dt = dt.getInnerClassesInfo().get(dt.getInnerClassesInfo().size() - 1);
        }
        if ((orderedParams = dt.getOrderedParamAssignments()) != null && !orderedParams.isEmpty()) {
            for (DataType orderedDT : orderedParams) {
                if (orderedDT == null || orderedDT.getType() == null || orderedDT.getType().length() <= 0) continue;
                ++specializationParamsSize;
            }
        } else {
            specializationParamsSize += this.checkNamedParamAssignments(dt, scope);
        }
        return specializationParamsSize;
    }

    protected void addHitInProperDT(RfNamedElement element, DataType dt) {
        String paramElementName = dt.getType();
        if (dt.getInnerClassesInfo() != null && !dt.getInnerClassesInfo().isEmpty()) {
            paramElementName = dt.getInnerClassesInfo().get(dt.getInnerClassesInfo().size() - 1).getType();
        }
        this.addHit(element, this.getFailMessage(paramElementName), new VerissimoAutofixAdditionalInfo(element, dt));
    }

    protected abstract boolean checkDataType(RfNamedElement var1, DataType var2, RfNamedElement var3);

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private class DataTypeVisitor
    implements IRfDefElementVisitor {
        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            IRfNamedElement resolvedType;
            RfNamedElement element = defElement.getNamedElement();
            if (element == null) {
                return;
            }
            if (AbstractAllDataTypeUsersCheck.this.checkPreWaivers(element.getFile())) {
                return;
            }
            AbstractAllDataTypeUsersCheck.this.notifyCheckAlive();
            if (element instanceof RfClass) {
                DataType parentDT = ((RfClass)element).getExtendedType();
                if (parentDT != null) {
                    AbstractAllDataTypeUsersCheck.this.checkDataType(element, parentDT, element);
                }
                return;
            }
            if (element.isPredefined() || element.getDeclaration() == null) {
                return;
            }
            if (!(element instanceof RfAssociatedType)) {
                return;
            }
            if (element instanceof RfField && ((RfField)element).isTypeParameter()) {
                return;
            }
            if (element instanceof RfPort && (resolvedType = ((RfAssociatedType)element).getResolvedType(true)) instanceof RfInterface) {
                return;
            }
            RfNamedElement enclosingScope = element.getEnclosingScope();
            if (!(enclosingScope instanceof RfNamedElement)) {
                return;
            }
            DataType dt = ((RfAssociatedType)element).getDataType();
            if (dt == null) {
                return;
            }
            AbstractAllDataTypeUsersCheck.this.checkDataType(element, dt, enclosingScope);
            List<DataType> indexDataTypes = dt.getIndexTypes();
            if (indexDataTypes != null) {
                for (DataType indexDT : indexDataTypes) {
                    if (indexDT != null && AbstractAllDataTypeUsersCheck.this.checkDataType(element, indexDT, enclosingScope)) continue;
                }
            }
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }
}

