/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Set;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.parser.ReparseInfo;

public abstract class AbstractAllVariablesCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="If true, skip parameters of overriding methods.", name="skipOverridingMethodParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipOverridingMethodParameters;

    protected AbstractAllVariablesCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<RfField> loopVariables = this.collectLoopVariables();
        try {
            this.fOVMProject.getRfProject().accept(namedElement -> {
                void field;
                RfField rfField;
                if (this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                RfNamedElement rfNamedElement = namedElement;
                if (!(rfNamedElement instanceof RfField) || (rfField = (RfField)rfNamedElement) != (RfField)rfNamedElement || field.isFromEmbeddedCovergroupDef()) {
                    return true;
                }
                if (namedElement.isPredefined()) {
                    return true;
                }
                if (namedElement.isAnonymous()) {
                    return true;
                }
                RfDefElement declaration = namedElement.getDeclaration();
                if (declaration == null) {
                    return true;
                }
                this.notifyCheckAlive();
                ReparseInfo reparseInfo = declaration.getReparseInfo();
                if (reparseInfo != null && reparseInfo.getReparseStackSize() > 0) {
                    return true;
                }
                RfNamedElement enclosingScope = declaration.getEnclosingScope();
                if (enclosingScope == null) {
                    return true;
                }
                if (enclosingScope instanceof RfField) {
                    enclosingScope = enclosingScope.getEnclosingScope();
                }
                if (((RfField)namedElement).isArgument() && this.pSkipOverridingMethodParameters && this.overridesMethod(enclosingScope)) {
                    return true;
                }
                this.checkNamingConvention(namedElement, loopVariables);
                return true;
            });
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected abstract Set<RfField> collectLoopVariables();

    private boolean overridesMethod(RfNamedElement enclosingScope) {
        if (!(enclosingScope instanceof RfFunction)) {
            return false;
        }
        RfFunction function = (RfFunction)enclosingScope;
        if (!function.isVirtual()) {
            return false;
        }
        return function.getParentVirtual(false) != null;
    }

    protected abstract void checkNamingConvention(RfNamedElement var1, Set<RfField> var2);

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

