/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

public abstract class AbstractArgumentTypePerformanceCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="Although it is illegal to use argument passing by reference for subroutines with a lifetime of static, this rule by default fails for static functions in order to indicate a potential performance issue.", name="skipStatic", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipStaticValue;
    @CheckParameter(defaultValue="false", description="Do not flag arguments with default value.", name="skipArgumentsWithDefaultValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipArgumentsWithDefaultValue;
    @CheckParameter(defaultValue="false", description="When true, task arguments are not checked.", name="skipTasks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipTasks;
    @CheckParameter(defaultValue="false", description="When true, arguments that are inherited from a XVM method are skipped.", name="skipXVMInheritedMethodArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipXVMInheritedMethodArguments;

    public AbstractArgumentTypePerformanceCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    abstract void checkArgument(RfFunction var1, RfField var2);

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        IRfNamedElementVisitor neVisitor = namedElement -> {
            if (namedElement instanceof RfFunction) {
                RfFunction xvmParentMethod;
                RfFunction function = (RfFunction)namedElement;
                if (this.pSkipStaticValue && function.isObjectStatic()) {
                    return true;
                }
                if (this.pSkipTasks && function.isTask()) {
                    return true;
                }
                if (function.isDPI() || function.isLet()) {
                    return true;
                }
                this.notifyCheckAlive();
                List<RfField> arguments = function.getArgumentsWithPrefix("", 2);
                if (arguments == null || arguments.isEmpty()) {
                    return true;
                }
                if (this.pSkipXVMInheritedMethodArguments && (xvmParentMethod = this.getXVMParentArguments(function)) != null && !xvmParentMethod.isEmpty()) {
                    arguments.removeIf(x -> xvmParentMethod.getArgumentWithPrefix(x.getName(), 2) != null);
                }
                for (RfField argument : arguments) {
                    if (this.pSkipArgumentsWithDefaultValue && argument.getInitialValue(false) != null && !argument.getInitialValue(false).isEmpty()) continue;
                    this.checkArgument(function, argument);
                }
            }
            return true;
        };
        rfProject.accept(neVisitor);
    }

    private RfFunction getXVMParentArguments(RfFunction function) {
        String functionName = function.getName();
        RfNamedElement parentClass = function.getEnclosingScope();
        while (parentClass != null && parentClass instanceof RfClass) {
            RfFunction candidate;
            if (this.fOVMProject.isOVMElement(parentClass) && (candidate = parentClass.getLocalMember(RfFunction.class, functionName, true)) != null) {
                return candidate;
            }
            parentClass = ((RfClass)parentClass).getParent();
        }
        return null;
    }
}

