/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public abstract class AbstractBannedIdentifierCheck
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final Pattern commentRegexPattern = Pattern.compile("\\s\\s+");
    private static final String LINE_DELIMITER = "\\R";
    private static final Set<String> MACRO_KEYWORDS = new HashSet<String>(Arrays.asList("`ifdef", "`ifndef", "`define"));

    protected AbstractBannedIdentifierCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected void checkMacroNames(HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        for (VlogMacroInfo macro : this.fOVMProject.getAllMacros()) {
            List<VlogMacroInfo> layers = macro.getMacroZoneLayers();
            if (layers == null) continue;
            for (VlogMacroInfo layer : layers) {
                if (this.checkPreWaivers(layer.getMacroParserPath())) continue;
                this.checkMacroName(layer, patterns, onlyFullNameMatch);
            }
        }
    }

    protected void checkMacroName(VlogMacroInfo macro, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        String macroName = macro.getName();
        for (Pattern pattern : patterns) {
            if (pattern.pattern().isEmpty()) continue;
            Matcher identifierMatcher = pattern.matcher(macroName);
            if (onlyFullNameMatch) {
                if (!identifierMatcher.matches()) continue;
                this.addHit(macro.getMacroParserPath(), macro.getLine(), "The macro name '" + macroName + "' matches the banned pattern '" + pattern.pattern() + "'!", null);
                continue;
            }
            if (!identifierMatcher.find()) continue;
            this.addHit(macro.getMacroParserPath(), macro.getLine(), "The macro name '" + macroName + "' contains the banned pattern '" + pattern.pattern() + "'!", null);
        }
    }

    protected void checkInsideInactiveCode(HashSet<Pattern> patterns, boolean onlyFullNameMatch, SVTBWhitespaceParser.ZoneType checkForZoneType) {
        List<ParserPath> allFilesInProject = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath path : allFilesInProject) {
            TreeSet<Integer> lines;
            CodePreprocFileInfo preprocInfo;
            if (this.checkPreWaivers(path) || (preprocInfo = this.fOVMProject.getRfProject().getPreprocessingTable().getCodePreprocFileInfos().get(path)) == null || (lines = preprocInfo.getLines()) == null) continue;
            Iterator<Integer> iterator = lines.iterator();
            int line1 = 0;
            int line2 = 0;
            if (iterator.hasNext()) {
                line2 = iterator.next();
            }
            while (iterator.hasNext()) {
                line1 = line2;
                line2 = iterator.next();
                CodePreprocLineInfo info = preprocInfo.getInfo(line1);
                if (info.getType() == 0) continue;
                int currentLine = line1;
                while (currentLine <= line2) {
                    String lastTokenString = "";
                    for (LiteralToken token : this.getWSParser().getTokensOnLine(path, currentLine)) {
                        if (token.getLineNumber() != currentLine) continue;
                        String tokenString = token.getStringToken();
                        if (MACRO_KEYWORDS.contains(lastTokenString) && currentLine == line1) {
                            lastTokenString = tokenString;
                            continue;
                        }
                        if (token.getZone() == SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || token.getZone() == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT || checkForZoneType != null && token.getZone() != checkForZoneType) continue;
                        this.checkInactiveString(tokenString, path, currentLine, patterns, onlyFullNameMatch);
                        lastTokenString = tokenString;
                    }
                    ++currentLine;
                }
            }
        }
    }

    protected void checkInactiveString(String string, ParserPath path, int currLine, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        for (Pattern pattern : patterns) {
            if (pattern.pattern().isEmpty()) continue;
            Matcher identifierMatcher = pattern.matcher(string);
            if (onlyFullNameMatch) {
                if (!identifierMatcher.matches()) continue;
                this.addHit(path, currLine, "Inactive code content '" + string + "' matches the banned pattern '" + pattern.pattern() + "'!", null);
                continue;
            }
            if (!identifierMatcher.find()) continue;
            this.inactiveMatchAddHit(path, currLine, string, pattern);
        }
    }

    protected void inactiveMatchAddHit(ParserPath path, int currentLine, String tokenString, Pattern pattern) {
        this.addHit(path, currentLine, "Inactive code content '" + tokenString + "' contains the banned pattern '" + pattern.pattern() + "'!", null);
    }

    protected void checkNamedElements(HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        IRfNamedElementVisitor visitor = namedElement -> {
            if (this.isPrewaived(namedElement)) {
                return true;
            }
            if (this.shouldFilterNamedElement(namedElement)) {
                return true;
            }
            if (namedElement instanceof RfStruct) {
                return true;
            }
            if (namedElement.isPredefined()) {
                return true;
            }
            if (namedElement.isAnonymous()) {
                return true;
            }
            this.notifyCheckAlive();
            if (namedElement.getName() != null) {
                this.checkNamedElement(namedElement, patterns, onlyFullNameMatch);
            }
            return true;
        };
        this.fOVMProject.getRfProject().accept(visitor);
    }

    protected void checkNamedElement(RfNamedElement namedElement, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        String elementName = namedElement.getName();
        for (Pattern pattern : patterns) {
            if (pattern.pattern().isEmpty()) continue;
            Matcher identifierMatcher = pattern.matcher(elementName);
            if (onlyFullNameMatch) {
                if (!identifierMatcher.matches()) continue;
                this.addHit(namedElement, "The name of " + LintUtils.getElementKind(namedElement) + " '" + LintUtils.getNamedElementFullName(namedElement) + "' matches the banned pattern '" + pattern.pattern() + "'!");
                continue;
            }
            if (!identifierMatcher.find()) continue;
            this.addHit(namedElement, "The name of " + LintUtils.getElementKind(namedElement) + " '" + LintUtils.getNamedElementFullName(namedElement) + "' contains the banned pattern '" + pattern.pattern() + "'!");
        }
    }

    private boolean isPrewaived(RfNamedElement namedElement) {
        RfFileDef file = namedElement.getFile();
        if (file == null) {
            return true;
        }
        ParserPath parserPath = file.getParserPath();
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected boolean shouldFilterNamedElement(RfNamedElement namedElement) {
        return false;
    }

    protected void checkComments(HashSet<Pattern> patterns) {
        Map<ParserPath, List<SVTBIssues>> commentCharIssuesMap = this.fOVMProject.getSVTBCharIssuesWithKind(SVTBCharParser.Config.DEFAULT, 136, this);
        if (commentCharIssuesMap == null || commentCharIssuesMap.isEmpty()) {
            return;
        }
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : commentCharIssuesMap.entrySet()) {
            List<SVTBIssues> issues;
            ParserPath parserPath = entry.getKey();
            if (this.checkPreWaivers(parserPath) || (issues = entry.getValue()) == null || issues.isEmpty()) continue;
            this.notifyCheckAlive();
            int nOfAddedComments = 0;
            int i = 0;
            while (i < issues.size()) {
                SVTBIssues issue = issues.get(i);
                String comment = issue.getInfo();
                int line = issue.getLine();
                if (comment != null) {
                    comment = this.deleteMetaInfoComment(comment);
                    StringBuilder str = new StringBuilder();
                    str.append(comment);
                    int currentLine = line;
                    nOfAddedComments = 0;
                    int j = i + 1;
                    while (j < issues.size()) {
                        SVTBIssues anotherIssue = issues.get(j);
                        String anotherComment = anotherIssue.getInfo();
                        if (anotherComment != null) {
                            int anotherLine = anotherIssue.getLine();
                            if (currentLine + 1 < anotherLine) break;
                            anotherComment = this.deleteMetaInfoComment(anotherComment);
                            if (currentLine == anotherLine) {
                                str.append(anotherComment);
                                ++nOfAddedComments;
                            }
                            if (currentLine + 1 == anotherLine) {
                                str.append(anotherComment);
                                ++currentLine;
                                ++nOfAddedComments;
                            }
                        }
                        ++j;
                    }
                    this.checkComment(parserPath, str.toString(), line, patterns);
                }
                i += 1 + nOfAddedComments;
            }
        }
    }

    protected void checkComment(ParserPath path, String comment, int commentLine, HashSet<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (pattern == null) continue;
            int hitLine = 0;
            Matcher m = pattern.matcher(comment);
            while (m.find()) {
                hitLine = commentLine + (String.valueOf(comment.substring(0, m.start())) + " ").split(LINE_DELIMITER).length - 1;
                this.addHit(path, hitLine, "Comment content '" + commentRegexPattern.matcher(m.group()).replaceAll(" ").trim() + "' matches the banned pattern '" + pattern.pattern() + "'!", null);
            }
        }
    }

    private String deleteMetaInfoComment(String comment) {
        if (comment.startsWith("//")) {
            comment = comment.substring(2);
        } else if (comment.startsWith("/*")) {
            comment = comment.substring(2, comment.length() - 2);
        } else if (comment.startsWith("/**")) {
            comment = comment.substring(3, comment.length() - 2);
        }
        return comment;
    }

    protected void checkFileNames(HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath parserPath : files) {
            if (parserPath.path.indexOf("__vlog__") != -1) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(parserPath)) continue;
            String fileFullPath = parserPath.path;
            File file = new File(fileFullPath);
            this.checkFileName(parserPath, file.getName(), patterns, onlyFullNameMatch);
        }
    }

    protected void checkFileName(ParserPath path, String fileName, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        for (Pattern pattern : patterns) {
            if (pattern.pattern().isEmpty()) continue;
            Matcher identifierMatcher = pattern.matcher(fileName);
            if (onlyFullNameMatch) {
                if (!identifierMatcher.matches()) continue;
                this.addHit(path, 0, "File " + fileName + " matches the banned pattern '" + pattern.pattern() + "'!", null);
                continue;
            }
            if (!identifierMatcher.find()) continue;
            this.addHit(path, 0, "File " + fileName + " contains the banned pattern '" + pattern.pattern() + "'!", null);
        }
    }

    protected void checkStringLiterals(final HashSet<Pattern> patterns, final boolean onlyFullNameMatch) {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator operator) {
                AbstractBannedIdentifierCheck.this.notifyCheckAlive();
                if (AbstractBannedIdentifierCheck.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                this.visitOperatorsTree(operator);
                return true;
            }

            private void visitOperatorsTree(HidOperator operator) {
                ListContainer rh;
                IHidObject lh = operator.getLHValue();
                if (lh instanceof RfHidImplicit) {
                    this.checkAgainstPatterns(patterns, (RfHidImplicit)lh, operator);
                }
                if ((rh = operator.getRHValues()) == null) {
                    return;
                }
                for (IHidObject hid : rh) {
                    if (!(hid instanceof RfHidImplicit)) continue;
                    this.checkAgainstPatterns(patterns, (RfHidImplicit)hid, operator);
                }
            }

            private void checkAgainstPatterns(HashSet<Pattern> patterns2, RfHidImplicit hid, HidOperator operator) {
                String expression = hid.getName();
                if (!LintUtils.isStringLiteral(expression)) {
                    return;
                }
                if (expression.length() < 2) {
                    return;
                }
                String literal = expression.substring(1, expression.length() - 1);
                if (literal.isEmpty()) {
                    return;
                }
                AbstractBannedIdentifierCheck.this.checkStringLiteral(this.parserPath, literal, operator, patterns2, onlyFullNameMatch);
            }
        });
    }

    protected void checkStringLiteral(ParserPath path, String literal, HidOperator operator, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        for (Pattern pattern : patterns) {
            if (pattern.pattern().isEmpty()) continue;
            Matcher identifierMatcher = pattern.matcher(literal);
            if (onlyFullNameMatch) {
                if (!identifierMatcher.matches()) continue;
                this.addHit(path, (HidOccurrence)operator.getOccurrence(), "String literal \"" + literal + "\" matches the banned pattern '" + pattern.pattern() + "'!", true);
                continue;
            }
            if (!identifierMatcher.find()) continue;
            this.stringLiteralMatchAddHit(path, operator, "\"" + literal + "\"", pattern);
        }
    }

    protected void stringLiteralMatchAddHit(ParserPath path, HidOperator operator, String expression, Pattern pattern) {
        this.addHit(path, (HidOccurrence)operator.getOccurrence(), "String literal " + expression + " contains the banned pattern '" + pattern.pattern() + "'!", true);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

