/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfProject;

public abstract class AbstractBeginEndLabelCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="generate_block, action_block", description="Comma separated list of block types on which the check will be applied: action_block, generate_block.", name="blockTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public HashSet<String> pBlockTypes;

    public AbstractBeginEndLabelCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected abstract boolean pathIsPrewaived(ParserPath var1);

    protected abstract boolean preAnalyzeParameters();

    protected abstract void analyzeDefinitions(List<RfDefElement> var1, BufferedReader var2, ParserPath var3) throws IOException;

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        if (!this.preAnalyzeParameters()) {
            return;
        }
        LocalBeginEndLabelDefVisitor visitor = new LocalBeginEndLabelDefVisitor();
        try {
            rfProject.accept(visitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fOVMProject.notifyCheckException(this, e);
        }
        Map<ParserPath, List<RfDefElement>> defsMap = visitor.getDefinitionsWithBeginEndLabel();
        if (defsMap.isEmpty()) {
            return;
        }
        try {
            DefComparator comparator = new DefComparator();
            for (Map.Entry<ParserPath, List<RfDefElement>> defEntry : defsMap.entrySet()) {
                ParserPath path = defEntry.getKey();
                List<RfDefElement> definitionsToCheck = defEntry.getValue();
                Collections.sort(definitionsToCheck, comparator);
                if (definitionsToCheck == null || definitionsToCheck.isEmpty()) continue;
                BufferedReader reader = new BufferedReader(new FileReader(path.path));
                this.analyzeDefinitions(definitionsToCheck, reader, path);
                reader.close();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fOVMProject.notifyCheckException(this, e);
        }
    }

    private boolean applyOnGenerateBlocks() {
        return this.pBlockTypes.contains("generate_block");
    }

    private boolean applyOnActionBlocks() {
        return this.pBlockTypes.contains("action_block");
    }

    private static final class DefComparator
    implements Comparator<RfDefElement> {
        private DefComparator() {
        }

        @Override
        public int compare(RfDefElement o1, RfDefElement o2) {
            int equal = Integer.compare(o1.getEndLine(), o2.getEndLine());
            if (equal != 0) {
                return equal;
            }
            return Integer.compare(o1.getEndOffset(), o2.getEndOffset());
        }
    }

    private class LocalBeginEndLabelDefVisitor
    implements IRfDefElementVisitor {
        private Map<ParserPath, List<RfDefElement>> definitionsWithBeginEndLabel = new HashMap<ParserPath, List<RfDefElement>>();

        private LocalBeginEndLabelDefVisitor() {
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return true;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            if (defElement instanceof RfFileDef) {
                return;
            }
            if (defElement instanceof RfFieldDef && ((RfFieldDef)defElement).isImplicit()) {
                return;
            }
            if (defElement instanceof RfFunctionDef && ((RfFunctionDef)defElement).isPrototype()) {
                return;
            }
            if (defElement.getReparseInfo() != null) {
                return;
            }
            AbstractBeginEndLabelCheck.this.notifyCheckAlive();
            ParserPath parserPath = defElement.getParserPath();
            if (AbstractBeginEndLabelCheck.this.pathIsPrewaived(parserPath)) {
                return;
            }
            if (!this.hasBeginEnd(defElement)) {
                return;
            }
            List<RfDefElement> defs = this.definitionsWithBeginEndLabel.get(parserPath);
            if (defs == null) {
                defs = new ArrayList<RfDefElement>();
                this.definitionsWithBeginEndLabel.put(parserPath, defs);
            }
            defs.add(defElement);
        }

        public Map<ParserPath, List<RfDefElement>> getDefinitionsWithBeginEndLabel() {
            return this.definitionsWithBeginEndLabel;
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }

        private boolean hasBeginEnd(RfDefElement defElement) {
            if (defElement instanceof RfGenerateBlockDef && defElement.getNamedElement() instanceof RfGenerateBlock) {
                return !((RfGenerateBlock)defElement.getNamedElement()).hasImplicitName() && AbstractBeginEndLabelCheck.this.applyOnGenerateBlocks();
            }
            if (defElement instanceof RfActionBlockDef) {
                return !defElement.getNamedElement().isAnonymous() && AbstractBeginEndLabelCheck.this.applyOnActionBlocks();
            }
            return false;
        }
    }
}

