/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.util.StringUtil;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.LightToken;
import ro.amiq.vlogdt.model.reflection.LightTokenList;
import ro.amiq.vlogdt.model.reflection.RfProject;

public abstract class AbstractCPDCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="75", description="Number of consecutive tokens required to report duplicate code.", name="minNofTokens", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected int pMinNofTokensValue;
    @CheckParameter(defaultValue="100", description="Maximum number of duplicates to report.", name="maxNofHits", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pMaxNofHitsValue;
    @CheckParameter(defaultValue="true", description="Show duplicate code in the failure message.", name="showDuplicateCode", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pShowDuplicateCodeValue;
    @CheckParameter(defaultValue="true", description="Trim duplicate code leading whitespace for readability.", name="trimLeadingWhitespace", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pTrimLeadingWhitespaceValue;
    @CheckParameter(defaultValue="false", description="By default only one hit is reported per duplicate code. For example if duplicate code is found in file1 and file2, only one hit in file1 is reported. Set this parameter to true to get a hit both in file1 and file2.", name="reportEachDuplicate", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pReportEachDuplicateValue;
    @CheckParameter(defaultValue="false", description="When true, all identifiers are considered equal and duplication is detected even when renaming for example variables. It is recommended to set a higher value (over 100) for minNofTokens in order to pinpoint significantly large patterns when ignoring identifiers.", name="ignoreIdentifiers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pIgnoreIdentifiersValue;
    @CheckParameter(defaultValue="false", description="FOR DEBUG", name="showBoundaryDuplicateTokens", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pShowBoundaryDuplicateTokensValue;
    @CheckParameter(defaultValue="false", description="FOR DEBUG", name="showDuplicateTokens", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pShowDuplicateTokensValue;
    private Map<String, List<LightToken>> fTokenMap;
    private Map<String, ParserPath> fParserPathMap;
    protected Map<String, List<TokenEntry>> fTokenEntryMap;
    private Tokens fTokenEntries;
    private HashMap<String, SoftReference<List<String>>> fCodeMap;

    public AbstractCPDCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(1000);
    }

    @Override
    public void performCheckImpl() {
        this.performCheckInternal();
    }

    private void performCheckInternal() {
        LocalCPDConfiguration cpdConfiguration = new LocalCPDConfiguration();
        cpdConfiguration.postContruct();
        cpdConfiguration.setMinimumTileSize(this.pMinNofTokensValue);
        LocalCPD cpd = new LocalCPD(cpdConfiguration);
        cpd.setCpdListener(new LocalCPDListener());
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        Map<ParserPath, LightTokenList> tokensMap = rfProject.lintGetTokensMap();
        if (tokensMap == null) {
            return;
        }
        Set<ParserPath> parserPaths = tokensMap.keySet();
        if (parserPaths == null) {
            return;
        }
        this.fTokenMap = new HashMap<String, List<LightToken>>();
        this.fTokenEntryMap = new HashMap<String, List<TokenEntry>>();
        this.fParserPathMap = new HashMap<String, ParserPath>();
        this.fCodeMap = new HashMap();
        for (ParserPath parserPath : parserPaths) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            try {
                List<LightToken> tokens = tokensMap.get(parserPath).getList();
                if (tokens == null || tokens.isEmpty()) continue;
                tokens = new ArrayList<LightToken>(tokensMap.get(parserPath).getList());
                tokens = this.filterTokens(tokens);
                this.fTokenMap.put(parserPath.path, tokens);
                this.fParserPathMap.put(parserPath.path, parserPath);
                cpd.add(parserPath, tokens);
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                this.addHit(parserPath, 0, "Failed to read " + parserPath.path + "!\n" + e.toString(), null);
            }
        }
        this.notifyCheckAlive();
        cpd.go();
        this.notifyCheckAlive();
        Iterator matchesIterator = cpd.getMatches();
        if (matchesIterator == null) {
            return;
        }
        List<Match> matches = new LinkedList<Match>();
        while (matchesIterator.hasNext()) {
            Match match = (Match)matchesIterator.next();
            matches.add(match);
        }
        this.notifyCheckAlive();
        Collections.sort(matches, new Comparator<Match>(){

            @Override
            public int compare(Match o1, Match o2) {
                if (o1.getTokenCount() < o2.getTokenCount()) {
                    return 1;
                }
                if (o1.getTokenCount() > o2.getTokenCount()) {
                    return -1;
                }
                return 0;
            }
        });
        this.notifyCheckAlive();
        matches = this.filterMatches(matches);
        this.notifyCheckAlive();
        int nofHitsToReport = this.pMaxNofHitsValue;
        for (Match match : matches) {
            if ((nofHitsToReport -= this.reportDuplicate(nofHitsToReport, match)) <= 0) break;
        }
        this.notifyCheckAlive();
        this.cleanUp();
    }

    private int reportDuplicate(int remainingNofHitsToReport, Match match) {
        int nofHits = 0;
        if (match == null) {
            return nofHits;
        }
        StringBuilder message = new StringBuilder();
        message.append(match.getLineCount()).append(" lines (").append(match.getTokenCount()).append(" tokens) duplication in the following files: ").append(PMD.EOL);
        this.notifyCheckAlive();
        LinkedList<Mark> allMarks = new LinkedList<Mark>();
        for (Mark mark : match) {
            this.notifyCheckAlive();
            if (mark == null) continue;
            allMarks.add(mark);
        }
        Collections.sort(allMarks, new Comparator<Mark>(){

            @Override
            public int compare(Mark o1, Mark o2) {
                if (o1.getFilename() == null || o2.getFilename() == null) {
                    return 0;
                }
                int stringCompare = o1.getFilename().compareTo(o2.getFilename());
                if (stringCompare != 0) {
                    return stringCompare;
                }
                if (o1.getBeginLine() > o2.getBeginLine()) {
                    return 1;
                }
                if (o1.getBeginLine() < o2.getBeginLine()) {
                    return -1;
                }
                return 0;
            }
        });
        for (Mark mark : allMarks) {
            String fileLink = this.link("at line " + mark.getBeginLine() + " of " + LintUtils.getFileShortName(mark.getFilename()), mark.getFilename(), mark.getBeginLine());
            message.append("Starting ").append(fileLink).append(PMD.EOL);
        }
        this.notifyCheckAlive();
        for (Mark mark : allMarks) {
            OVMComplianceHit hit;
            this.notifyCheckAlive();
            if (mark != null && (hit = this.reportDuplicate(message, match.getTokenCount(), mark)) != null && (!this.pReportEachDuplicateValue || remainingNofHitsToReport - ++nofHits == 0)) break;
        }
        return nofHits;
    }

    private OVMComplianceHit reportDuplicate(StringBuilder messageStart, int nofDuplicateTokens, Mark mark) {
        if (mark == null) {
            return null;
        }
        StringBuilder message = new StringBuilder(messageStart);
        String markFilename = mark.getFilename();
        ParserPath markParserPath = this.fParserPathMap.get(markFilename);
        int markBeginLine = mark.getBeginLine();
        TokenEntry markTokenEntry = mark.getToken();
        StringBuilder tokensMessage = new StringBuilder();
        if (this.pShowDuplicateTokensValue) {
            tokensMessage.append("Duplicate Tokens: ").append("--->");
        }
        LightToken firstToken = null;
        LightToken lastToken = null;
        if (markTokenEntry != null) {
            List<TokenEntry> tokenEntriesInMap = this.fTokenEntryMap.get(markFilename);
            List<LightToken> tokensInMap = this.fTokenMap.get(markFilename);
            if (tokenEntriesInMap != null) {
                int duplicateTokensCounter = nofDuplicateTokens;
                LightToken token = null;
                TokenEntry tokenEntry = null;
                TokenEntry prevTokenEntry = null;
                boolean addTokenToMessage = false;
                int i = 0;
                while (i < tokenEntriesInMap.size()) {
                    this.notifyCheckAlive();
                    tokenEntry = tokenEntriesInMap.get(i);
                    token = tokensInMap.get(i);
                    if (!addTokenToMessage && tokenEntry != null && tokenEntry.equals((Object)markTokenEntry)) {
                        addTokenToMessage = true;
                    }
                    if (addTokenToMessage) {
                        if (duplicateTokensCounter == 0) break;
                        if (tokenEntry != null) {
                            if (duplicateTokensCounter == nofDuplicateTokens) {
                                firstToken = token;
                            }
                            if (!this.pShowDuplicateTokensValue && this.pShowBoundaryDuplicateTokensValue && duplicateTokensCounter == nofDuplicateTokens) {
                                tokensMessage.append("First Duplicate Token:").append("--->").append(tokenEntry.toString()).append("<---").append(PMD.EOL);
                            }
                            if (duplicateTokensCounter == 1) {
                                lastToken = token;
                            }
                            if (!this.pShowDuplicateTokensValue && this.pShowBoundaryDuplicateTokensValue && duplicateTokensCounter == 1) {
                                tokensMessage.append("Last Duplicate Token:").append("--->").append(tokenEntry.toString()).append("<---").append(PMD.EOL);
                            }
                            if (this.pShowDuplicateTokensValue) {
                                if (prevTokenEntry != null && prevTokenEntry.getBeginLine() != tokenEntry.getBeginLine()) {
                                    tokensMessage.append(PMD.EOL);
                                } else if (duplicateTokensCounter != nofDuplicateTokens) {
                                    tokensMessage.append(" ");
                                }
                                tokensMessage.append(tokenEntry.toString());
                            }
                        }
                        --duplicateTokensCounter;
                    }
                    prevTokenEntry = tokenEntry;
                    ++i;
                }
            }
            if (this.pShowDuplicateTokensValue) {
                tokensMessage.append("<---").append(PMD.EOL);
            }
            message.append((CharSequence)tokensMessage);
        }
        if (this.pShowDuplicateCodeValue) {
            StringBuilder newLine;
            StringBuilder linesMessage = new StringBuilder();
            linesMessage.append("Duplicate Code:").append(PMD.EOL);
            this.notifyCheckAlive();
            String source = mark.getSourceCodeSlice();
            this.notifyCheckAlive();
            String[] lines = source.split("[" + PMD.EOL + "]");
            if (firstToken != null) {
                newLine = new StringBuilder();
                int i = 0;
                while (i < lines[0].length()) {
                    if (i < firstToken.getColumn() - 1) {
                        newLine.append(" ");
                    } else {
                        newLine.append(lines[0].charAt(i));
                    }
                    ++i;
                }
                lines[0] = newLine.toString();
            }
            if (lastToken != null) {
                newLine = new StringBuilder();
                int i = 0;
                while (i < lines[lines.length - 1].length()) {
                    if (i < lastToken.getColumn() + lastToken.getText().length()) {
                        newLine.append(lines[lines.length - 1].charAt(i));
                    } else {
                        newLine.append(" ");
                    }
                    ++i;
                }
                lines[lines.length - 1] = newLine.toString();
            }
            this.notifyCheckAlive();
            if (this.pTrimLeadingWhitespaceValue) {
                int trimDepth = StringUtil.maxCommonLeadingWhitespaceForAll((String[])lines);
                this.notifyCheckAlive();
                if (trimDepth > 0) {
                    lines = StringUtil.trimStartOn((String[])lines, (int)trimDepth);
                }
            }
            this.notifyCheckAlive();
            int i = 0;
            while (i < lines.length) {
                linesMessage.append(lines[i]);
                if (i < lines.length - 1) {
                    linesMessage.append(PMD.EOL);
                }
                ++i;
            }
            message.append((CharSequence)linesMessage);
        }
        return this.addHit(markParserPath, markBeginLine, message.toString(), null);
    }

    private void cleanUp() {
        List teTokens;
        List<Object> value;
        Set<String> keys;
        if (this.fParserPathMap != null) {
            this.fParserPathMap.clear();
        }
        if (this.fTokenEntryMap != null) {
            keys = this.fTokenEntryMap.keySet();
            if (keys != null) {
                for (String key : keys) {
                    value = this.fTokenEntryMap.get(key);
                    if (value == null) continue;
                    value.clear();
                }
            }
            this.fTokenEntryMap.clear();
        }
        if (this.fTokenMap != null) {
            keys = this.fTokenMap.keySet();
            if (keys != null) {
                for (String key : keys) {
                    value = this.fTokenMap.get(key);
                    if (value == null) continue;
                    value.clear();
                }
            }
            this.fTokenMap.clear();
        }
        if (this.fCodeMap != null) {
            keys = this.fCodeMap.keySet();
            if (keys != null) {
                for (String key : keys) {
                    List<String> value2;
                    SoftReference<List<String>> valueRef = this.fCodeMap.get(key);
                    if (valueRef == null || (value2 = valueRef.get()) == null) continue;
                    value2.clear();
                }
            }
            this.fCodeMap.clear();
        }
        TokenEntry.clearImages();
        if (this.fTokenEntries != null && (teTokens = this.fTokenEntries.getTokens()) != null) {
            teTokens.clear();
        }
    }

    protected abstract List<LightToken> filterTokens(List<LightToken> var1);

    protected abstract List<Match> filterMatches(List<Match> var1);

    private String getImage(LightToken token) {
        if (this.pIgnoreIdentifiersValue && token != null && token.getType() == 542) {
            return String.valueOf(542);
        }
        if (token != null) {
            return token.getText();
        }
        return null;
    }

    protected List<LightToken> isolateFunctions(List<LightToken> tokens) {
        ArrayList<LightToken> result = new ArrayList<LightToken>();
        LightToken prevToken = null;
        LightToken prevPrevToken = null;
        boolean keepTokens = false;
        for (LightToken token : tokens) {
            if (token.getType() == 108 || token.getType() == 223) {
                if ((prevToken == null || prevToken.getType() != 99 && prevToken.getType() != 260) && (prevPrevToken == null || prevPrevToken.getType() != 99)) {
                    keepTokens = true;
                    LightToken boundaryToken = LightToken.create(10000, "@@f@@" + Math.random());
                    boundaryToken.setLine(token.getLine());
                    result.add(boundaryToken);
                }
            } else if (token.getType() == 81 || token.getType() == 93) {
                result.add(token);
                keepTokens = false;
            }
            if (keepTokens) {
                result.add(token);
            }
            prevPrevToken = prevToken;
            prevToken = token;
        }
        return result;
    }

    @Override
    public void clean() {
        super.clean();
        if (this.fTokenMap != null) {
            this.fTokenMap.clear();
        }
        if (this.fParserPathMap != null) {
            this.fParserPathMap.clear();
        }
        if (this.fTokenEntryMap != null) {
            this.fTokenEntryMap.clear();
        }
        if (this.fTokenEntries != null) {
            this.fTokenEntries.getTokens().clear();
        }
        if (this.fCodeMap != null) {
            this.fCodeMap.clear();
        }
    }

    class LocalCPD
    extends CPD {
        LocalCPDConfiguration localConfiguration;

        public LocalCPD(LocalCPDConfiguration cpdConfiguration) {
            super((CPDConfiguration)cpdConfiguration);
            this.localConfiguration = cpdConfiguration;
        }

        public void add(ParserPath parserPath, List<LightToken> tokens) throws IOException {
            if (this.localConfiguration != null) {
                this.add(this.localConfiguration.sourceCodeFor(parserPath, tokens));
            }
        }
    }

    class LocalCPDConfiguration
    extends CPDConfiguration {
        private Tokenizer tokenizer;

        LocalCPDConfiguration() {
        }

        public void postContruct() {
            this.setRendererName("NoRenderer");
            this.setRenderer(new LocalRenderer());
            super.postContruct();
        }

        public Tokenizer tokenizer() {
            if (this.tokenizer == null) {
                this.tokenizer = new LocalTokenizer();
            }
            return this.tokenizer;
        }

        public LocalSourceCode sourceCodeFor(ParserPath parserPath, List<LightToken> tokens) throws IOException {
            LocalSourceCode result = new LocalSourceCode((SourceCode.CodeLoader)new LocalCodeLoader(parserPath, this.getSourceEncoding()));
            result.setParserPath(parserPath);
            result.setTokens(tokens);
            return result;
        }
    }

    class LocalCPDListener
    implements CPDListener {
        LocalCPDListener() {
        }

        public void addedFile(int fileCount, File file) {
            AbstractCPDCheck.this.notifyCheckAlive();
        }

        public void phaseUpdate(int phase) {
            AbstractCPDCheck.this.notifyCheckAlive();
        }
    }

    class LocalCodeLoader
    extends SourceCode.FileCodeLoader {
        private ParserPath parserPath;

        public LocalCodeLoader(ParserPath parserPath, String encoding) throws IOException {
            super(new File(parserPath.path), encoding);
            this.parserPath = parserPath;
        }

        public List<String> getCode() {
            List result = super.getCode();
            if (result != null && this.parserPath != null) {
                AbstractCPDCheck.this.fCodeMap.put(this.parserPath.path, new SoftReference<List>(result));
            }
            return result;
        }
    }

    static class LocalRenderer
    implements Renderer {
        LocalRenderer() {
        }

        public String render(Iterator<Match> matches) {
            return "";
        }
    }

    static class LocalSourceCode
    extends SourceCode {
        private ParserPath parserPath;
        private List<LightToken> tokens;

        public LocalSourceCode(SourceCode.CodeLoader cl) {
            super(cl);
        }

        public List<LightToken> getTokens() {
            return this.tokens;
        }

        public void setTokens(List<LightToken> tokens) {
            this.tokens = tokens;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }
    }

    class LocalTokenizer
    implements Tokenizer {
        LocalTokenizer() {
        }

        public void tokenize(SourceCode sourceCode, Tokens tokenEntries) throws IOException {
            AbstractCPDCheck.this.fTokenEntries = tokenEntries;
            if (!(sourceCode instanceof LocalSourceCode)) {
                return;
            }
            String fileName = sourceCode.getFileName();
            if (fileName == null) {
                return;
            }
            List<LightToken> tokens = ((LocalSourceCode)sourceCode).getTokens();
            if (tokens == null || tokens.isEmpty()) {
                return;
            }
            List<TokenEntry> tokenEntriesInMap = AbstractCPDCheck.this.fTokenEntryMap.get(fileName);
            if (tokenEntriesInMap == null) {
                tokenEntriesInMap = new ArrayList<TokenEntry>();
                AbstractCPDCheck.this.fTokenEntryMap.put(fileName, tokenEntriesInMap);
            }
            for (LightToken token : tokens) {
                if (token == null) continue;
                String image = AbstractCPDCheck.this.getImage(token);
                TokenEntry newTokenEntry = new TokenEntry(image, fileName, token.getLine());
                tokenEntries.add(newTokenEntry);
                tokenEntriesInMap.add(newTokenEntry);
            }
            if (tokenEntries.size() != 0) {
                tokenEntries.add(TokenEntry.getEOF());
            }
        }
    }
}

