/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrenceBounds;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.parser.ReparseInfo;

public abstract class AbstractCheckCallsInIfAndAssert
extends OVMComplianceCheck {
    private final EnumSet<HidFlatteningOption> HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS);
    @CheckParameter(defaultValue="false", description="", name="checkCondition", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckCondition;
    @CheckParameter(defaultValue="false", description="", name="skipCallsCastedToVoid", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipCallsCastedToVoidValue;
    @CheckParameter(defaultValue="false", description="", name="allowOnlyIfChecking", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowOnlyIfCheckingValue;
    @CheckParameter(defaultValue="false", description="", name="allowTempVariableChecking", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowTempVariableCheckingValue;
    @CheckParameter(defaultValue="false", description="", name="analyzeTypeParameterAccess", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAnalyzeTypeParameterAccessValue;
    @CheckParameter(defaultValue="", description="", name="checkFailureMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pCheckFailureMacros;
    private String callName;

    public AbstractCheckCallsInIfAndAssert(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(1001);
    }

    protected abstract void addHitForCheck(ParserPath var1, HidOperatorOccurrence var2, String var3, VerissimoAutofixAdditionalInfo var4);

    protected abstract void addHitForCheck(ParserPath var1, int var2, String var3, ReparseInfo var4, VerissimoAutofixAdditionalInfo var5);

    protected void performCallCheck(String callName) {
        this.callName = callName;
        RfProject rfProject = this.fOVMProject.getRfProject();
        BlocksAndAssignmentsVisitor visitor = new BlocksAndAssignmentsVisitor(this);
        rfProject.visitHidObject(rfProject, visitor);
        this.notifyCheckAlive();
        Map<RfFileDef, Map<IHidOperator, RfField>> assignedCalls = visitor.getAssignedCalls();
        Map<RfHid, List<HidOccurrenceBounds>> ifBlockExpressions = visitor.getIfBlockExpressions();
        Map<RfHid, List<HidOccurrenceBounds>> assertBlockExpressions = visitor.getAssertBlockExpressions();
        LocalHidOperatorVisitor hidOperatorVisitor = new LocalHidOperatorVisitor(assignedCalls, ifBlockExpressions, assertBlockExpressions, this);
        rfProject.visitHidObject(rfProject, hidOperatorVisitor);
        if (!this.pAllowTempVariableCheckingValue) {
            return;
        }
        Set<IHidOperator> checkedCalls = hidOperatorVisitor.getCheckedCalls();
        this.addHitsOnAssignedCalls(assignedCalls, checkedCalls);
    }

    private void addHitsOnAssignedCalls(Map<RfFileDef, Map<IHidOperator, RfField>> assignedCalls, Set<IHidOperator> checkedCalls) {
        if (assignedCalls == null) {
            return;
        }
        for (Map.Entry<RfFileDef, Map<IHidOperator, RfField>> fileEntry : assignedCalls.entrySet()) {
            Set<Map.Entry<IHidOperator, RfField>> entrySet;
            Map<IHidOperator, RfField> value = fileEntry.getValue();
            if (value == null || (entrySet = value.entrySet()) == null) continue;
            ParserPath parserPath = fileEntry.getKey().getParserPath();
            for (Map.Entry<IHidOperator, RfField> call : entrySet) {
                this.handleCall(call, checkedCalls, parserPath);
            }
        }
    }

    private void handleCall(Map.Entry<IHidOperator, RfField> call, Set<IHidOperator> checkedCalls, ParserPath parserPath) {
        IHidOperator operator = call.getKey();
        if (checkedCalls != null && checkedCalls.contains(operator)) {
            return;
        }
        ListContainer rhValues = operator.getRHValues();
        if (rhValues == null || rhValues.isEmpty()) {
            return;
        }
        IHidObject iHidObject = (IHidObject)rhValues.get(0);
        if (iHidObject instanceof RfHidAccessArgs) {
            iHidObject = ((RfHidAccessArgs)iHidObject).getParentHid();
        }
        if (!(iHidObject instanceof RfHid)) {
            return;
        }
        IRfNamedElement element = ((RfHid)iHidObject).getElement();
        HashSet<IRfNamedElement> elements = new HashSet<IRfNamedElement>();
        if (element == null) {
            return;
        }
        elements.add(element);
        if (!this.isSearchedCall(elements)) {
            return;
        }
        this.addHitForCheck(parserPath, operator.getOccurrence(), String.valueOf(HidUtils.toNiceString((IHidObject)((IHidObject)call.getKey().getRHValues().get(0)))) + " is not properly checked!", new VerissimoAutofixAdditionalInfo(iHidObject));
    }

    private boolean isSearchedCall(Set<IRfNamedElement> elements) {
        if (elements == null) {
            return false;
        }
        boolean returnValue = false;
        for (IRfNamedElement element : elements) {
            if ((!(element instanceof RfPredefinedFunction) || !this.callName.equals(element.getName())) && (!(element instanceof RfFunction) || !this.callName.equals(((RfFunction)element).getFullName()))) continue;
            returnValue = true;
        }
        return returnValue;
    }

    private List<RfHid> getBlockRfHids(IHidObject iHidObject, BlockType blockType) {
        boolean isIfBlock = blockType.equals((Object)BlockType.IF);
        if (!(this.pCheckCondition && isIfBlock || !(iHidObject instanceof RfHid))) {
            return Collections.singletonList((RfHid)iHidObject);
        }
        if (!(this.pCheckCondition && isIfBlock || !(iHidObject instanceof RfHidAccessArgs))) {
            Hid parentHid = ((RfHidAccessArgs)iHidObject).getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return null;
            }
            return Collections.singletonList((RfHid)parentHid);
        }
        if (iHidObject instanceof RfHidOperator) {
            RfHidOperator operator = (RfHidOperator)iHidObject;
            List<RfHid> hids = null;
            hids = this.pCheckCondition ? this.getRfHid(operator) : this.getRfHids(operator);
            return hids;
        }
        return null;
    }

    private List<RfHid> getRfHid(RfHidOperator operator) {
        if (!operator.isLogicalNot()) {
            return null;
        }
        IHidObject iHidObject = operator.getLHValue();
        if (iHidObject instanceof RfHidAccessArgs) {
            iHidObject = ((RfHidAccessArgs)iHidObject).getParentHid();
        }
        if (!(iHidObject instanceof RfHid)) {
            return null;
        }
        return Collections.singletonList((RfHid)iHidObject);
    }

    private List<RfHid> getRfHids(RfHidOperator operator) {
        ArrayList<RfHid> result = new ArrayList<RfHid>();
        Predicate<IHidObject> cons = element -> {
            Hid parentHid;
            if (element instanceof RfHid) {
                result.add((RfHid)((Object)element));
            }
            if (element instanceof RfHidAccessArgs && (parentHid = ((RfHidAccessArgs)((Object)element)).getParentHid()) instanceof RfHid) {
                result.add((RfHid)parentHid);
            }
            return true;
        };
        HidUtils.flattenToObjects(cons, (IHidObject)operator, this.HID_FLATTENING);
        return result;
    }

    private Set<IRfNamedElement> searchForPotentialFunctions(final RfHid hid, OVMComplianceCheck check, ParserPath parserPath, IRfNamedElement scope) {
        HidAccess parentAccess = hid.getParentAccess();
        if (parentAccess == null) {
            return null;
        }
        RfHid parentHid = (RfHid)hid.getAncestorHid();
        if (parentHid == null) {
            return null;
        }
        IRfNamedElement parentElement = parentHid.getElement();
        if (parentElement == null) {
            return null;
        }
        IRfNamedElement parameter = null;
        if (parentElement instanceof RfField && ((RfField)parentElement).isTypeParameter()) {
            parameter = parentElement;
        } else if (parentElement instanceof RfAssociatedType) {
            parameter = ((RfAssociatedType)parentElement).getAssociatedTypeNoLastLevelParams();
        }
        if (parameter instanceof RfField && ((RfField)parameter).isTypeParameter()) {
            RfHid copy = (RfHid)hid.getAncestorHid().deepCopy();
            ConfigInfo configInfo = new ConfigInfo(false, this.fOVMProject.getRfProject(), null, true, null);
            IRfNamedElement tScope = scope;
            RfClass enclosingScope = (RfClass)scope.getEnclosingScope(RfClass.class);
            if (enclosingScope != null) {
                tScope = enclosingScope.getDefaultSpecialization(null);
            }
            try {
                copy.resolve(configInfo, (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), scope, scope, parserPath, RfTypesResolver.create((IRfScopeElement)tScope, this.fOVMProject.getRfProject(), 0), null, (byte)3, true, false, false);
            }
            catch (BuildCancelException e) {
                this.fOVMProject.notifyCheckException(check, (Exception)((Object)e));
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            final HashSet<IRfNamedElement> functions = new HashSet<IRfNamedElement>();
            copy.visitHidObject(this.fOVMProject.getRfProject(), new RfHidVisitor(){

                public boolean visit(RfHid hidObject) {
                    if (!hidObject.isMethodCall(false)) {
                        return true;
                    }
                    IRfNamedElement element = hidObject.getElement();
                    if (!(element instanceof RfFunction)) {
                        return true;
                    }
                    if (!hidObject.equals((Object)hid)) {
                        return true;
                    }
                    functions.add(element);
                    return true;
                }
            });
            return functions;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static List<IHidOperator> getCallsCheckedByCondition(IRfNamedElement element, HidOperatorOccurrence operatorOccurrence, IRfScopeElement operatorScope, RfFileDef filedef, Map<IHidOperator, RfField> valuesMap) {
        coveredCalls = new ArrayList<IHidOperator>();
        closestCallInSameScope = null;
        block0: for (Map.Entry<IHidOperator, RfField> assignedCall : valuesMap.entrySet()) {
            assignedCallKey = assignedCall.getKey();
            assignedCallValue = assignedCall.getValue();
            if (!assignedCallValue.equals(element) || AbstractCheckCallsInIfAndAssert.isFirstOccurence(operatorOccurrence, assignedKeyOccurrence = assignedCallKey.getOccurrence()) || (callScope = filedef.getScope(assignedKeyOccurrence.getLine(), assignedKeyOccurrence.getOffset()).getEnclosingScope()) == null) continue;
            if (callScope != operatorScope) ** GOTO lbl17
            if (closestCallInSameScope != null && !AbstractCheckCallsInIfAndAssert.isFirstOccurence(closestCallInSameScope.getOccurrence(), assignedKeyOccurrence)) continue;
            closestCallInSameScope = assignedCallKey;
            continue;
lbl-1000:
            // 1 sources

            {
                if (callScope.equals(operatorScope)) {
                    coveredCalls.add(assignedCallKey);
                    continue block0;
                }
                if (callScope instanceof RfFunction) continue block0;
                callScope = callScope.getEnclosingScope();
lbl17:
                // 2 sources

                ** while (callScope != null)
            }
lbl18:
            // 1 sources

        }
        if (closestCallInSameScope == null) {
            return coveredCalls;
        }
        finalClosestCallInSameScope = closestCallInSameScope;
        if ((coveredCalls = coveredCalls.stream().filter((Predicate<IHidOperator>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$1(ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator ), (Lro/amiq/dvt/model/reflection/semantic/extension/IHidOperator;)Z)(finalClosestCallInSameScope)).collect(Collectors.toList())).isEmpty()) {
            return Arrays.asList(new IHidOperator[]{closestCallInSameScope});
        }
        return coveredCalls;
    }

    public static boolean isFirstOccurence(HidOperatorOccurrence first, HidOperatorOccurrence second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.getCloseBoundary() < second.getCloseBoundary()) {
            return true;
        }
        if (first.getCloseBoundary() > second.getCloseBoundary()) {
            return false;
        }
        if (first.getCloseVirtualBoundary() < second.getCloseVirtualBoundary()) {
            return true;
        }
        if (first.getCloseVirtualBoundary() > second.getCloseVirtualBoundary()) {
            return false;
        }
        return false;
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static /* synthetic */ boolean lambda$1(IHidOperator iHidOperator, IHidOperator call) {
        return !AbstractCheckCallsInIfAndAssert.isFirstOccurence(call.getOccurrence(), iHidOperator.getOccurrence());
    }

    private static enum BlockType {
        IF,
        ASSERT;

    }

    class BlocksAndAssignmentsVisitor
    implements IHidVisitor<IHidOperator> {
        RfNamedElement scope;
        ParserPath parserPath;
        RfFileDef file;
        Map<RfFileDef, Map<IHidOperator, RfField>> assignedCalls = new HashMap<RfFileDef, Map<IHidOperator, RfField>>();
        Map<RfHid, List<HidOccurrenceBounds>> ifBlockExpressions = new IdentityHashMap<RfHid, List<HidOccurrenceBounds>>();
        Map<RfHid, List<HidOccurrenceBounds>> assertBlockExpressions = new IdentityHashMap<RfHid, List<HidOccurrenceBounds>>();
        OVMComplianceCheck check;

        public BlocksAndAssignmentsVisitor(OVMComplianceCheck check) {
            this.check = check;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            this.file = this.scope.getFile();
            if (!(this.scope instanceof RfFunction)) {
                return;
            }
            RfFunction function = (RfFunction)this.scope;
            if (!function.isExtern()) {
                return;
            }
            RfDefElement implementation = function.getImplementation();
            if (implementation == null) {
                return;
            }
            RfFileDef localFile = implementation.getDefFile();
            if (localFile == null) {
                return;
            }
            this.file = localFile;
        }

        public boolean visit(IHidOperator operator) {
            if (this.scope != null && this.file != null && AbstractCheckCallsInIfAndAssert.this.fOVMProject.isOVMFile(this.file.getName())) {
                return true;
            }
            if (AbstractCheckCallsInIfAndAssert.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            if (operator.isIfCondition()) {
                this.handleCondition(operator, BlockType.IF);
                return true;
            }
            if (operator.hasOccurrence(HidOperatorQualifier.IS_ASSERT_EXPRESSION)) {
                this.handleCondition(operator, BlockType.ASSERT);
                return true;
            }
            if (!(this.scope instanceof RfFunction) && !(this.scope instanceof RfActionBlock)) {
                return true;
            }
            if (operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                this.handleDeclarationAssign(operator);
                return true;
            }
            if (operator.hasOccurrence(HidOperatorQualifier.IS_BLOCKING_ASSIGN)) {
                this.handleBlockingAssign(operator);
                return true;
            }
            return true;
        }

        public void handleCondition(IHidOperator operator, BlockType blockType) {
            List<RfHid> hids = AbstractCheckCallsInIfAndAssert.this.getBlockRfHids(operator.getLHValue(), blockType);
            if (hids == null || hids.isEmpty()) {
                return;
            }
            Map<RfHid, List<HidOccurrenceBounds>> blockExpressions = blockType.equals((Object)BlockType.IF) ? this.ifBlockExpressions : this.assertBlockExpressions;
            for (RfHid hid : hids) {
                HidOccurrenceBounds bounds;
                HidOperatorOccurrence occurence;
                IRfNamedElement call = hid.getElement();
                Set<IRfNamedElement> calls = new HashSet<IRfNamedElement>();
                if (call != null) {
                    calls.add(call);
                } else if (AbstractCheckCallsInIfAndAssert.this.pAnalyzeTypeParameterAccessValue) {
                    calls = AbstractCheckCallsInIfAndAssert.this.searchForPotentialFunctions(hid, this.check, this.parserPath, this.scope);
                }
                if (!AbstractCheckCallsInIfAndAssert.this.isSearchedCall(calls) || (occurence = operator.getOccurrence()) == null || (bounds = occurence.getBounds()) == null) continue;
                blockExpressions.putIfAbsent(hid, new ArrayList());
                blockExpressions.get((Object)hid).add(bounds);
            }
        }

        public void handleBlockingAssign(IHidOperator operator) {
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return;
            }
            IHidObject lhValue = operator.getLHValue();
            if (!(lhValue instanceof RfHid)) {
                return;
            }
            IRfNamedElement element = ((RfHid)lhValue).getElement();
            if (!(element instanceof RfField)) {
                return;
            }
            IHidObject rightHid = (IHidObject)rhValues.get(0);
            if (rightHid instanceof RfHidAccessArgs) {
                rightHid = ((RfHidAccessArgs)rightHid).getParentHid();
            }
            if (!(rightHid instanceof RfHid)) {
                return;
            }
            IRfNamedElement function = ((RfHid)rightHid).getElement();
            Set<IRfNamedElement> functions = new HashSet<IRfNamedElement>();
            if (function != null) {
                functions.add(function);
            } else if (AbstractCheckCallsInIfAndAssert.this.pAnalyzeTypeParameterAccessValue) {
                functions = AbstractCheckCallsInIfAndAssert.this.searchForPotentialFunctions((RfHid)rightHid, this.check, this.parserPath, this.scope);
            }
            if (!AbstractCheckCallsInIfAndAssert.this.isSearchedCall(functions)) {
                return;
            }
            if (this.file == null) {
                return;
            }
            this.assignedCalls.putIfAbsent(this.file, new HashMap());
            this.assignedCalls.get(this.file).put(operator, (RfField)element);
        }

        public void handleDeclarationAssign(IHidOperator operator) {
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return;
            }
            IHidObject rightHid = (IHidObject)rhValues.get(0);
            if (rightHid instanceof RfHidAccessArgs) {
                rightHid = ((RfHidAccessArgs)rightHid).getParentHid();
            }
            if (!(rightHid instanceof RfHid)) {
                return;
            }
            IRfNamedElement function = ((RfHid)rightHid).getElement();
            Set<IRfNamedElement> functions = new HashSet<IRfNamedElement>();
            if (function != null) {
                functions.add(function);
            } else if (AbstractCheckCallsInIfAndAssert.this.pAnalyzeTypeParameterAccessValue) {
                functions = AbstractCheckCallsInIfAndAssert.this.searchForPotentialFunctions((RfHid)rightHid, this.check, this.parserPath, this.scope);
            }
            if (!AbstractCheckCallsInIfAndAssert.this.isSearchedCall(functions)) {
                return;
            }
            IHidObject lhValue = operator.getLHValue();
            if (!(lhValue instanceof RfHidImplicit)) {
                return;
            }
            RfField element = this.scope.getLocalMember(RfField.class, ((RfHidImplicit)lhValue).getName(), true);
            if (element == null) {
                return;
            }
            if (this.file == null) {
                return;
            }
            this.assignedCalls.putIfAbsent(this.file, new HashMap());
            this.assignedCalls.get(this.file).put(operator, element);
        }

        public Map<RfHid, List<HidOccurrenceBounds>> getIfBlockExpressions() {
            return this.ifBlockExpressions;
        }

        public Map<RfHid, List<HidOccurrenceBounds>> getAssertBlockExpressions() {
            return this.assertBlockExpressions;
        }

        public Map<RfFileDef, Map<IHidOperator, RfField>> getAssignedCalls() {
            return this.assignedCalls;
        }

        public Class<IHidOperator> getType() {
            return IHidOperator.class;
        }
    }

    class LocalHidOperatorVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;
        private RfNamedElement scope;
        private OVMComplianceCheck check;
        private Set<HidOccurrenceBounds> castedHids = new HashSet<HidOccurrenceBounds>();
        private Map<RfFileDef, Map<IHidOperator, RfField>> assignedCalls;
        private Set<IHidOperator> checkedCalls;
        private Map<RfHid, List<HidOccurrenceBounds>> ifBlockExpressions;
        private Map<RfHid, List<HidOccurrenceBounds>> assertBlockExpressions;
        Map<RfHid, RfAssertExpect> hidsToAssertions;

        public LocalHidOperatorVisitor(Map<RfFileDef, Map<IHidOperator, RfField>> assignedCalls, Map<RfHid, List<HidOccurrenceBounds>> ifBlockExpressions, Map<RfHid, List<HidOccurrenceBounds>> assertBlockExpressions, OVMComplianceCheck check) {
            this.assignedCalls = assignedCalls;
            this.checkedCalls = new HashSet<IHidOperator>();
            this.ifBlockExpressions = ifBlockExpressions;
            this.assertBlockExpressions = assertBlockExpressions;
            if (!AbstractCheckCallsInIfAndAssert.this.pCheckFailureMacros.isEmpty()) {
                this.hidsToAssertions = this.mapHidsToAssertions(AbstractCheckCallsInIfAndAssert.this.fOVMProject.getAllAssertsExpects());
            }
            this.check = check;
        }

        public Set<IHidOperator> getCheckedCalls() {
            return this.checkedCalls;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            if (this.castedHids != null && !this.castedHids.isEmpty()) {
                this.castedHids.clear();
            }
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        private Map<RfHid, RfAssertExpect> mapHidsToAssertions(NullProtectedList<RfNamedElement> assertions) {
            IdentityHashMap<RfHid, RfAssertExpect> hidsToAssertions = new IdentityHashMap<RfHid, RfAssertExpect>();
            for (RfNamedElement assertion : assertions) {
                RfAssertExpect tmpAssertion;
                Map hidsMap;
                if (AbstractCheckCallsInIfAndAssert.this.checkPrewaivers(assertion.getFile().getParserPath()) || (hidsMap = (tmpAssertion = (RfAssertExpect)assertion).getHidHolder().getHidObjectsMap()) == null) continue;
                Collection vals = hidsMap.values();
                for (ListContainer hids : vals) {
                    for (IHidObject hid : hids) {
                        ListContainer parentAccessArgs;
                        if (!(hid instanceof RfHid)) continue;
                        RfHid rfHid = (RfHid)hid;
                        IRfNamedElement element = rfHid.getElement();
                        Set<IRfNamedElement> elements = new HashSet<IRfNamedElement>();
                        if (element != null) {
                            elements.add(element);
                        } else if (AbstractCheckCallsInIfAndAssert.this.pAnalyzeTypeParameterAccessValue) {
                            elements = AbstractCheckCallsInIfAndAssert.this.searchForPotentialFunctions(rfHid, this.check, this.parserPath, this.scope);
                        }
                        if (element instanceof RfField || AbstractCheckCallsInIfAndAssert.this.isSearchedCall(elements)) {
                            hidsToAssertions.put(rfHid, tmpAssertion);
                        }
                        if ((parentAccessArgs = rfHid.getAccesses()) == null) continue;
                        for (HidAccess access : parentAccessArgs) {
                            ListContainer accessHids = access.getHids();
                            if (accessHids == null) continue;
                            for (Hid accessHid : accessHids) {
                                IRfNamedElement accessElement;
                                if (!(accessHid instanceof RfHid) || !((accessElement = accessHid.getElement()) instanceof RfField) && !AbstractCheckCallsInIfAndAssert.this.isSearchedCall(new HashSet<IRfNamedElement>(Arrays.asList(accessElement)))) continue;
                                hidsToAssertions.put((RfHid)accessHid, tmpAssertion);
                            }
                        }
                    }
                }
            }
            return hidsToAssertions;
        }

        public boolean visit(IHidObject hidObject) {
            if (this.scope != null && this.scope.getFile() != null && AbstractCheckCallsInIfAndAssert.this.fOVMProject.isOVMFile(this.scope.getFile().getName())) {
                return true;
            }
            if (AbstractCheckCallsInIfAndAssert.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            RfFileDef filedef = AbstractCheckCallsInIfAndAssert.this.fOVMProject.getRfProject().getFileDefUsingParserPath(this.parserPath);
            if (filedef == null) {
                return true;
            }
            if (hidObject instanceof RfHidOperator) {
                this.handleOperator(filedef, (RfHidOperator)hidObject);
            }
            if (hidObject instanceof RfHid) {
                this.handleHid(filedef, (RfHid)hidObject);
            }
            return true;
        }

        private void handleHid(RfFileDef filedef, RfHid hid) {
            Map<IHidOperator, RfField> callsOnFiledef;
            IRfNamedElement element = HidUtils.getResolvedElement((IHidObject)hid);
            Set<IRfNamedElement> elements = new HashSet<IRfNamedElement>();
            if (element != null) {
                elements.add(element);
            } else if (AbstractCheckCallsInIfAndAssert.this.pAnalyzeTypeParameterAccessValue) {
                elements = AbstractCheckCallsInIfAndAssert.this.searchForPotentialFunctions(hid, this.check, this.parserPath, this.scope);
            }
            if (!AbstractCheckCallsInIfAndAssert.this.isSearchedCall(elements)) {
                return;
            }
            AbstractCheckCallsInIfAndAssert.this.notifyCheckAlive();
            HidOccurrence hidOccurrence = hid.getOccurrence();
            if (hidOccurrence == null) {
                return;
            }
            ReparseInfo reparseInfo = (ReparseInfo)hidOccurrence.getReparseInfo(ReparseInfo.class);
            int virtualOffset = hidOccurrence.getVirtualOffset();
            int offset = hidOccurrence.getOffset();
            if (this.ifBlockExpressions.containsKey((Object)hid) && this.isInBounds(offset, virtualOffset, (Collection<HidOccurrenceBounds>)this.ifBlockExpressions.get((Object)hid))) {
                if (!AbstractCheckCallsInIfAndAssert.this.pCheckFailureMacros.isEmpty() && !this.ifReportsOnFailure(hid)) {
                    AbstractCheckCallsInIfAndAssert.this.addHitForCheck(this.parserPath, hidOccurrence.getLine(), String.valueOf(HidUtils.toNiceString((IHidObject)hid)) + " does not have potential failures reported with the report macros!", reparseInfo, new VerissimoAutofixAdditionalInfo((Object)hid));
                }
                return;
            }
            if (!AbstractCheckCallsInIfAndAssert.this.pAllowOnlyIfCheckingValue && this.assertBlockExpressions.containsKey((Object)hid) && this.isInBounds(offset, virtualOffset, (Collection<HidOccurrenceBounds>)this.assertBlockExpressions.get((Object)hid))) {
                if (!AbstractCheckCallsInIfAndAssert.this.pCheckFailureMacros.isEmpty() && !this.assertReportsOnFailure(hid)) {
                    AbstractCheckCallsInIfAndAssert.this.addHitForCheck(this.parserPath, hidOccurrence.getLine(), String.valueOf(HidUtils.toNiceString((IHidObject)hid)) + " does not have potential failures reported with the report macros!", reparseInfo, new VerissimoAutofixAdditionalInfo((Object)hid));
                }
                return;
            }
            if (!AbstractCheckCallsInIfAndAssert.this.pCheckCondition && !AbstractCheckCallsInIfAndAssert.this.pAllowOnlyIfCheckingValue && hidOccurrence.hasQualifier(HidQualifier.HID_IS_IF_CASE_LOOP_EXPR)) {
                return;
            }
            if (AbstractCheckCallsInIfAndAssert.this.pSkipCallsCastedToVoidValue && this.isInBounds(offset, virtualOffset, this.castedHids)) {
                return;
            }
            if (this.assignedCalls != null && AbstractCheckCallsInIfAndAssert.this.pAllowTempVariableCheckingValue && (callsOnFiledef = this.assignedCalls.get(filedef)) != null && !callsOnFiledef.isEmpty()) {
                for (IHidOperator call : callsOnFiledef.keySet()) {
                    HidOccurrenceBounds bound;
                    HidOperatorOccurrence occurence = call.getOccurrence();
                    if (occurence == null || (bound = occurence.getBounds()) == null || !bound.contains(offset, virtualOffset)) continue;
                    return;
                }
            }
            AbstractCheckCallsInIfAndAssert.this.addHitForCheck(this.parserPath, hidOccurrence.getLine(), String.valueOf(HidUtils.toNiceString((IHidObject)hid)) + " is not properly checked!", reparseInfo, new VerissimoAutofixAdditionalInfo((Object)hid));
        }

        private boolean assertReportsOnFailure(RfHid hid) {
            RfAssertExpect tmpAssertion = this.hidsToAssertions.get((Object)hid);
            if (tmpAssertion == null) {
                return false;
            }
            MacroCallVisitor visitor = new MacroCallVisitor();
            tmpAssertion.visitHidObject(AbstractCheckCallsInIfAndAssert.this.fOVMProject.getRfProject(), visitor);
            return visitor.isFound();
        }

        private boolean ifReportsOnFailure(RfHid hid) {
            for (HidOccurrenceBounds occurenceBounds : this.ifBlockExpressions.get((Object)hid)) {
                RfNamedElement namedElement;
                MacroCallVisitor visitor = new MacroCallVisitor();
                RfDefElement ifScope = this.scope.getFile().getScope(occurenceBounds.closeBoundary + 1, true);
                if (ifScope == null || (namedElement = ifScope.getNamedElement()) == null || !(namedElement instanceof RfActionBlock) || !((RfActionBlock)namedElement).isIf()) continue;
                namedElement.visitHidObject(AbstractCheckCallsInIfAndAssert.this.fOVMProject.getRfProject(), visitor);
                if (!visitor.isFound()) continue;
                return true;
            }
            return false;
        }

        private boolean isInBounds(int offset, int virtualOffset, Collection<HidOccurrenceBounds> occurenceBounds) {
            if (occurenceBounds == null || occurenceBounds.isEmpty()) {
                return false;
            }
            return occurenceBounds.stream().anyMatch(bound -> bound.contains(offset, virtualOffset));
        }

        private void handleOperator(RfFileDef filedef, RfHidOperator operator) {
            boolean isCastedHid;
            Set callHids;
            IHidObject hid2;
            HidOperatorOccurrence operatorOccurrence = operator.getOccurrence();
            if (operatorOccurrence == null) {
                return;
            }
            AbstractCheckCallsInIfAndAssert.this.notifyCheckAlive();
            Map<IHidOperator, RfField> valuesMap = this.assignedCalls.get(filedef);
            if (operatorOccurrence.hasQualifier(HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION)) {
                List<RfHid> ifHids;
                if (!AbstractCheckCallsInIfAndAssert.this.pAllowTempVariableCheckingValue || valuesMap == null) {
                    return;
                }
                boolean isIfCondition = operator.isIfCondition();
                if (AbstractCheckCallsInIfAndAssert.this.pCheckCondition && !isIfCondition) {
                    return;
                }
                if (!AbstractCheckCallsInIfAndAssert.this.pCheckFailureMacros.isEmpty()) {
                    if (!isIfCondition) {
                        return;
                    }
                    MacroCallVisitor visitor = new MacroCallVisitor();
                    if (this.scope == null || !(this.scope instanceof RfActionBlock) || !((RfActionBlock)this.scope).isIf()) {
                        return;
                    }
                    this.scope.visitHidObject(AbstractCheckCallsInIfAndAssert.this.fOVMProject.getRfProject(), visitor);
                    if (!visitor.isFound()) {
                        return;
                    }
                }
                if ((ifHids = AbstractCheckCallsInIfAndAssert.this.getBlockRfHids(operator.getLHValue(), BlockType.IF)) == null || ifHids.isEmpty()) {
                    return;
                }
                hid2 = (IHidObject)ifHids.get(0);
                if (!(hid2 instanceof RfHid)) {
                    return;
                }
                IRfNamedElement element = ((RfHid)hid2).getElement();
                if (!(element instanceof RfField)) {
                    return;
                }
                if (!valuesMap.containsValue(element)) {
                    return;
                }
                RfNamedElement ifConditionScope = this.scope instanceof RfActionBlock ? this.scope.getEnclosingScope() : this.scope;
                List<IHidOperator> calls = AbstractCheckCallsInIfAndAssert.getCallsCheckedByCondition(element, operatorOccurrence, ifConditionScope, filedef, valuesMap);
                this.checkedCalls.addAll(calls);
            }
            if ((callHids = HidUtils.flattenToHids((IHidObject)operator, AbstractCheckCallsInIfAndAssert.this.HID_FLATTENING)) == null || callHids.isEmpty()) {
                return;
            }
            if (!AbstractCheckCallsInIfAndAssert.this.pAllowOnlyIfCheckingValue && operatorOccurrence.hasQualifier(HidOperatorQualifier.IS_ASSERT_EXPRESSION) && AbstractCheckCallsInIfAndAssert.this.pAllowTempVariableCheckingValue && valuesMap != null) {
                List<RfHid> assertHids = AbstractCheckCallsInIfAndAssert.this.getBlockRfHids(operator.getLHValue(), BlockType.ASSERT);
                if (assertHids == null || assertHids.isEmpty()) {
                    return;
                }
                hid2 = (IHidObject)assertHids.get(0);
                if (!(hid2 instanceof RfHid)) {
                    return;
                }
                RfHid assertHid = (RfHid)hid2;
                if (!AbstractCheckCallsInIfAndAssert.this.pCheckFailureMacros.isEmpty() && !this.assertReportsOnFailure(assertHid)) {
                    return;
                }
                IRfNamedElement field = assertHid.getElement();
                if (!(field instanceof RfField)) {
                    return;
                }
                if (!valuesMap.containsValue(field)) {
                    return;
                }
                RfNamedElement assertConditionScope = this.scope instanceof RfAssertExpect ? this.scope.getEnclosingScope() : this.scope;
                this.checkedCalls.addAll(AbstractCheckCallsInIfAndAssert.getCallsCheckedByCondition(field, operatorOccurrence, assertConditionScope, filedef, valuesMap));
            }
            if (AbstractCheckCallsInIfAndAssert.this.pSkipCallsCastedToVoidValue && operator.isVoidCast() && (isCastedHid = callHids.stream().anyMatch(hid -> AbstractCheckCallsInIfAndAssert.this.isSearchedCall(new HashSet<IRfNamedElement>(Arrays.asList(HidUtils.getResolvedElement((IHidObject)hid))))))) {
                this.castedHids.add(operatorOccurrence.getBounds());
            }
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    class MacroCallVisitor
    implements IHidVisitor<RfHid> {
        private boolean found;

        MacroCallVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            IReparseInfo reparseInfo = hidObject.getReparseInfo();
            if (reparseInfo == null) {
                return true;
            }
            if (AbstractCheckCallsInIfAndAssert.this.pCheckFailureMacros.contains("`" + reparseInfo.getLastReparseMacroName())) {
                this.found = true;
                return false;
            }
            return true;
        }

        public boolean isFound() {
            return this.found;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

