/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.parser.ReparseInfo;

public abstract class AbstractCheckUndocumentedApiUsages
extends OVMComplianceCheck {
    private static final String HAS_BANNED_TYPE = "{0} has banned type {1}!";
    private static final String INHERITS_ONLY_FROM_BANNED_CLASSES = "{0} inherits from banned classes!";

    public AbstractCheckUndocumentedApiUsages(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    private boolean inheritsOnlyBannedClasses(RfClass element) {
        if (this.checkClassParentAlias(element)) {
            return !this.testParentDataType(element, candidate -> !this.isBannedCategory((RfNamedElement)candidate));
        }
        if (element.getParent() == null) {
            return false;
        }
        RfClass parent = element.getParent();
        while (parent != null) {
            if (!this.isBannedCategory(parent)) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    @Override
    public void performCheckImpl() {
        RfProject project = this.fOVMProject.getRfProject();
        RfClass[] allClasses = project.getAllClasses();
        if (allClasses != null) {
            RfClass[] rfClassArray = allClasses;
            int n = allClasses.length;
            int n2 = 0;
            while (n2 < n) {
                RfClass current = rfClassArray[n2];
                if (this.inheritsOnlyBannedClasses(current)) {
                    this.addHit(current, this.getInheritBannedMessage(current), null);
                }
                ++n2;
            }
        }
        IRfNamedElementVisitor visitor = namedElement -> {
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            if (namedElement instanceof RfPredefinedField || namedElement instanceof RfResultImplicitVariable) {
                return true;
            }
            RfField field = (RfField)namedElement;
            IRfNamedElement type = field.getAssociatedType();
            if (!(type instanceof RfNamedElement)) {
                return true;
            }
            RfNamedElement element = (RfNamedElement)type;
            if (this.isBannedCategory(element)) {
                this.addHit(field, this.getBannedMessage(field, element), null);
            }
            return false;
        };
        project.accept(visitor);
        project.visitHidObject(null, new IHidVisitor<RfHid>(){
            private ParserPath parserPath;

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(RfHid hid) {
                ReparseInfo reparseInfo;
                String macroName;
                IReparseInfo iReparseInfo = hid.getReparseInfo();
                if (iReparseInfo instanceof ReparseInfo && AbstractCheckUndocumentedApiUsages.this.isAllowedMacro(macroName = (reparseInfo = (ReparseInfo)iReparseInfo).getLastReparseMacroName())) {
                    return true;
                }
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfNamedElement) || !AbstractCheckUndocumentedApiUsages.this.isBannedCategory((RfNamedElement)element)) {
                    return true;
                }
                HidOccurrence occurence = hid.getOccurrence();
                if (occurence == null) {
                    return true;
                }
                AbstractCheckUndocumentedApiUsages.this.addHit(this.parserPath, occurence, AbstractCheckUndocumentedApiUsages.this.getMessage(element));
                return true;
            }

            public Class<RfHid> getType() {
                return RfHid.class;
            }
        });
    }

    protected String getBannedMessage(RfField field, RfNamedElement element) {
        return MessageFormat.format(HAS_BANNED_TYPE, field.getFullName(), element.getFullName());
    }

    protected String getInheritBannedMessage(RfClass current) {
        return MessageFormat.format(INHERITS_ONLY_FROM_BANNED_CLASSES, current.getFullName());
    }

    protected boolean testParentDataType(RfClass clazz, Predicate<RfNamedElement> predicate) {
        IRfNamedElement parentRaw;
        if (clazz.getExtendedType() == null) {
            return false;
        }
        RfNamedElement enclosingScope = clazz.getEnclosingScope();
        if (enclosingScope == null) {
            return false;
        }
        return this.checkClassParentAlias(clazz) && (parentRaw = this.internalComputeDataType(clazz, clazz.getExtendedType(), enclosingScope)) instanceof RfNamedElement && predicate.test((RfNamedElement)parentRaw);
    }

    protected IRfNamedElement internalComputeDataType(RfClass clazz, DataType dataType, RfNamedElement enclosingScope) {
        if (dataType == null) {
            return null;
        }
        RfNamedElement parentScope = clazz;
        DataType packageScope = dataType.getPackageScope();
        String parentName = dataType.getType();
        if (packageScope != null) {
            parentScope = enclosingScope.getPackageOrClassScope(packageScope.getType());
        }
        if (parentScope == null) {
            return null;
        }
        RfField candidate = null;
        if (parentScope instanceof RfNamedElement) {
            candidate = ((RfNamedElement)parentScope).getLocalMember(RfField.class, parentName, true);
        }
        if (candidate == null) {
            candidate = parentScope == this ? enclosingScope.getMember(parentName, RfClass.CLASS_PARENT_KIND, null, packageScope == null, true, false, true, false) : parentScope.getMember(parentName, RfClass.CLASS_PARENT_KIND, null, packageScope == null, true, false, true, false);
        }
        return candidate;
    }

    protected boolean checkClassParentAlias(RfClass clazz) {
        String resolvedParentName;
        if (clazz.getExtendedType() == null) {
            return false;
        }
        String string = resolvedParentName = clazz.getParent() != null ? clazz.getParent().getName() : null;
        return resolvedParentName != null && !resolvedParentName.equals(clazz.getExtendedType().getType());
    }

    protected abstract boolean isAllowedMacro(String var1);

    protected abstract String getMessage(IRfNamedElement var1);

    protected abstract boolean isBannedCategory(RfNamedElement var1);
}

