/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractClassUseCheck
extends OVMComplianceCheck {
    public AbstractClassUseCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected void performCheckBase() {
        HashSet<String> classMembersIteratorKeys = new HashSet<String>();
        classMembersIteratorKeys.add("field");
        classMembersIteratorKeys.add("function");
        classMembersIteratorKeys.add("task");
        classMembersIteratorKeys.add("type_parameter");
        for (RfClass eachClass : this.fOVMProject.getAllClasses()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(eachClass.getFile()) || this.skipClass(eachClass)) continue;
            RfClass parentClass = eachClass.getParent();
            if (parentClass != null && !this.isClassOKToUse(eachClass, parentClass)) {
                this.addHit(eachClass, "Class '" + eachClass.getFullName() + "' extends from a " + this.getSpecificMessage() + " '" + parentClass.getFullName() + "'!");
            }
            if (this.isOnlyInheritance()) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator(eachClass, classMembersIteratorKeys, true, null, null);
            while (classMembersIterator.hasNext()) {
                List<RfField> arguments;
                String memberInfo;
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null) continue;
                if (eachMember instanceof RfField) {
                    RfClass parameterClassType;
                    memberInfo = String.valueOf(eachClass.getFullName()) + "." + eachMember.getName();
                    if (((RfField)eachMember).isField()) {
                        RfClass associativeArrayKeyClassType;
                        RfClass fieldClassType = LintUtils.getFieldFinalClassTypeOrNull((RfField)eachMember);
                        if (fieldClassType != null && !this.isClassOKToUse(eachClass, fieldClassType)) {
                            this.addHit(eachMember, "Field '" + memberInfo + "' is of a " + this.getSpecificMessage() + " '" + fieldClassType.getFullName() + "'!");
                        }
                        if ((associativeArrayKeyClassType = LintUtils.getAssociativeArrayKeyClassType((RfField)eachMember)) == null || this.isClassOKToUse(eachClass, associativeArrayKeyClassType)) continue;
                        this.addHit(eachMember, "Field '" + memberInfo + "' is an associative array with a key of a " + this.getSpecificMessage() + " '" + associativeArrayKeyClassType.getFullName() + "'!");
                        continue;
                    }
                    if (!((RfField)eachMember).isTypeParameter() || (parameterClassType = LintUtils.getFieldFinalClassTypeOrNull((RfField)eachMember)) == null || this.isClassOKToUse(eachClass, parameterClassType)) continue;
                    this.addHit(eachMember, "Type parameter '" + eachMember.getName() + "' of '" + eachClass.getFullName() + "' is of a " + this.getSpecificMessage() + " '" + parameterClassType.getFullName() + "'!");
                    continue;
                }
                if (!(eachMember instanceof RfFunction)) continue;
                memberInfo = String.valueOf(eachClass.getFullName()) + "." + eachMember.getName() + "()";
                RfClass functionResultClassType = LintUtils.getFunctionResultFinalClassTypeOrNull((RfFunction)eachMember);
                if (functionResultClassType != null && !this.isClassOKToUse(eachClass, functionResultClassType)) {
                    this.addHit(eachMember, "Result of '" + memberInfo + "' is of a " + this.getSpecificMessage() + " '" + functionResultClassType.getFullName() + "'!");
                }
                if ((arguments = eachMember.getArgumentsWithPrefix("", 2)) == null || arguments.isEmpty()) continue;
                for (RfField argument : arguments) {
                    RfClass associativeArrayKeyClassType;
                    if (argument == null) continue;
                    String argumentName = argument.getName();
                    RfClass argumentClassType = LintUtils.getFieldFinalClassTypeOrNull(argument);
                    if (argumentClassType != null && !this.isClassOKToUse(eachClass, argumentClassType)) {
                        this.addHit(argument, "Argument '" + argumentName + "' of '" + memberInfo + "' is of a " + this.getSpecificMessage() + " '" + argumentClassType.getFullName() + "'!");
                    }
                    if ((associativeArrayKeyClassType = LintUtils.getAssociativeArrayKeyClassType(argument)) == null || this.isClassOKToUse(eachClass, associativeArrayKeyClassType)) continue;
                    this.addHit(eachMember, "Argument '" + argumentName + "' of '" + memberInfo + "' is an associative array with a key of a " + this.getSpecificMessage() + " '" + associativeArrayKeyClassType.getFullName() + "'!");
                }
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    protected abstract boolean skipClass(RfClass var1);

    protected abstract boolean isClassOKToUse(RfClass var1, RfClass var2);

    protected abstract String getSpecificMessage();

    protected abstract boolean isOnlyInheritance();
}

