/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractCommentCheck
extends OVMComplianceCheck {
    protected static final String CONSTRAINT_STRING = "constraint";
    protected static final String TASK_STRING = "task";
    protected static final String FUNCTION_STRING = "function";
    protected static final String CONSTRUCTOR_STRING = "constructor";
    protected static final String CONSTRAINT_EXTERN_IMPLEMENTATION_STRING = "constraint_extern_implementation";
    protected static final String TASK_EXTERN_IMPLEMENTATION_STRING = "task_extern_implementation";
    protected static final String FUNCTION_EXTERN_IMPLEMENTATION_STRING = "function_extern_implementation";
    protected static final String CONSTRUCTOR_EXTERN_IMPLEMENTATION_STRING = "constructor_extern_implementation";

    public AbstractCommentCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected List<RfDefElement> getDefinitionsToCheck(RfNamedElement eachMember, HashSet<String> memberKindsValue) {
        boolean noFunctionOrConstraint;
        ArrayList<RfDefElement> result = new ArrayList<RfDefElement>();
        RfDefElement declaration = eachMember.getDeclaration();
        if (declaration == null) {
            return result;
        }
        RfDefElement implementation = eachMember.getImplementation();
        boolean isSameDeclaration = implementation == null || declaration == implementation;
        boolean bl = noFunctionOrConstraint = !(eachMember instanceof RfFunction) && !(eachMember instanceof RfConstraint);
        if (isSameDeclaration && noFunctionOrConstraint) {
            result.add(declaration);
            return result;
        }
        if (eachMember instanceof RfFunction) {
            if (((RfFunction)eachMember).isFunction()) {
                if (memberKindsValue.contains(FUNCTION_STRING)) {
                    result.add(declaration);
                }
                if (memberKindsValue.contains(FUNCTION_EXTERN_IMPLEMENTATION_STRING) && !isSameDeclaration) {
                    result.add(implementation);
                }
            } else if (((RfFunction)eachMember).isTask()) {
                if (memberKindsValue.contains(TASK_STRING)) {
                    result.add(declaration);
                }
                if (memberKindsValue.contains(TASK_EXTERN_IMPLEMENTATION_STRING) && !isSameDeclaration) {
                    result.add(implementation);
                }
            } else if (((RfFunction)eachMember).isConstructor()) {
                if (memberKindsValue.contains(CONSTRUCTOR_STRING)) {
                    result.add(declaration);
                }
                if (memberKindsValue.contains(CONSTRUCTOR_EXTERN_IMPLEMENTATION_STRING) && !isSameDeclaration) {
                    result.add(implementation);
                }
            }
        } else if (eachMember instanceof RfConstraint) {
            if (memberKindsValue.contains(CONSTRAINT_STRING)) {
                result.add(declaration);
            }
            if (memberKindsValue.contains(CONSTRAINT_EXTERN_IMPLEMENTATION_STRING) && !isSameDeclaration) {
                result.add(implementation);
            }
        }
        return result;
    }
}

