/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

public abstract class AbstractCrossModuleReferenceCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="full, upward", description="Comma separated list of module reference types that are going to be checked: full, upward, downward.", name="moduleReferenceTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pModuleReferenceTypes;
    @CheckParameter(defaultValue="", description="Comma separated list of design element paths to hierarchies that are going to be checked. If empty, any XMR is a candidate.", name="include", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pInclude;
    protected boolean checkFullReference;
    protected boolean checkUpwardReference;
    protected boolean checkDownwardReference;
    protected Set<RfNamedElement> topModules;
    protected Map<IRfInstanceElement, ElementPath> includedInstances;
    protected Map<IRfDesignElement, ElementPath> includedDesingElements;
    private Map<ElementPath, Set<IRfInstanceElement>> childrenOfElementPathCache;
    private Map<RfNamedElement, List<ELInstance>> scopeInstancesCache;

    protected AbstractCrossModuleReferenceCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkFullReference = this.pModuleReferenceTypes.contains("full");
        this.checkUpwardReference = this.pModuleReferenceTypes.contains("upward");
        this.checkDownwardReference = this.pModuleReferenceTypes.contains("downward");
        this.childrenOfElementPathCache = new HashMap<ElementPath, Set<IRfInstanceElement>>();
        this.scopeInstancesCache = new HashMap<RfNamedElement, List<ELInstance>>();
        this.topModules = this.checkFullReference ? LintUtils.getTopModules(this.fOVMProject) : new HashSet<RfNamedElement>();
        this.getIncludeInstances();
    }

    protected void getIncludeInstances() {
        this.includedInstances = new HashMap<IRfInstanceElement, ElementPath>();
        this.includedDesingElements = new HashMap<IRfDesignElement, ElementPath>();
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
        if (memory == null) {
            return;
        }
        for (String include : this.pInclude) {
            ELInstance element = memory.instanceFor(ElementPath.from((String)include, (String)"."));
            if (element == null) continue;
            IRfInstanceElement description = element.getDescription();
            if (description instanceof DummyInstance) {
                this.includedDesingElements.put(((DummyInstance)description).design, element.getHierarchyPath());
                continue;
            }
            this.includedInstances.put(element.getDescription(), element.getHierarchyPath());
        }
    }

    protected ElementPath getElemntPath(Hid hid, IELMemory memory) {
        DVTStringBuilder path = new DVTStringBuilder();
        Hid parentHid = hid;
        path.append(parentHid.getName());
        while (parentHid.getParentHid() != null) {
            parentHid = parentHid.getParentHid();
            path.prepend(String.valueOf(parentHid.getName()) + ".");
        }
        IRfNamedElement parentElement = parentHid.getElement();
        if (!(parentElement instanceof RfInstanceHolder) && !(parentElement instanceof RfInstance)) {
            return null;
        }
        if (this.topModules.contains(parentElement)) {
            return ElementPath.from((String)path.toString(), (String)".");
        }
        for (String includePaths : this.pInclude) {
            String[] splits;
            StringBuilder prefix = new StringBuilder("");
            String[] stringArray = splits = DVTStringUtil.split((String)".", (String)includePaths);
            int n = splits.length;
            int n2 = 0;
            while (n2 < n) {
                ELInstance instance;
                String split = stringArray[n2];
                prefix.append(String.valueOf(split) + ".");
                ElementPath elementPath = ElementPath.from((String)(String.valueOf(prefix.toString()) + path), (String)".");
                if (elementPath != null && (instance = memory.instanceFor(elementPath)) != null) {
                    return elementPath;
                }
                ++n2;
            }
        }
        return null;
    }

    protected boolean shouldAnalyzeXMR(RfHid hid, RfNamedElement scope) {
        if (hid == null) {
            return false;
        }
        if (hid.getParentAccess() == null || hid.getParentHid() == null) {
            return false;
        }
        Hid parentHid = hid.getParentHid();
        while (parentHid.getParentHid() != null) {
            parentHid = parentHid.getParentHid();
        }
        IRfNamedElement parentElement = parentHid.getElement();
        if (!(parentElement instanceof RfInstanceHolder) && !(parentElement instanceof RfInstance)) {
            return false;
        }
        if (this.checkFullReference && this.topModules.contains(parentElement)) {
            return true;
        }
        IRfNamedElement tempScope = scope.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfModule.class, RfInstance.class, RfProgram.class, RfInterface.class)));
        if (!(tempScope instanceof RfNamedElement)) {
            return false;
        }
        scope = (RfNamedElement)tempScope;
        if (parentElement instanceof RfInstance) {
            boolean isDownWard = false;
            IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
            if (memory == null) {
                return false;
            }
            List instances = this.scopeInstancesCache.get(scope);
            if (instances == null) {
                instances = memory.getInstancesFor((IRfNamedElement)scope, false, 1);
                this.scopeInstancesCache.put(scope, instances);
            }
            if (instances.isEmpty()) {
                return false;
            }
            ElementPath scopePath = ((ELInstance)instances.get(0)).getHierarchyPath();
            Set<IRfInstanceElement> members = this.childrenOfElementPathCache.get(scopePath);
            if (members == null) {
                Map subtree = memory.subtreeOf(scopePath, false);
                members = new HashSet<IRfInstanceElement>();
                for (Map.Entry entry : subtree.entrySet()) {
                    if (!scopePath.isDirectParentOf((ElementPath)entry.getKey())) continue;
                    members.add(((ELInstance)entry.getValue()).getDescription());
                }
                this.childrenOfElementPathCache.put(scopePath, members);
            }
            if (members != null && !members.isEmpty() && members.contains(parentElement)) {
                isDownWard = true;
            }
            if (this.checkDownwardReference && isDownWard) {
                return true;
            }
            if (this.checkUpwardReference && !isDownWard) {
                return true;
            }
        }
        return false;
    }
}

