/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractForbiddenMethodsCheck
extends OVMComplianceCheck {
    protected String fArrayName = "";

    public AbstractForbiddenMethodsCheck(OVMProject project, OVMComplianceCategory category, String arrayName) {
        super(project, category);
        this.fArrayName = arrayName;
    }

    @Override
    public void performCheckImpl() {
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                AbstractForbiddenMethodsCheck.this.notifyCheckAlive();
                if (!AbstractForbiddenMethodsCheck.this.isForbiddenMethod(hidObject.getName())) {
                    return true;
                }
                HidAccess parentAccess = hidObject.getParentAccess();
                if (parentAccess == null || parentAccess.getAccessKind() != 0) {
                    return true;
                }
                if (!AbstractForbiddenMethodsCheck.this.isOfCheckedType((RfNamedElement)parentAccess.getAssociatedType())) {
                    return true;
                }
                String completeName = String.valueOf(HidUtils.toNiceString((IHidObject)parentAccess)) + hidObject.getName();
                AbstractForbiddenMethodsCheck.this.addHit(this.parserPath, hidObject, "Forbidden " + AbstractForbiddenMethodsCheck.this.fArrayName + " call '" + completeName + "'!");
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
    }

    protected abstract boolean isForbiddenMethod(String var1);

    protected abstract boolean isOfCheckedType(IRfScope var1);
}

