/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.parser.ReparseInfo;

public abstract class AbstractFormattingDisabledCheck
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="false", description="When true, hits will not be reported if the code is encapsulated by a @formatter:off/on pragma.", name="skipSectionsWithFormatterDisabled", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN, isVisible=false)
    protected boolean pSkipSectionsWithFormatterDisabled;

    protected AbstractFormattingDisabledCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public OVMComplianceHit addHit(ParserPath file, int line, String details, ReparseInfo reparseInfo, boolean force, CheckStatus severity, VerissimoAutofixAdditionalInfo autofixAdditionalInfo, boolean isHidden) {
        if (this.pSkipSectionsWithFormatterDisabled && this.checkIfHitIsInPragmas(this.getWSParser().getFormattingPragmas(file), line)) {
            return null;
        }
        return super.addHit(file, line, details, reparseInfo, force, severity, autofixAdditionalInfo, isHidden);
    }

    protected boolean checkIfHitIsInPragmas(Set<DVTPair<Integer, Integer>> formattingPragmas, int line) {
        if (formattingPragmas == null || formattingPragmas.isEmpty()) {
            return false;
        }
        for (DVTPair<Integer, Integer> pair : formattingPragmas) {
            if ((Integer)pair.getValue() < line) continue;
            if ((Integer)pair.getKey() > line) {
                return false;
            }
            if ((Integer)pair.getKey() > line || line > (Integer)pair.getValue()) continue;
            return true;
        }
        return false;
    }
}

