/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;

public abstract class AbstractFourStateCastCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="In SystemVerilog time is a 4 state 64 bit. To avoid useless failed hits, by default this rule handles time as a 2 state type.", name="handleTimeAsFourState", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pHandleTimeAsFourStateValue;
    @CheckParameter(defaultValue="false", description="When true only the following guard pattern is allowed:\n function void bit_func(bit bit_var);\n endfunction\n\n if($isunknown(logic_var)) // there must be an if action block with the $isunknown(name) condition before the assignment oe the method call\n  ... \n bit_var = logic_var;\n bit_func(logic_var);", name="useIsUnknownGuard", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pUseIsUnknownGuardValue;
    protected Map<IRfNamedElement, Set<RfHid>> fields = new HashMap<IRfNamedElement, Set<RfHid>>();

    protected AbstractFourStateCastCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected IHidObject getFirstConditionalWithExpressionBlock(IRfScope scope) {
        IRfScope enclScope = scope;
        while (enclScope != null) {
            if (enclScope instanceof RfActionBlock) {
                RfActionBlock actionBlock = (RfActionBlock)enclScope;
                if (actionBlock.isConditionalWithExpression()) {
                    return actionBlock.getConditionalBlockExpression();
                }
                if (actionBlock.isElse()) {
                    return this.getElseCondition(enclScope);
                }
            }
            enclScope = enclScope.getEnclosingScope();
        }
        return null;
    }

    private IHidObject getElseCondition(IRfScopeElement elseBlock) {
        IRfScopeElement enclosingScope = elseBlock.getEnclosingScope();
        if (!(enclosingScope instanceof RfNamedElement)) {
            return null;
        }
        Collection<RfNamedElement> members = ((RfNamedElement)enclosingScope).getMembers();
        RfActionBlock matchingActionBlock = null;
        for (RfNamedElement member : members) {
            if (!(member instanceof RfActionBlock)) continue;
            if (member.equals(elseBlock)) break;
            RfActionBlock memberBlock = (RfActionBlock)member;
            if (!memberBlock.isConditionalWithExpression()) continue;
            if (matchingActionBlock == null) {
                matchingActionBlock = memberBlock;
                continue;
            }
            if (matchingActionBlock.getDeclaration().getStartOffset() >= memberBlock.getDeclaration().getStartOffset() && (matchingActionBlock.getDeclaration().getStartOffset() != memberBlock.getDeclaration().getStartOffset() || matchingActionBlock.getDeclaration().getStartVirtualOffset() >= memberBlock.getDeclaration().getStartVirtualOffset())) continue;
            matchingActionBlock = memberBlock;
        }
        return matchingActionBlock == null ? null : matchingActionBlock.getConditionalBlockExpression();
    }

    protected void checkConditionalActionBlock(IRfNamedElement scope, IHidObject hidObject) {
        if (!this.fields.containsKey(scope)) {
            HashSet<RfHid> associatedFields = new HashSet<RfHid>();
            Set hids = HidUtils.flattenToHids((IHidObject)hidObject, (Set)HidFlatteningOption.NONE_EXCLUDED);
            if (this.pUseIsUnknownGuardValue) {
                for (IHid hid : hids) {
                    IRfNamedElement iRfNamedElement;
                    if (!(hid instanceof RfHid) || !((iRfNamedElement = hid.getElement()) instanceof RfPredefinedFunction) || !"$isunknown".equals(iRfNamedElement.getName())) continue;
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                    for (MethodCall methodCall : methodCalls) {
                        if (methodCall.argumentValuesMap == null) continue;
                        for (Map.Entry argumentEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                            Hid parentHid;
                            IRfNamedElement argumentKey = (IRfNamedElement)argumentEntry.getKey();
                            if (argumentKey == null || !argumentKey.getName().equals("expression")) continue;
                            IHidObject value = (IHidObject)argumentEntry.getValue();
                            if (value instanceof RfHid) {
                                associatedFields.add((RfHid)value);
                                continue;
                            }
                            if (!(value instanceof RfHidAccess) || !((parentHid = ((RfHidAccess)value).getParentHid()) instanceof RfHid)) continue;
                            associatedFields.add((RfHid)parentHid);
                        }
                    }
                }
            } else {
                for (IHid hid : hids) {
                    if (!(hid instanceof RfHid)) continue;
                    associatedFields.add((RfHid)hid);
                }
            }
            this.fields.put(scope, associatedFields);
        }
    }

    protected boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

