/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractFunctionCallingTasksCheck
extends OVMComplianceCheck {
    public AbstractFunctionCallingTasksCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected boolean allowForkJoinNone() {
        return true;
    }

    protected HashSet<String> getAllowedTasks() {
        return null;
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> allowedTasks = this.getAllowedTasks();
        final RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        final LocalHidVisitor hidVisitor = new LocalHidVisitor(allowedTasks);
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                RfFunction callerFunction;
                AbstractFunctionCallingTasksCheck.this.notifyCheckAlive();
                if (namedElement instanceof RfFunction && ((callerFunction = (RfFunction)namedElement).isFunction() || callerFunction.isConstructor())) {
                    hidVisitor.setCallerFunction((RfFunction)namedElement);
                    namedElement.visitHidObject(rfProject, hidVisitor);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        private RfFunction fCallerFunction;
        private HashSet<String> fAllowedTasks;

        LocalHidVisitor(HashSet<String> allowedTasks) {
            this.fAllowedTasks = allowedTasks;
        }

        public void setCallerFunction(RfFunction callerFunction) {
            this.fCallerFunction = callerFunction;
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement holderScope;
            RfFunction calledTask;
            AbstractFunctionCallingTasksCheck.this.notifyCheckAlive();
            if (hid == null) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (hidNamedElement instanceof RfFunction && ((RfFunction)hidNamedElement).isTask() && (!((calledTask = (RfFunction)hidNamedElement) instanceof RfPredefinedFunction) || !calledTask.getName().startsWith("$")) && this.holder instanceof RfHidHolder && (holderScope = ((HidHolder)this.holder).getScope()) instanceof RfNamedElement) {
                boolean insideForkJoinNone = false;
                if (AbstractFunctionCallingTasksCheck.this.allowForkJoinNone()) {
                    RfNamedElement scope = (RfNamedElement)holderScope;
                    while (scope != null) {
                        RfActionBlock actionBlock;
                        if (scope instanceof RfActionBlock && (actionBlock = (RfActionBlock)scope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE)) {
                            insideForkJoinNone = true;
                            break;
                        }
                        scope = scope.getEnclosingScope();
                    }
                }
                if (!(insideForkJoinNone || this.fAllowedTasks != null && this.fAllowedTasks.contains(hidNamedElement.getName()))) {
                    AbstractFunctionCallingTasksCheck.this.addHit(this.parserPath, hid, "Function '" + this.fCallerFunction.getFullName() + "()' calls task '" + calledTask.getFullName() + "()' outside fork/join_none!");
                }
            }
            return true;
        }
    }
}

