/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;

public abstract class AbstractHeaderCheck
extends OVMComplianceCheck {
    protected static final String DEFAULT_PATH = "default_path";
    protected static final Pattern WHITESPACE_PATTERN = Pattern.compile("[ \\t\\x0B\\f]+");
    @CheckParameter(defaultValue="", description="Comma separated list of full paths to files holding the header lines.", name="headerFilePath", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pHeaderFilePathValue;
    @CheckParameter(defaultValue="false", description="If set, the lines in the reference header file are interpreted as patterns.", name="patternMatch", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pPatternMatchValue;
    @CheckParameter(defaultValue="false", description="If set, mismatched lines are skipped. This allows for file specific lines in the header, for example author, description etc. It may have a performance impact.", name="skipMismatchedLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipMismatchedLinesValue;
    @CheckParameter(defaultValue="", description="Every file must have a header matching the value of this parameter or the headers specified by <headerFilePath>", name="headerValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pHeaderValue;

    protected AbstractHeaderCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        try {
            String[] lines;
            HashMap<String, String[]> headerLines = new HashMap<String, String[]>();
            HashMap<String, Pattern[]> headerPatterns = new HashMap<String, Pattern[]>();
            Pattern[] patterns = null;
            if (this.pHeaderValue.isEmpty() && this.pHeaderFilePathValue.isEmpty()) {
                return;
            }
            for (String headerFilePath : this.pHeaderFilePathValue) {
                String replacedPath = LintUtils.replaceAllSystemVariables(this.fOVMProject.getProject(), headerFilePath, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL);
                if (replacedPath == null) {
                    this.addHit(null, "Rule parameter '" + headerFilePath + "' contains invalid system variable!");
                    continue;
                }
                File headerFile = new File(replacedPath);
                if (!headerFile.canRead()) {
                    this.addHit(null, "Failed reading header file '" + headerFilePath + "'!");
                    continue;
                }
                byte[] buffer = null;
                buffer = new byte[(int)headerFile.length()];
                try {
                    Throwable throwable = null;
                    Object var11_20 = null;
                    try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(headerFile));){
                        if (inputStream.read(buffer) != (int)headerFile.length()) {
                            this.addHit(null, "Failed reading header file '" + headerFilePath + "'!");
                            continue;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                if (this.pPatternMatchValue) {
                    lines = DVTStringUtil.split((Pattern)DVTStringUtil.NEW_LINE, (String)new String(buffer));
                    patterns = new Pattern[lines.length];
                    boolean foundException = false;
                    int i = 0;
                    while (i < lines.length) {
                        try {
                            patterns[i] = Pattern.compile(lines[i]);
                        }
                        catch (PatternSyntaxException e) {
                            this.addHit(null, "Pattern line " + (i + 1) + " in the header file is invalid: " + e.getDescription());
                            foundException = true;
                        }
                        ++i;
                    }
                    if (foundException) continue;
                    headerLines.put(headerFilePath, lines);
                    headerPatterns.put(headerFilePath, patterns);
                    continue;
                }
                lines = DVTStringUtil.split((Pattern)DVTStringUtil.NEW_LINE, (String)DVTStringUtil.replaceAll((Pattern)WHITESPACE_PATTERN, (CharSequence)new String(buffer).toLowerCase(), (String)" "));
                int i = 0;
                while (i < lines.length) {
                    lines[i] = lines[i].trim();
                    ++i;
                }
                headerLines.put(headerFilePath, lines);
            }
            this.notifyCheckAlive();
            if (!this.pHeaderValue.isEmpty()) {
                this.pHeaderValue = this.removeEscaping(this.pHeaderValue);
                if (this.pPatternMatchValue) {
                    lines = DVTStringUtil.split((Pattern)DVTStringUtil.NEW_LINE, (String)this.pHeaderValue);
                    patterns = new Pattern[lines.length];
                    boolean foundException = false;
                    int i = 0;
                    while (i < lines.length) {
                        try {
                            patterns[i] = Pattern.compile(lines[i]);
                        }
                        catch (PatternSyntaxException e) {
                            this.fOVMProject.notifyCheckException(this, e);
                            this.addHit(null, "Pattern line " + (i + 1) + " in the headerValue parameter is invalid: " + e.getDescription());
                            foundException = true;
                        }
                        ++i;
                    }
                    if (!foundException) {
                        headerLines.put(DEFAULT_PATH, lines);
                        headerPatterns.put(DEFAULT_PATH, patterns);
                    }
                } else {
                    lines = DVTStringUtil.split((Pattern)DVTStringUtil.NEW_LINE, (String)DVTStringUtil.replaceAll((Pattern)WHITESPACE_PATTERN, (CharSequence)this.pHeaderValue.toLowerCase(), (String)" "));
                    int i = 0;
                    while (i < lines.length) {
                        lines[i] = lines[i].trim();
                        ++i;
                    }
                    headerLines.put(DEFAULT_PATH, lines);
                }
                this.pHeaderFilePathValue.add(DEFAULT_PATH);
            }
            if (headerLines.isEmpty()) {
                return;
            }
            this.analyzeHeaders(headerLines, headerPatterns);
            this.pHeaderFilePathValue.remove(DEFAULT_PATH);
        }
        catch (IOException e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String removeEscaping(String escapedString) {
        StringBuilder sb = new StringBuilder(escapedString);
        int index = sb.indexOf("\\n");
        while (index > 0) {
            sb.replace(index, index + 2, "\n");
            index = sb.indexOf("\\n");
        }
        return sb.toString();
    }

    protected abstract void analyzeHeaders(Map<String, String[]> var1, Map<String, Pattern[]> var2) throws IOException;
}

