/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

public abstract class AbstractIfndefGuardsCheck
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    protected static final String IFDEF = "`ifdef";
    protected static final String IFNDEF = "`ifndef";
    protected static final String ENDIF = "`endif";
    protected static final String DEFINE = "`define";
    protected Set<String> conditionalCompilerDirectives = new HashSet<String>(Arrays.asList("`ifdef", "`ifndef", "`endif"));
    protected List<String> guards = Arrays.asList("`ifndef", "`define", "`endif");

    protected AbstractIfndefGuardsCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        VlogPreprocessingInfo preprocessingTable = this.fOVMProject.getRfProject().getPreprocessingTable();
        Map<ParserPath, CodePreprocFileInfo> codePreprocFileInfos = preprocessingTable.getCodePreprocFileInfos();
        Set<ParserPath> filesToCheck = this.collectFiles();
        for (ParserPath parserPath : filesToCheck) {
            LiteralToken endifToken;
            LiteralToken ifndefToken;
            if (parserPath.path.indexOf("__vlog__") != -1 || this.fOVMProject.isOVMFile(parserPath.path) || this.checkPreWaivers(parserPath) || !this.shouldCheck(parserPath)) continue;
            File file = new File(parserPath.path);
            String defineName = this.getDefineName(file);
            if (defineName == null) {
                this.addHit(parserPath, 1, "Internal error while computing define name!", null);
                continue;
            }
            LiteralToken firstCodeToken = this.getWSParser().getFirstCodeToken(parserPath);
            if (firstCodeToken == null) continue;
            LiteralToken literalToken = ifndefToken = firstCodeToken.getStringToken().equals(IFNDEF) ? firstCodeToken : null;
            if (ifndefToken == null) {
                this.addHitForGuard(IFNDEF, parserPath, firstCodeToken.getLineNumber(), defineName);
                continue;
            }
            LiteralToken ifndefIdentifier = this.checkAndGetIfndefIdentifier(ifndefToken, parserPath, defineName);
            if (ifndefIdentifier == null) continue;
            this.checkDefineGuard(parserPath, defineName, ifndefIdentifier);
            LiteralToken lastCodeToken = this.getWSParser().getLastCodeToken(parserPath);
            if (lastCodeToken == null) continue;
            LiteralToken literalToken2 = endifToken = lastCodeToken.getStringToken().equals(ENDIF) ? lastCodeToken : null;
            if (endifToken == null) {
                this.addHitForGuard(ENDIF, parserPath, lastCodeToken.getLineNumber(), defineName);
                continue;
            }
            this.checkEndifComment(endifToken, parserPath, defineName);
            this.checkOutsideGuards(codePreprocFileInfos.get(parserPath), parserPath, defineName);
        }
    }

    public abstract Set<ParserPath> collectFiles();

    public abstract boolean shouldCheck(ParserPath var1);

    protected abstract void addHitForGuard(String var1, ParserPath var2, int var3, String var4);

    protected abstract void checkOutsideGuards(CodePreprocFileInfo var1, ParserPath var2, String var3);

    protected abstract void checkDefineGuard(ParserPath var1, String var2, LiteralToken var3);

    protected abstract void checkEndifComment(LiteralToken var1, ParserPath var2, String var3);

    protected abstract LiteralToken checkAndGetIfndefIdentifier(LiteralToken var1, ParserPath var2, String var3);

    public abstract String getDefineName(File var1);

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

