/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractLiteralComparison
extends OVMComplianceCheck {
    private static final Set<HidFlatteningOption> IGNORE_OBJECTS_IN_SELECT_SET = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));
    @CheckParameter(defaultValue="true", description="When true, comparisons of concatenation expressions will not be checked.", name="skipConcatenationComparison", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN, isVisible=false)
    private boolean pSkipConcatenationComparison;
    private static final Set<Integer> OPERATOR_TYPE_TOKENS = new HashSet<Integer>(Arrays.asList(482, 483, 484, 485, 502, 504, 486, 487, 488, 489));
    private final HidOperatorVisitor comparisonVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidOperator) {
            int operatorType = hidOperator.getOperatorType();
            if (!OPERATOR_TYPE_TOKENS.contains(operatorType)) {
                return true;
            }
            if (this.scope == null || !(this.scope instanceof RfNamedElement)) {
                return true;
            }
            if (hidOperator.isAssignment()) {
                return true;
            }
            if (AbstractLiteralComparison.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (this.isInConstraint((RfNamedElement)this.scope)) {
                return true;
            }
            if (AbstractLiteralComparison.this.fOVMProject.isOVMFile(LintUtils.getFileShortName(this.parserPath.path))) {
                return true;
            }
            AbstractLiteralComparison.this.notifyCheckAlive();
            AbstractLiteralComparison.this.checkHidOperator(this.parserPath, hidOperator);
            return true;
        }

        private boolean isInConstraint(RfNamedElement scope) {
            while (scope != null) {
                if (scope instanceof RfConstraint || scope instanceof RfActionBlock && ((RfActionBlock)scope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.WITH)) {
                    return true;
                }
                scope = scope.getEnclosingScope();
            }
            return false;
        }
    };
    IRfNamedElementVisitor caseVisitor = new IRfNamedElementVisitor(){

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfActionBlock)) {
                return true;
            }
            if (((RfActionBlock)namedElement).isCase() || ((RfActionBlock)namedElement).isCaseItem()) {
                RfHidHolder hidHolder = namedElement.getHidHolder();
                if (hidHolder == null) {
                    return true;
                }
                hidHolder.visitHidObject(AbstractLiteralComparison.this.fOVMProject.getRfProject(), (IHidVisitor)new IHidVisitor<IHidObject>(){
                    ParserPath parserPath;

                    public boolean visit(IHidObject hidObject) {
                        if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isCaseItemCondition()) {
                            if (AbstractLiteralComparison.this.checkPreWaivers(this.parserPath)) {
                                return true;
                            }
                            AbstractLiteralComparison.this.notifyCheckAlive();
                            if (AbstractLiteralComparison.this.fOVMProject.isOVMFile(LintUtils.getFileShortName(this.parserPath.path))) {
                                return true;
                            }
                            RfHidOperator hidOperator = (RfHidOperator)hidObject;
                            AbstractLiteralComparison.this.checkHidOperator(this.parserPath, hidOperator);
                        }
                        return true;
                    }

                    public Class<IHidObject> getType() {
                        return IHidObject.class;
                    }

                    public void setParserPath(ParserPath parserPath) {
                        this.parserPath = parserPath;
                    }
                });
            }
            return true;
        }
    };

    public AbstractLiteralComparison(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    protected DVTPair<Type, Object> findObjectType(IHid hidObject) {
        IRfNamedElement element;
        if (hidObject instanceof RfHidImplicit && !hidObject.getName().equals("default")) {
            return new DVTPair((Object)Type.LITERAL, null);
        }
        if (hidObject instanceof RfHid && (element = ((RfHid)hidObject).getElement()) instanceof RfField) {
            RfField fld = (RfField)element;
            IRfNamedElement assocType = fld.getAssociatedType();
            while (assocType instanceof RfTypeAlias) {
                assocType = ((RfTypeAlias)assocType).getAssociatedType();
            }
            if (assocType instanceof RfStruct && ((RfStruct)assocType).isEnum()) {
                return new DVTPair((Object)(fld.isEnumElement() ? Type.ENUM_ELEMENT : Type.FIELD_WITH_ENUM_DATATYPE), (Object)assocType);
            }
        }
        return new DVTPair((Object)Type.UNDETERMINED, null);
    }

    private void checkHidOperator(ParserPath path, HidOperator hidOperator) {
        Set rhValues;
        DVTPair<Type, Object> lhPair = null;
        DVTPair<Type, Object> rhPair = null;
        IHid lhValue = null;
        IHid rhValue = null;
        DVTPair<ListContainer<IHidObject>, ListContainer<IHidObject>> operatorHids = null;
        if (!this.pSkipConcatenationComparison && (operatorHids = this.isConcatenationComparison(hidOperator)) != null) {
            ListContainer lhValues = (ListContainer)operatorHids.getKey();
            ListContainer rhValues2 = (ListContainer)operatorHids.getValue();
            Iterator lhValuesIterator = lhValues.iterator();
            Iterator rhValuesIterator = rhValues2.iterator();
            IHidObject lhValueObject = null;
            IHidObject rhValueObject = null;
            while (lhValuesIterator.hasNext() && rhValuesIterator.hasNext()) {
                lhValueObject = (IHidObject)lhValuesIterator.next();
                rhValueObject = (IHidObject)rhValuesIterator.next();
                if (!(lhValueObject instanceof IHid) || !(rhValueObject instanceof IHid)) continue;
                lhValue = (IHid)lhValueObject;
                lhPair = this.findObjectType(lhValue);
                rhValue = (IHid)rhValueObject;
                rhPair = this.findObjectType(rhValue);
                this.checkComparison(path, hidOperator, lhValue, lhPair, rhValue, rhPair);
            }
            return;
        }
        Set lhValues = hidOperator.getLHHids(IGNORE_OBJECTS_IN_SELECT_SET);
        if (lhValues != null && lhValues.size() == 1) {
            lhValue = (IHid)lhValues.iterator().next();
            lhPair = this.findObjectType(lhValue);
        }
        if ((rhValues = hidOperator.getRHHids(IGNORE_OBJECTS_IN_SELECT_SET)) != null && rhValues.size() == 1) {
            rhValue = (IHid)rhValues.iterator().next();
            rhPair = this.findObjectType(rhValue);
        }
        this.checkComparison(path, hidOperator, lhValue, lhPair, rhValue, rhPair);
    }

    private DVTPair<ListContainer<IHidObject>, ListContainer<IHidObject>> isConcatenationComparison(HidOperator hidOperator) {
        IHidObject lhValue = hidOperator.getLHValue();
        if (!(lhValue instanceof RfHidOperator)) {
            return null;
        }
        RfHidOperator lhValueOperator = (RfHidOperator)lhValue;
        if (!lhValueOperator.isVLOGConcatenation(false)) {
            return null;
        }
        IHidObject rhValue = hidOperator.getFirstRHValue();
        if (!(rhValue instanceof RfHidOperator)) {
            return null;
        }
        RfHidOperator rhValueOperator = (RfHidOperator)rhValue;
        if (!rhValueOperator.isVLOGConcatenation(false)) {
            return null;
        }
        ListContainer lhValueHids = lhValueOperator.getRHValues();
        ListContainer rhValueHids = rhValueOperator.getRHValues();
        if (lhValueHids == null || rhValueHids == null) {
            return null;
        }
        if (lhValueOperator.getRHValues().size() != rhValueOperator.getRHValues().size()) {
            return null;
        }
        return new DVTPair((Object)lhValueHids, (Object)rhValueHids);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(null, (IHidVisitor<?>)this.comparisonVisitor);
        rfProject.accept(this.caseVisitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected abstract void checkComparison(ParserPath var1, HidOperator var2, IHid var3, DVTPair<Type, Object> var4, IHid var5, DVTPair<Type, Object> var6);

    protected static enum Type {
        ENUM_ELEMENT,
        LITERAL,
        FIELD_WITH_ENUM_DATATYPE,
        UNDETERMINED,
        LITERAL_NULL,
        PRIMITIVE,
        LIST,
        OBJECT,
        PRIMITIVE_LIST;

    }
}

