/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

public abstract class AbstractMacroUseCheck
extends OVMComplianceCheck {
    public AbstractMacroUseCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected void checkMacrosInClassesAndFunction(Collection<RfClass> classes, String functionName, HashSet<String> macros, String macroNameInHitMessage) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        for (RfClass classs : classes) {
            if (this.checkPreWaivers(classs.getFile())) continue;
            RfFunction functionCandidate = classs.getFunctionWithPrefix(functionName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (functionCandidate == null) {
                functionCandidate = classs.getConstructorWithPrefix(functionName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (functionCandidate == null) {
                functionCandidate = classs.getTaskWithPrefix(functionName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (functionCandidate == null || functionCandidate instanceof RfPredefinedFunction) continue;
            this.notifyCheckAlive();
            MacroCallInfo macroInfo = functionCandidate.getMacroCallInfo();
            boolean found = false;
            if (macroInfo != null) {
                block1: for (String macro : macros) {
                    List<MacroCallItem> items = macroInfo.getItems(macro);
                    if (items == null) continue;
                    for (MacroCallItem item : items) {
                        if (!macros.contains(item.getName())) continue;
                        found = true;
                        continue block1;
                    }
                }
            }
            if (found) continue;
            this.addHit(functionCandidate, String.valueOf(macroNameInHitMessage) + " macros not found in class '" + classs.getFullName() + "'!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

