/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;

public abstract class AbstractMaxHitsPerFileCheck
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="-1", description="The maximum number of failures to report per file.", name="maxHitsPerFile", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected int pMaxHitsPerFileValue;
    private boolean pHasAutofix = this.isAutocorrectable();

    public AbstractMaxHitsPerFileCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected boolean reachedMaxHitCountInFile(int hitCounterPerFile) {
        if (this.fOVMProject.isInBatchMode() && !DVTStartupConstants.isLSRunning.get()) {
            this.pHasAutofix &= this.isAutoCorrectEnabled();
        }
        return !this.pHasAutofix && this.pMaxHitsPerFileValue != -1 && hitCounterPerFile >= this.pMaxHitsPerFileValue;
    }

    protected boolean isHidden(int hitCounterPerFile) {
        return this.pMaxHitsPerFileValue != -1 && hitCounterPerFile >= this.pMaxHitsPerFileValue;
    }
}

