/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractMemberExternImplementationCheck
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="1", description="Specifies the maximum number of lines that are allowed in a method defined inside the body of a class.", name="methodMaxNofLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected Integer pMethodMaxNofLinesValue;
    @CheckParameter(defaultValue="0", description="Specifies the maximum number of lines that are allowed in a constraint defined inside the body of a class.", name="constraintMaxNofLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected Integer pConstraintMaxNofLinesValue;
    @CheckParameter(defaultValue="", description="Comma separated list to filter inheritance subtrees out of the <baseClass> inheritance tree.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipBaseClassesValue;
    @CheckParameter(defaultValue="false", description="When true, empty lines will not get counted as implementation lines.", name="skipCountingEmptyLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipCountingEmptyLinesValue;
    @CheckParameter(defaultValue="false", description="When true, comment lines will not get counted as implementation lines.", name="skipCountingCommentLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipCountingCommentLinesValue;
    private Set<RfClass> baseClasses = new HashSet<RfClass>();

    public AbstractMemberExternImplementationCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected abstract Set<Class<? extends RfNamedElement>> getClassTypes();

    protected abstract int getMaxNofLinesFor(RfDefElement var1);

    @Override
    public void performCheckImpl() {
        for (String baseClassString : this.pSkipBaseClassesValue) {
            RfClass baseClass = this.fOVMProject.getRfProject().getClass(baseClassString, true);
            if (baseClass == null) {
                this.addHit(null, "Base class '" + baseClassString + "' not found!");
                return;
            }
            this.baseClasses.add(baseClass);
        }
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            RfClass tmpClazz = (RfClass)clazz;
            if (tmpClazz == null || this.shouldSkipClass(tmpClazz)) continue;
            for (Class<? extends RfNamedElement> classType : this.getClassTypes()) {
                List<? extends RfNamedElement> allLocalMethods = tmpClazz.getLocalMembers(classType);
                if (allLocalMethods == null || allLocalMethods.isEmpty()) continue;
                this.notifyCheckAlive();
                this.checkMembers(allLocalMethods);
            }
        }
    }

    private void checkMembers(Collection<? extends RfNamedElement> namedElements) {
        for (RfNamedElement rfNamedElement : namedElements) {
            RfDefElement rfDefElement;
            ArrayList defs;
            if (rfNamedElement.isPredefined() || (defs = new ArrayList(rfNamedElement.getDeclarations())).isEmpty() || defs.size() > 2 || this.isPrototype(rfDefElement = (RfDefElement)defs.get(0))) continue;
            String memberKind = LintUtils.getElementKind(rfNamedElement);
            memberKind = String.valueOf(Character.toUpperCase(memberKind.charAt(0))) + memberKind.substring(1);
            int maxNofLines = this.getMaxNofLinesFor(rfDefElement);
            if (rfDefElement.getEndLine() < rfDefElement.getStartLine() + maxNofLines + this.getSkippedLinesFor(rfDefElement)) continue;
            this.addHit(rfDefElement.getParserPath(), rfDefElement.getStartLine(), String.valueOf(memberKind) + " '" + LintUtils.getNamedElementFullName(rfNamedElement) + "' " + (maxNofLines > 0 ? "has more than " + maxNofLines + " " + (maxNofLines == 1 ? "line" : "lines") + " and " : "") + "is not implemented external to the class!", rfDefElement.getReparseInfo(), new VerissimoAutofixAdditionalInfo(rfNamedElement));
        }
    }

    private int getSkippedLinesFor(RfDefElement rfDefElement) {
        int nOfSkippedLines = 0;
        if (this.pSkipCountingCommentLinesValue || this.pSkipCountingEmptyLinesValue) {
            int line = rfDefElement.getStartLine();
            while (line <= rfDefElement.getEndLine()) {
                List<LiteralToken> tokensOnLine = this.getWSParser().getTokensOnLine(rfDefElement.getDefFile().getParserPath(), line);
                if (tokensOnLine.isEmpty()) {
                    if (this.pSkipCountingEmptyLinesValue) {
                        ++nOfSkippedLines;
                    }
                } else if (this.pSkipCountingCommentLinesValue) {
                    boolean isCommentLine = true;
                    for (LiteralToken token : tokensOnLine) {
                        if (token.getZone() == SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || token.getZone() == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT) continue;
                        isCommentLine = false;
                        break;
                    }
                    if (isCommentLine) {
                        ++nOfSkippedLines;
                    }
                }
                ++line;
            }
        }
        return nOfSkippedLines;
    }

    protected boolean shouldSkipClass(RfClass tmpClazz) {
        return LintUtils.isSubClassOfAny(tmpClazz, this.baseClasses);
    }

    private boolean isPrototype(RfDefElement defElement) {
        if (defElement instanceof RfFunctionDef) {
            return ((RfFunctionDef)defElement).isPrototype();
        }
        if (defElement instanceof RfConstraintDef) {
            return ((RfConstraintDef)defElement).isPrototype();
        }
        return false;
    }
}

