/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.SVTBIssues;

public abstract class AbstractMethodCallCheck
extends OVMComplianceCheck {
    protected boolean skipScopeChecking = true;

    public AbstractMethodCallCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(128);
    }

    protected void performCheckBase() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        LocalRfHidVisitor hidVisitor = new LocalRfHidVisitor(this);
        rfProject.visitHidObject(rfProject, hidVisitor);
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(128, true);
        Set<ParserPath> keySet = allIssues.keySet();
        for (ParserPath filename : keySet) {
            List<SVTBIssues> issues = allIssues.get(filename);
            if (issues == null) continue;
            RfFileDef fileDef = null;
            if (!this.skipScopeChecking) {
                fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(filename);
            }
            for (SVTBIssues issue : issues) {
                String systemId = issue.getInfo();
                if (systemId == null) continue;
                IRfScopeElement scopeElement = null;
                if (fileDef != null) {
                    scopeElement = fileDef.getScope(issue.getOffset());
                }
                this.notifyCheckAlive();
                this.checkSystemCall(issue, filename, systemId, scopeElement);
            }
        }
    }

    public abstract void checkMethodCall(ParserPath var1, RfHid var2, RfFunction var3, RfNamedElement var4);

    public abstract void checkSystemCall(SVTBIssues var1, ParserPath var2, String var3, IRfScopeElement var4);

    private final class LocalRfHidVisitor
    extends RfHidVisitor {
        RfNamedElement scope;
        private OVMComplianceCheck check;

        public LocalRfHidVisitor(OVMComplianceCheck check) {
            this.check = check;
        }

        public boolean visit(RfHid hid) {
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            if (AbstractMethodCallCheck.this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this.check)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (hidNamedElement instanceof RfFunction) {
                AbstractMethodCallCheck.this.notifyCheckAlive();
                AbstractMethodCallCheck.this.checkMethodCall(this.parserPath, hid, (RfFunction)hidNamedElement, this.scope);
            }
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

