/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractMultilineMethodDeclarationCheck
extends OVMComplianceCheck {
    protected static final String END_OF_ARGUMENTS = ");";
    protected CharacterNumbersPerLineCache numberOfCharactersCache = new CharacterNumbersPerLineCache(this);

    protected AbstractMultilineMethodDeclarationCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.numberOfCharactersCache.clear();
        try {
            this.fOVMProject.getRfProject().accept(new FunctionDefVisitor(this));
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void clean() {
        super.clean();
        if (this.numberOfCharactersCache != null) {
            this.numberOfCharactersCache.clear();
        }
    }

    protected abstract void analyzeArguments(ParserPath var1, Map<Integer, ArrayList<RfFieldDef>> var2, RfDefElement var3);

    protected abstract boolean checkDeclaration(ParserPath var1, int var2, ArrayList<RfFieldDef> var3);

    class CharacterNumbersPerLineCache {
        private Map<ParserPath, List<String>> readFiles = new HashMap<ParserPath, List<String>>();
        private AbstractMultilineMethodDeclarationCheck clazz;

        public CharacterNumbersPerLineCache(AbstractMultilineMethodDeclarationCheck clazz) {
            this.clazz = clazz;
        }

        Integer getNumberOfCharactersInLine(ParserPath parserPath, Integer line) {
            String lineAsString = this.getLine(parserPath, line);
            if (lineAsString == null) {
                return 0;
            }
            return lineAsString.length();
        }

        private void readFile(ParserPath parserPath) {
            block13: {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new FileReader(parserPath.path));
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            this.readFiles.putIfAbsent(parserPath, new ArrayList());
                            this.readFiles.get(parserPath).add(line.trim());
                        }
                    }
                    catch (IOException e) {
                        AbstractMultilineMethodDeclarationCheck.this.fOVMProject.notifyCheckException(this.clazz, e);
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        if (reader == null) break block13;
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            AbstractMultilineMethodDeclarationCheck.this.fOVMProject.notifyCheckException(this.clazz, e2);
                            DVTLogger.INSTANCE.logError((Throwable)e2);
                        }
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            AbstractMultilineMethodDeclarationCheck.this.fOVMProject.notifyCheckException(this.clazz, e);
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                }
            }
        }

        private void clear() {
            this.readFiles.clear();
        }

        public String getLine(ParserPath parserPath, int line) {
            List<String> numberOfCharactersPerLine;
            if (!this.readFiles.containsKey(parserPath)) {
                this.readFile(parserPath);
            }
            if ((numberOfCharactersPerLine = this.readFiles.get(parserPath)) == null || numberOfCharactersPerLine.size() < line) {
                return null;
            }
            return numberOfCharactersPerLine.get(line - 1);
        }
    }

    private final class FunctionDefVisitor
    implements IRfDefElementVisitor {
        private OVMComplianceCheck check;

        public FunctionDefVisitor(OVMComplianceCheck check) {
            this.check = check;
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            if (!(defElement instanceof RfFunctionDef)) {
                return;
            }
            AbstractMultilineMethodDeclarationCheck.this.notifyCheckAlive();
            RfFunctionDef functionDef = (RfFunctionDef)defElement;
            ParserPath path = functionDef.getParserPath();
            if (AbstractMultilineMethodDeclarationCheck.this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this.check)) {
                return;
            }
            if (!functionDef.isANSIStyle() || functionDef.hasVirtualOffsets()) {
                return;
            }
            RfNamedElement element = functionDef.getNamedElement();
            if (!(element instanceof RfFunction) || ((RfFunction)element).isLet() || ((RfFunction)element).isDPI() || ((RfFunction)element).isPredefined()) {
                return;
            }
            ArrayList<RfFieldDef> arguments = this.getArguments(functionDef);
            if (arguments == null || arguments.isEmpty()) {
                return;
            }
            int declarationLine = defElement.getStartLine();
            if (!AbstractMultilineMethodDeclarationCheck.this.checkDeclaration(path, declarationLine, arguments)) {
                return;
            }
            HashMap<Integer, ArrayList<RfFieldDef>> argumentsPerLine = new HashMap<Integer, ArrayList<RfFieldDef>>();
            for (RfFieldDef arg : arguments) {
                int line = arg.getStartLine();
                argumentsPerLine.putIfAbsent(line, new ArrayList());
                ((ArrayList)argumentsPerLine.get(line)).add(arg);
            }
            AbstractMultilineMethodDeclarationCheck.this.analyzeArguments(path, argumentsPerLine, defElement);
        }

        private ArrayList<RfFieldDef> getArguments(RfFunctionDef functionDef) {
            ArrayList<RfFieldDef> result = new ArrayList<RfFieldDef>();
            Collection<RfDefElement> children = functionDef.getChildren();
            if (children == null || children.isEmpty()) {
                return result;
            }
            for (RfDefElement child : children) {
                RfField field;
                RfFieldDef fieldDef;
                RfNamedElement namedElement;
                if (!(child instanceof RfFieldDef) || !((namedElement = (fieldDef = (RfFieldDef)child).getNamedElement()) instanceof RfField) || !(field = (RfField)namedElement).isArgument()) continue;
                result.add(fieldDef);
            }
            return result;
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }
}

