/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractNamePatternParametersCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*_agent", description="Agent class name pattern.", name="agentClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pAgentNamePattern;
    @CheckParameter(defaultValue=".*_driver|.*_drv", description="Driver class name pattern.", name="driverClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pDriverNamePattern;
    @CheckParameter(defaultValue=".*_monitor|.*_mon", description="Monitor class name pattern.", name="monitorClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pMonitorNamePattern;
    @CheckParameter(defaultValue=".*_env", description="Environment class name pattern.", name="envClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pEnvNamePattern;
    @CheckParameter(defaultValue=".*_scb", description="Scoreboard class name pattern.", name="scoreboardClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pScoreboardNamePattern;
    @CheckParameter(defaultValue=".*_cov", description="Coverage collector class name pattern.", name="coverageCollectorClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pCoverageCollectorNamePattern;
    @CheckParameter(defaultValue=".*_item|.*_trans", description="Sequence item class name pattern.", name="sequenceItemClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pSequenceItemNamePattern;
    @CheckParameter(defaultValue=".*_sequencer", description="Sequencer class name pattern.", name="sequencerClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pSequencerNamePattern;
    @CheckParameter(defaultValue=".*_seq|.*_vseq", description="Sequence class name pattern.", name="sequenceNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pSequenceNamePattern;
    @CheckParameter(defaultValue=".*_tb|tb_.*|.*_sve", description="Testbench class name pattern.", name="testbenchClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pTestbenchNamePattern;
    @CheckParameter(defaultValue=".*_test", description="Test class name pattern.", name="testClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pTestNamePattern;
    @CheckParameter(defaultValue=".*_cfg|.*_config", description="Configuration object class name pattern.", name="configurationObjectClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pConfigurationObjectNamePattern;
    @CheckParameter(defaultValue=".*master.*", description="Active component class name pattern.", name="activeComponentClassNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pActiveComponentNamePattern;
    @CheckParameter(defaultValue=".*slave.*", description="Reactive component class name pattern.", name="reactiveComponentNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX, isVisible=false)
    protected Pattern pReactiveComponentNamePattern;
    private Map<String, Map<String, RfClass>> fSelectionParamMap;
    private Map<String, Pattern> fSelectionParamPattern;
    private static final String AGENT_DEFAULT_NAME_PATTERN = ".*_agent";
    private static final String DRIVER_DEFAULT_NAME_PATTERN = ".*_driver|.*_drv";
    private static final String MONITOR_DEFAULT_NAME_PATTERN = ".*_monitor|.*_mon";
    private static final String ENV_DEFAULT_NAME_PATTERN = ".*_env";
    private static final String SCOREBOARD_DEFAULT_NAME_PATTERN = ".*_scb";
    private static final String COV_COLLECTOR_DEFAULT_NAME_PATTERN = ".*_cov";
    private static final String SEQ_ITEM_DEFAULT_NAME_PATTERN = ".*_item|.*_trans";
    private static final String SEQUENCER_DEFAULT_NAME_PATTERN = ".*_sequencer";
    private static final String SEQUENCE_DEFAULT_NAME_PATTERN = ".*_seq|.*_vseq";
    private static final String TESTBENCH_DEFAULT_NAME_PATTERN = ".*_tb|tb_.*|.*_sve";
    private static final String TEST_DEFAULT_NAME_PATTERN = ".*_test";
    private static final String CONFIG_DEFAULT_NAME_PATTERN = ".*_cfg|.*_config";
    private static final String ACTIVE_COMP_DEFAULT_NAME_PATTERN = ".*master.*";
    private static final String REACTIVE_COMP_DEFAULT_NAME_PATTERN = ".*slave.*";
    public static final String AGENT_CLASS_NAME_PATTERN = "agentClassNamePattern";
    public static final String DRIVER_CLASS_NAME_PATTERN = "driverClassNamePattern";
    public static final String MONITOR_CLASS_NAME_PATTERN = "monitorClassNamePattern";
    public static final String ENV_CLASS_NAME_PATTERN = "envClassNamePattern";
    public static final String SCOREBOARD_CLASS_NAME_PATTERN = "scoreboardClassNamePattern";
    public static final String COVERAGE_COLLECTOR_CLASS_NAME_PATTERN = "coverageCollectorClassNamePattern";
    public static final String SEQUENCE_ITEM_CLASS_NAME_PATTERN = "sequenceItemClassNamePattern";
    public static final String SEQUENCER_CLASS_NAME_PATTERN = "sequencerClassNamePattern";
    public static final String SEQUENCE_NAME_PATTERN = "sequenceNamePattern";
    public static final String TESTBENCH_CLASS_NAME_PATTERN = "testbenchClassNamePattern";
    public static final String TEST_CLASS_NAME_PATTERN = "testClassNamePattern";
    public static final String CONFIGURATION_OBJECT_CLASS_NAME_PATTERN = "configurationObjectClassNamePattern";
    public static final String ACTIVE_COMPONENT_CLASS_NAME_PATTERN = "activeComponentClassNamePattern";
    public static final String REACTIVE_COMPONENT_NAME_PATTERN = "reactiveComponentNamePattern";

    protected AbstractNamePatternParametersCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void configureBeforeRuleImplementation() {
        this.setBaseValues();
        ArrayList<String> setParametersName = new ArrayList<String>();
        List<CheckParameterOverride> parameters = this.getOverridenParameters();
        for (CheckParameterOverride param : parameters) {
            if (!this.fSelectionParamMap.containsKey(param.name())) continue;
            setParametersName.add(param.name());
            this.fSelectionParamMap.put(param.name(), new HashMap());
        }
        if (setParametersName.isEmpty()) {
            return;
        }
        for (RfNamedElement rfClass : this.fOVMProject.getAllNonXVMClasses()) {
            if (!(rfClass instanceof RfClass)) continue;
            for (String paramName : setParametersName) {
                if (!this.fSelectionParamPattern.get(paramName).matcher(rfClass.getName()).matches() || this.fOVMProject.isOVMElement(rfClass)) continue;
                this.fSelectionParamMap.get(paramName).put(rfClass.getFullName(), (RfClass)rfClass);
            }
        }
    }

    private void setBaseValues() {
        this.fSelectionParamMap = new HashMap<String, Map<String, RfClass>>();
        this.fSelectionParamMap.put(AGENT_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(DRIVER_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(MONITOR_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(ENV_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(SCOREBOARD_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(COVERAGE_COLLECTOR_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(SEQUENCE_ITEM_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(SEQUENCER_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(SEQUENCE_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(TESTBENCH_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(TEST_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(CONFIGURATION_OBJECT_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(ACTIVE_COMPONENT_CLASS_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamMap.put(REACTIVE_COMPONENT_NAME_PATTERN, new LinkedHashMap());
        this.fSelectionParamPattern = new HashMap<String, Pattern>();
        this.fSelectionParamPattern.put(AGENT_CLASS_NAME_PATTERN, this.pAgentNamePattern);
        this.fSelectionParamPattern.put(DRIVER_CLASS_NAME_PATTERN, this.pDriverNamePattern);
        this.fSelectionParamPattern.put(MONITOR_CLASS_NAME_PATTERN, this.pMonitorNamePattern);
        this.fSelectionParamPattern.put(ENV_CLASS_NAME_PATTERN, this.pEnvNamePattern);
        this.fSelectionParamPattern.put(SCOREBOARD_CLASS_NAME_PATTERN, this.pScoreboardNamePattern);
        this.fSelectionParamPattern.put(COVERAGE_COLLECTOR_CLASS_NAME_PATTERN, this.pCoverageCollectorNamePattern);
        this.fSelectionParamPattern.put(SEQUENCE_ITEM_CLASS_NAME_PATTERN, this.pSequenceItemNamePattern);
        this.fSelectionParamPattern.put(SEQUENCER_CLASS_NAME_PATTERN, this.pSequencerNamePattern);
        this.fSelectionParamPattern.put(SEQUENCE_NAME_PATTERN, this.pSequenceNamePattern);
        this.fSelectionParamPattern.put(TESTBENCH_CLASS_NAME_PATTERN, this.pTestbenchNamePattern);
        this.fSelectionParamPattern.put(TEST_CLASS_NAME_PATTERN, this.pTestNamePattern);
        this.fSelectionParamPattern.put(CONFIGURATION_OBJECT_CLASS_NAME_PATTERN, this.pConfigurationObjectNamePattern);
        this.fSelectionParamPattern.put(ACTIVE_COMPONENT_CLASS_NAME_PATTERN, this.pActiveComponentNamePattern);
        this.fSelectionParamPattern.put(REACTIVE_COMPONENT_NAME_PATTERN, this.pReactiveComponentNamePattern);
    }

    protected Map<String, RfClass> getClassesWithPatterns(String testClassNamePattern) {
        return this.fSelectionParamMap.get(testClassNamePattern);
    }
}

