/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractOneEntityPerFileCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, the error will be reported on the declaration of the first element.", name="flagFirstElement", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pFlagFirstElement;
    @CheckParameter(defaultValue="false", description="When true, the children of a class are allowed in the same file with the class.", name="allowChildren", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowChildren;
    @CheckParameter(defaultValue="false", description="When true, allow module declarations in the same file with any design hierarchy parent module.", name="allowInstantiatedModules", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowInstantiatedModules;

    protected AbstractOneEntityPerFileCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected void checkOnePerFile(HashMap<ParserPath, ArrayList<RfNamedElement>> entities) {
        Iterator<ParserPath> iterBlockIdentifiers = entities.keySet().iterator();
        HashMap hitsList = new HashMap();
        block0: while (iterBlockIdentifiers.hasNext()) {
            this.notifyCheckAlive();
            ParserPath iterFile = iterBlockIdentifiers.next();
            List rfNamedElementArray = entities.get(iterFile);
            if (rfNamedElementArray == null || rfNamedElementArray.size() <= 1) continue;
            ArrayList<RfNamedElement> outerBlocks = new ArrayList<RfNamedElement>();
            for (RfNamedElement element : rfNamedElementArray) {
                RfNamedElement enclosingScope = element.getEnclosingScope();
                if (enclosingScope == null) {
                    outerBlocks.add(element);
                    continue;
                }
                RfFileDef eSFile = enclosingScope.getFile();
                if (eSFile == null) {
                    outerBlocks.add(element);
                    continue;
                }
                ParserPath eSParserPath = eSFile.getParserPath();
                if (iterFile.equals((Object)eSParserPath)) continue;
                outerBlocks.add(element);
            }
            if (outerBlocks.size() <= 1) continue;
            if (!this.pAllowChildren && !this.pAllowInstantiatedModules) {
                hitsList.put(iterFile, outerBlocks);
                continue;
            }
            if (this.pAllowChildren && outerBlocks.get(0) instanceof RfClass) {
                RfClass firstClass;
                RfClass topClass = firstClass = (RfClass)outerBlocks.get(0);
                while (firstClass.getParent() != null) {
                    if ((firstClass = firstClass.getParent()).getFile().getParserPath() != iterFile) continue;
                    topClass = firstClass;
                }
                for (RfNamedElement block : outerBlocks) {
                    if (!(block instanceof RfClass)) {
                        hitsList.put(iterFile, outerBlocks);
                        continue block0;
                    }
                    RfClass clazz = (RfClass)block;
                    if (clazz == topClass || LintUtils.isSubClassOf(clazz, topClass)) continue;
                    hitsList.put(iterFile, outerBlocks);
                    continue block0;
                }
                continue;
            }
            if (this.pAllowInstantiatedModules && outerBlocks.get(0) instanceof RfModule) {
                RfModule firstModule;
                RfModule topModule = firstModule = (RfModule)outerBlocks.get(0);
                while (!firstModule.getParentScopes().isEmpty()) {
                    for (IRfScopeElement parent : firstModule.getParentScopes()) {
                        if (!(parent instanceof RfModule)) continue;
                        firstModule = (RfModule)parent;
                        break;
                    }
                    if (firstModule.getFile().getParserPath() != iterFile) continue;
                    topModule = firstModule;
                }
                for (RfNamedElement block : outerBlocks) {
                    if (!(block instanceof RfModule)) {
                        hitsList.put(iterFile, outerBlocks);
                        continue block0;
                    }
                    RfModule module = (RfModule)block;
                    if (module == topModule || this.isInModuleHierarchy(module, topModule)) continue;
                    hitsList.put(iterFile, outerBlocks);
                    continue block0;
                }
                continue;
            }
            hitsList.put(iterFile, outerBlocks);
        }
        for (Map.Entry entry : hitsList.entrySet()) {
            ParserPath path = (ParserPath)entry.getKey();
            int line = 0;
            if (this.pFlagFirstElement) {
                RfNamedElement firstElement = (RfNamedElement)((ArrayList)entry.getValue()).get(0);
                line = firstElement.getLine();
                for (RfNamedElement element : (ArrayList)entry.getValue()) {
                    if (line <= element.getLine()) continue;
                    line = element.getLine();
                }
            }
            this.addHit(path, line, "More entities in file: " + hitsList.get(path) + "!", null);
        }
    }

    boolean isInModuleHierarchy(RfModule module, RfModule topModule) {
        block0: while (!module.equals(topModule)) {
            Set<IRfScopeElement> parents = module.getParentScopes();
            if (parents.isEmpty()) {
                return false;
            }
            for (IRfScopeElement parent : parents) {
                if (!(parent instanceof RfModule)) continue;
                module = (RfModule)parent;
                continue block0;
            }
        }
        return true;
    }
}

