/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.svtb.AbstractOperatorParenthesesParity;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractOperatorInConstraint
extends AbstractOperatorParenthesesParity {
    protected AbstractOperatorInConstraint(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final HashMap hitsMap = new HashMap();
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                if (this.scope == null || !(this.scope instanceof RfNamedElement)) {
                    return true;
                }
                if (AbstractOperatorInConstraint.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                AbstractOperatorInConstraint.this.notifyCheckAlive();
                RfHidOperator op = (RfHidOperator)hidOperator;
                RfNamedElement constraint = this.isInConstraint((RfNamedElement)this.scope);
                if (constraint == null) {
                    return true;
                }
                List rhValues = OptimizedUtils.asList((ListContainer)op.getRHValues(), (boolean)false);
                IHidObject lhValue = op.getLHValue();
                ArrayList<IHidObject> hidValues = new ArrayList<IHidObject>();
                if (rhValues != null && !rhValues.isEmpty()) {
                    hidValues.addAll(rhValues);
                }
                if (lhValue != null) {
                    hidValues.add(lhValue);
                }
                if (!hitsMap.containsKey(constraint)) {
                    hitsMap.put(constraint, new HashMap());
                }
                AbstractOperatorInConstraint.this.checkOperators(op, hidValues, (HashMap)hitsMap.get(constraint), this.parserPath);
                return true;
            }

            private RfNamedElement isInConstraint(RfNamedElement scope) {
                while (scope != null) {
                    if (scope instanceof RfConstraint || scope instanceof RfActionBlock && ((RfActionBlock)scope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.WITH)) {
                        return scope;
                    }
                    scope = scope.getEnclosingScope();
                }
                return null;
            }
        });
        for (Map.Entry element : hitsMap.entrySet()) {
            RfHidOperator key;
            HashMap hits = (HashMap)element.getValue();
            ParserPath path = ((RfNamedElement)element.getKey()).isExtern() ? ((RfNamedElement)element.getKey()).getImplementation().getParserPath() : ((RfNamedElement)element.getKey()).getDeclaration().getParserPath();
            if (hits.isEmpty()) continue;
            this.notifyCheckAlive();
            HashSet<RfHidOperator> operatorsToRemove = new HashSet<RfHidOperator>();
            for (Map.Entry pair : hits.entrySet()) {
                ListContainer rhValues;
                key = (RfHidOperator)pair.getKey();
                if (key.getOperatorType() == IHidOperatorConstants.OperatorType.IF_CONDITION.id) {
                    Set flattenOperators = HidUtils.flattenToOperators((IHidOperator)key);
                    operatorsToRemove.addAll(flattenOperators);
                    continue;
                }
                if (key.getOperatorType() == 74) {
                    operatorsToRemove.add(key);
                    continue;
                }
                IHidObject lhValue = key.getLHValue();
                if (lhValue != null && lhValue instanceof RfHidOperator && this.hasChild((RfHidOperator)lhValue, hits)) {
                    operatorsToRemove.add(key);
                }
                if ((rhValues = key.getRHValues()) == null || rhValues.isEmpty()) continue;
                for (IHidObject obj : rhValues) {
                    if (!(obj instanceof RfHidOperator) || !this.hasChild((RfHidOperator)obj, hits)) continue;
                    operatorsToRemove.add(key);
                }
            }
            Iterator it = hits.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair;
                pair = it.next();
                key = (RfHidOperator)pair.getKey();
                if (!operatorsToRemove.contains(key)) continue;
                it.remove();
            }
            for (Map.Entry entry : hits.entrySet()) {
                if (path == null) continue;
                this.addHit(path, (HidOccurrence)((RfHidOperator)entry.getKey()).getOccurrence(), (String)entry.getValue());
            }
            hits.clear();
        }
    }

    public boolean hasChild(RfHidOperator op, HashMap<RfHidOperator, String> hits) {
        if (hits.containsKey(op)) {
            return true;
        }
        IHidObject lhValue = op.getLHValue();
        ListContainer rhValues = op.getRHValues();
        if (lhValue != null && lhValue instanceof RfHidOperator && this.hasChild((RfHidOperator)lhValue, hits)) {
            return true;
        }
        if (rhValues == null || rhValues.isEmpty()) {
            return false;
        }
        for (IHidObject obj : rhValues) {
            if (!(obj instanceof RfHidOperator) || !this.hasChild((RfHidOperator)obj, hits)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected abstract void checkOperators(RfHidOperator var1, List<IHidObject> var2, HashMap<RfHidOperator, String> var3, ParserPath var4);
}

