/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractOperatorParenthesesParity
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    protected AbstractOperatorParenthesesParity(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected boolean checkParanthesisParity(RfHidOperator hidOp1, RfHidOperator hidOp2, ParserPath parserPath) {
        char ch;
        int n;
        int n2;
        char[] cArray;
        int endOffset;
        int startOffset;
        if (hidOp1.getReparseInfo() != null || hidOp2.getReparseInfo() != null) {
            return true;
        }
        if (hidOp1.getOffset() > hidOp2.getOffset()) {
            startOffset = hidOp2.getOffset();
            endOffset = hidOp1.getOffset();
        } else {
            startOffset = hidOp1.getOffset();
            endOffset = hidOp2.getOffset();
        }
        LiteralToken token = this.getWSParser().getTokenContainingOffset(startOffset, parserPath);
        if (token == null) {
            return true;
        }
        int startingCut = startOffset - token.getOffsetFile();
        String tokenString = token.getStringToken().substring(startingCut);
        int parityCount = 0;
        while (token.getOffsetFile() + token.getLength() < endOffset) {
            startingCut = 0;
            if (token.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                cArray = tokenString.toCharArray();
                n2 = cArray.length;
                n = 0;
                while (n < n2) {
                    ch = cArray[n];
                    if (ch == '(') {
                        ++parityCount;
                    } else if (ch == ')') {
                        --parityCount;
                    }
                    ++n;
                }
            }
            if ((token = this.getWSParser().getNextToken(token, parserPath)) == null) {
                return true;
            }
            tokenString = token.getStringToken();
        }
        tokenString = tokenString.substring(0, endOffset - token.getOffsetFile() - startingCut);
        if (token.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
            cArray = tokenString.toCharArray();
            n2 = cArray.length;
            n = 0;
            while (n < n2) {
                ch = cArray[n];
                if (ch == '(') {
                    ++parityCount;
                } else if (ch == ')') {
                    --parityCount;
                }
                ++n;
            }
        }
        return parityCount != 0;
    }
}

