/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;

public abstract class AbstractOverrideMethodFromParentClassCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="For all classes that inherit from <baseClass> full name.", name="baseClass", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    public String pBaseClassValue;
    @CheckParameter(defaultValue="", description="Comma separated list of methods that should be overridden.", name="methodName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public Set<String> pMethodsNameValue;
    @CheckParameter(defaultValue="", description="Comma separated list to filter inheritance subtrees out of the <baseClass> inheritance tree.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public HashSet<String> pSkipBaseClassesValue;

    public AbstractOverrideMethodFromParentClassCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass baseClass = this.fOVMProject.getRfProject().getClass(this.pBaseClassValue, true);
        if (baseClass == null) {
            this.addHit(null, "Class '" + this.pBaseClassValue + "' not found!");
            return;
        }
        this.checkOverrides(new HashSet<RfClass>(), baseClass.getChildren(), this.pMethodsNameValue, this.pSkipBaseClassesValue);
    }

    void checkOverrides(Set<RfClass> visited, RfClass aClass, Set<String> aMethodsName, HashSet<String> aSkipBaseClasses) {
        this.notifyCheckAlive();
        if (aClass == null) {
            return;
        }
        if (visited.contains(aClass)) {
            return;
        }
        visited.add(aClass);
        if (aClass.getExtendedParameter() == null) {
            if (aSkipBaseClasses != null && aSkipBaseClasses.contains(aClass.getFullName())) {
                return;
            }
            RfFileDef fileDef = aClass.getFile();
            if (fileDef != null && !this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this)) {
                for (String aMethodName : aMethodsName) {
                    RfFunction implementedMethod = aClass.getFunctionWithPrefix(aMethodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                    if (implementedMethod == null) {
                        implementedMethod = aClass.getTaskWithPrefix(aMethodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                    }
                    this.computeHitForMethod(aClass, aMethodName, implementedMethod);
                }
            }
        }
        this.checkOverrides(visited, aClass.getChildren(), aMethodsName, aSkipBaseClasses);
    }

    protected void checkOverrides(Set<RfClass> visited, Collection<RfClass> aClasses, Set<String> aMethodsName, HashSet<String> aSkipBaseClasses) {
        if (aClasses == null) {
            return;
        }
        for (RfClass eachClass : aClasses) {
            this.checkOverrides(visited, eachClass, aMethodsName, aSkipBaseClasses);
        }
    }

    public void computeHitForMethod(RfClass aClass, String aMethodName, RfFunction implementedMethod) {
        if (implementedMethod == null) {
            this.addHit(aClass, "Class '" + aClass.getName() + "' does not override '" + aMethodName + "()' !");
        }
    }
}

