/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

public abstract class AbstractPackageImportCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="uvm_pkg", description="Comma separated list of exceptions.", name="allowPackages", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowPackagesValue;

    protected AbstractPackageImportCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject;
        if (this.pAllowPackagesValue.isEmpty()) {
            this.pAllowPackagesValue.add(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg"));
        }
        if ((rfProject = this.fOVMProject.getRfProject()) == null) {
            return;
        }
        IRfNamedElementVisitor neVisitor = namedElement -> {
            this.notifyCheckAlive();
            if (namedElement != null) {
                if (this.checkPrewaivers(namedElement.getDeclaration())) {
                    return true;
                }
                NullProtectedList<ImportInfo> allImportDeclarations = namedElement.getAllImportDeclarations();
                if (allImportDeclarations != null) {
                    for (ImportInfo importInfo : allImportDeclarations) {
                        if (importInfo == null || importInfo.getParserPath() == null || this.skipImportType(importInfo) || this.pAllowPackagesValue.contains(importInfo.getPackageName())) continue;
                        this.addHit(importInfo.getParserPath(), importInfo.getLine(), this.getErrorMessage(importInfo), null);
                    }
                }
            }
            return true;
        };
        rfProject.accept(neVisitor);
    }

    private boolean checkPrewaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }

    protected abstract boolean skipImportType(ImportInfo var1);

    protected abstract String getErrorMessage(ImportInfo var1);
}

