/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;

public abstract class AbstractPatternCheck
extends OVMComplianceCheck {
    protected static final Pattern idPattern = Pattern.compile("\\((\\w+)\\)");

    public AbstractPatternCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected static class LocalMatcher {
        private String originalUserPatternString;
        private ArrayList<String> originalIdNames;
        private String userPatternString;
        private Pattern regexpPattern;
        ArrayList<String> idNames;
        ArrayList<String> idValues;

        LocalMatcher(String aUserPatternString) {
            this.userPatternString = this.originalUserPatternString = aUserPatternString;
            this.computePattern();
            this.originalIdNames = this.idNames;
        }

        void computePattern() {
            if (this.userPatternString == null) {
                return;
            }
            this.idNames = new ArrayList();
            this.idValues = new ArrayList();
            Matcher idMatcher = idPattern.matcher(this.userPatternString);
            while (idMatcher.find()) {
                this.idNames.add(idMatcher.group(1));
            }
            this.regexpPattern = Pattern.compile(idPattern.matcher(this.userPatternString).replaceAll("(\\\\w+)"));
        }

        void recomputePattern(HashMap<String, String> aIdNameValueMap) {
            if (this.userPatternString == null) {
                return;
            }
            this.userPatternString = this.originalUserPatternString;
            this.idNames = this.originalIdNames;
            for (String idName : this.idNames) {
                if (!aIdNameValueMap.containsKey(idName)) continue;
                String idValue = aIdNameValueMap.get(idName);
                if (idValue == null) {
                    idValue = "";
                }
                this.userPatternString = this.userPatternString.replaceAll("\\(" + idName + "\\)", idValue);
            }
            this.computePattern();
        }

        boolean match(String aString) {
            if (this.userPatternString == null) {
                return true;
            }
            this.idValues.clear();
            Matcher m = this.regexpPattern.matcher(aString);
            if (m.matches() && m.groupCount() == this.idNames.size()) {
                int i = 0;
                while (i < this.idNames.size()) {
                    this.idValues.add(m.group(i + 1));
                    ++i;
                }
                return true;
            }
            return false;
        }

        String getUserPatternString() {
            return this.userPatternString;
        }

        ArrayList<String> getIdNames() {
            return this.idNames;
        }

        ArrayList<String> getIdValues() {
            return this.idValues;
        }

        public ArrayList<String> getOriginalIdNames() {
            return this.originalIdNames;
        }

        String checkIdValues(HashMap<String, String> aIdNameValueMap, HashMap<String, String> aIdLocationMap, String aCurrentLocation) {
            if (this.userPatternString == null) {
                return null;
            }
            int i = 0;
            while (i < this.idNames.size()) {
                String idName = this.idNames.get(i);
                String idValue = this.idValues.get(i);
                String existingIdValue = aIdNameValueMap.get(idName);
                if (existingIdValue != null) {
                    if (!existingIdValue.equals(idValue)) {
                        String existingLocation = aIdLocationMap.get(idName);
                        return String.valueOf(aCurrentLocation) + " id mismatch: Unexpected value for id '" + idName + "': expecting '" + existingIdValue + "' as in " + existingLocation + " name, found '" + idValue + "' in " + aCurrentLocation + " name!";
                    }
                    return null;
                }
                aIdNameValueMap.put(idName, idValue);
                aIdLocationMap.put(idName, aCurrentLocation);
                ++i;
            }
            return null;
        }
    }
}

