/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfWait;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractProtectiveForkForMethodCallsCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, allow variable declarations at the beginning of the protective fork.", name="allowDeclarationsInsideProtectiveFork", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowDeclarationsInsideProtectiveFork;

    protected AbstractProtectiveForkForMethodCallsCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<RfHidOperator>(){
            RfNamedElement scope;
            ParserPath parserPath;

            public boolean visit(RfHidOperator hidOperator) {
                RfNamedElement scope;
                if (AbstractProtectiveForkForMethodCallsCheck.this.isPrewaived(this.parserPath)) {
                    return true;
                }
                AbstractProtectiveForkForMethodCallsCheck.this.notifyCheckAlive();
                if (!AbstractProtectiveForkForMethodCallsCheck.this.checkOperatorType(hidOperator)) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                if (!(lhValue instanceof RfHidImplicit)) {
                    return true;
                }
                if (!((RfHidImplicit)lhValue).getName().equals("fork")) {
                    return true;
                }
                HidOperatorOccurrence occurence = hidOperator.getOccurrence();
                if (occurence == null) {
                    return true;
                }
                RfNamedElement rfNamedElement = scope = this.scope instanceof RfWait ? this.scope.getEnclosingScope() : this.scope;
                if (!(scope instanceof RfActionBlock)) {
                    AbstractProtectiveForkForMethodCallsCheck.this.addHit(this.parserPath, (HidOccurrence)occurence, AbstractProtectiveForkForMethodCallsCheck.this.generateHitMessage());
                    return true;
                }
                RfActionBlock actionBlock = (RfActionBlock)scope;
                while (!(actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN) || actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY) || actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE))) {
                    RfNamedElement enclosingScope = actionBlock.getEnclosingScope();
                    if (!(enclosingScope instanceof RfActionBlock)) {
                        AbstractProtectiveForkForMethodCallsCheck.this.addHit(this.parserPath, (HidOccurrence)occurence, AbstractProtectiveForkForMethodCallsCheck.this.generateHitMessage());
                        return true;
                    }
                    actionBlock = (RfActionBlock)enclosingScope;
                }
                if (actionBlock != null && actionBlock.getDeclaration() != null) {
                    Collection<RfDefElement> children = actionBlock.getDeclaration().getChildren();
                    if (children == null) {
                        AbstractProtectiveForkForMethodCallsCheck.this.addHit(this.parserPath, (HidOccurrence)occurence, AbstractProtectiveForkForMethodCallsCheck.this.generateHitMessage());
                        return true;
                    }
                    int childrenCnt = children.size();
                    RfDefElement defElement = children.iterator().next();
                    if (AbstractProtectiveForkForMethodCallsCheck.this.pAllowDeclarationsInsideProtectiveFork && childrenCnt > 1) {
                        for (RfDefElement child : children) {
                            if (child instanceof RfFieldDef) {
                                --childrenCnt;
                                continue;
                            }
                            defElement = child;
                        }
                    }
                    if (childrenCnt == 1) {
                        if (defElement instanceof RfActionBlockDef) {
                            RfNamedElement namedElement = defElement.getNamedElement();
                            if (namedElement instanceof RfActionBlock) {
                                if (!((RfActionBlock)namedElement).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.BEGIN_END)) {
                                    AbstractProtectiveForkForMethodCallsCheck.this.addHit(this.parserPath, (HidOccurrence)occurence, AbstractProtectiveForkForMethodCallsCheck.this.generateHitMessage());
                                }
                            } else {
                                AbstractProtectiveForkForMethodCallsCheck.this.addHit(this.parserPath, (HidOccurrence)occurence, AbstractProtectiveForkForMethodCallsCheck.this.generateHitMessage());
                            }
                        } else {
                            AbstractProtectiveForkForMethodCallsCheck.this.addHit(this.parserPath, (HidOccurrence)occurence, AbstractProtectiveForkForMethodCallsCheck.this.generateHitMessage());
                        }
                    } else {
                        AbstractProtectiveForkForMethodCallsCheck.this.addHit(this.parserPath, (HidOccurrence)occurence, AbstractProtectiveForkForMethodCallsCheck.this.generateHitMessage());
                    }
                }
                return true;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }

            public void setHolder(IHidHolder holder) {
                this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }
        });
    }

    protected abstract boolean checkOperatorType(RfHidOperator var1);

    protected abstract String generateHitMessage();

    private boolean isPrewaived(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

