/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.ReparseInfo;

public abstract class AbstractRandomStabilityCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, only root functions causing random instability are shown.", name="enableRootCauseMode", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pEnableRootCauseModeValue;
    @CheckParameter(defaultValue="false", description="When true, the check for random instability goes through all virtual function implementations.", name="checkVirtualFunctionOverrides", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckVirtualFunctionOverridesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of method full names for which the check for random instability will be skipped.To skip methods only when called from certain methods specify them like this: my_class.skipped_method/my_class.method_that_calls_skipped_method", name="skipMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pSkipMethods;
    protected Map<String, String> skipMethodsFromScope = new HashMap<String, String>();
    protected Set<String> skipMethodsFromAnyScope = new HashSet<String>();
    private HashMap<String, RfNamedElement> visitedFunctions;
    private LinkedHashMap<String, RfNamedElement> unstableElements;
    private LinkedHashMap<String, RfNamedElement> unstableChildrenElements;
    private HashMap<String, ArrayList<RfNamedElement>> callStacks;
    protected HashMap<String, Object> unstableCauses;

    public AbstractRandomStabilityCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pSkipMethods != null && !this.pSkipMethods.isEmpty()) {
            for (String skipMethod : this.pSkipMethods) {
                if (skipMethod.contains("/")) {
                    String[] splits = skipMethod.split("/");
                    if (splits == null || splits.length != 2) continue;
                    this.skipMethodsFromScope.put(splits[0], splits[1]);
                    continue;
                }
                this.skipMethodsFromAnyScope.add(skipMethod);
            }
        }
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.visitedFunctions = new HashMap();
        this.unstableElements = new LinkedHashMap();
        this.unstableChildrenElements = new LinkedHashMap();
        this.callStacks = new HashMap();
        this.unstableCauses = new HashMap();
        Set<RfActionBlock> startingScopes = this.getStartingScopes();
        if (startingScopes != null && !startingScopes.isEmpty()) {
            for (RfActionBlock rfActionBlock : startingScopes) {
                this.analyzeElement(rfActionBlock);
            }
        } else {
            IRfNamedElementVisitor iRfNamedElementVisitor = new IRfNamedElementVisitor(){

                @Override
                public boolean visit(RfNamedElement namedElement) {
                    RfFunction functionElement;
                    AbstractRandomStabilityCheck.this.notifyCheckAlive();
                    if (namedElement instanceof RfFunction && !(functionElement = (RfFunction)namedElement).isConstructor()) {
                        AbstractRandomStabilityCheck.this.analyzeElement(functionElement);
                    }
                    return true;
                }
            };
            rfProject.accept(iRfNamedElementVisitor);
        }
        if (this.pEnableRootCauseModeValue) {
            for (Map.Entry entry : this.unstableElements.entrySet()) {
                RfNamedElement rootElement;
                ArrayList<RfNamedElement> callStack;
                String ffn = (String)entry.getKey();
                RfNamedElement unstableElement = (RfNamedElement)entry.getValue();
                if (!this.checkIfValidHit(unstableElement, startingScopes) || (callStack = this.callStacks.get(ffn)) == null || callStack.size() != 1 || (rootElement = callStack.get(callStack.size() - 1)) == null) continue;
                String msg = "";
                for (String ffn2 : this.unstableElements.keySet()) {
                    RfNamedElement lastElement;
                    ArrayList<RfNamedElement> callStack2 = this.callStacks.get(ffn2);
                    if (callStack2 == null || callStack2.isEmpty() || callStack2.size() == 1 || (lastElement = callStack2.get(callStack2.size() - 1)) != rootElement) continue;
                    msg = String.valueOf(msg) + "\n\n  ";
                    int lastCallIndex = callStack2.size();
                    int callIndex = 0;
                    while (callIndex < lastCallIndex) {
                        RfNamedElement rfNamedElement = callStack2.get(callIndex);
                        msg = rfNamedElement instanceof RfActionBlock ? String.valueOf(msg) + "\n  " + callIndex + ": if(" + this.linkActionBlock((RfActionBlock)rfNamedElement) + ") - " + this.getUnstableCause(rfNamedElement, callIndex == lastCallIndex - 1) : String.valueOf(msg) + "\n" + callIndex + ": " + this.link(rfNamedElement) + "() " + this.getUnstableCause(rfNamedElement, callIndex == lastCallIndex - 1);
                        ++callIndex;
                    }
                }
                String elementName = "";
                elementName = rootElement instanceof RfActionBlock ? "if(" + ((RfActionBlock)rootElement).getExpression() + ")" : String.valueOf(ffn) + "()";
                ParserPath parserPath = unstableElement.getDeclaration().getParserPath();
                ReparseInfo reparseInfo = unstableElement.getDeclaration().getReparseInfo();
                String hitMessage = "'" + elementName + "' is random unstable! - " + this.getUnstableCause(rootElement, true) + "!" + ("".equals(msg) ? "" : " Call stacks: " + msg);
                this.addHit(parserPath, rootElement.getLine(), hitMessage, reparseInfo, true, new VerissimoAutofixAdditionalInfo(rootElement));
            }
        } else {
            for (Map.Entry entry : this.unstableElements.entrySet()) {
                ArrayList<RfNamedElement> callStack;
                String ffn = (String)entry.getKey();
                RfNamedElement namedElement = (RfNamedElement)entry.getValue();
                if (!this.checkIfValidHit(namedElement, startingScopes) || (callStack = this.callStacks.get(ffn)) == null || callStack.isEmpty()) continue;
                String msg = "";
                int lastCallIndex = callStack.size();
                int callIndex = 0;
                while (callIndex < lastCallIndex) {
                    RfNamedElement rfElement = callStack.get(callIndex);
                    msg = rfElement instanceof RfActionBlock ? String.valueOf(msg) + "\n  " + callIndex + ": if(" + this.linkActionBlock((RfActionBlock)rfElement) + ") - " + this.getUnstableCause(rfElement, callIndex == lastCallIndex - 1) : String.valueOf(msg) + "\n  " + callIndex + ": " + this.link(rfElement) + "() - " + this.getUnstableCause(rfElement, callIndex == lastCallIndex - 1);
                    ++callIndex;
                }
                String elementName = "";
                elementName = namedElement instanceof RfActionBlock ? "if(" + ((RfActionBlock)namedElement).getExpression() + ")" : String.valueOf(ffn) + "()";
                ParserPath parserPath = namedElement.getDeclaration().getParserPath();
                ReparseInfo reparseInfo = namedElement.getDeclaration().getReparseInfo();
                String hitMessage = "'" + elementName + "' is random unstable! Call stack: " + msg;
                this.addHit(parserPath, namedElement.getLine(), hitMessage, reparseInfo, true, new VerissimoAutofixAdditionalInfo(callStack.get(callStack.size() - 1)));
            }
        }
    }

    protected Set<RfActionBlock> getStartingScopes() {
        return null;
    }

    private void analyzeElement(RfNamedElement namedElement) {
        List<RfFunctionCall> allCalls;
        this.notifyCheckAlive();
        if (namedElement == null) {
            return;
        }
        if (this.visitedFunctions.containsKey(namedElement.getFullName())) {
            return;
        }
        this.visitedFunctions.put(namedElement.getFullName(), namedElement);
        if (namedElement instanceof RfFunction && this.skipMethodsFromAnyScope.contains(namedElement.getFullName())) {
            return;
        }
        ArrayList<RfNamedElement> callStack = new ArrayList<RfNamedElement>();
        callStack.add(namedElement);
        if (this.pCheckVirtualFunctionOverridesValue && namedElement.isVirtual()) {
            RfFunction func = (RfFunction)namedElement;
            RfClass funcClazz = (RfClass)func.getEnclosingScope();
            Set<RfClass> children = funcClazz.getChildren();
            List<RfFunction> allCalls2 = namedElement.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (namedElement.isPure()) {
                allCalls2.add((RfFunction)namedElement);
            }
            if (children != null) {
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    RfClass child = (RfClass)iterator.next();
                    RfFunction childCall = child.getFunctionWithPrefix(func.getName(), 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                    if (childCall == null) {
                        if (!namedElement.isPure()) continue;
                        return;
                    }
                    if (this.skipMethodsFromScope.containsKey(childCall.getFullName()) && this.skipMethodsFromScope.get(childCall.getFullName()).equals(namedElement.getFullName())) continue;
                    this.analyzeElement(childCall);
                    if (!this.unstableElements.containsKey(childCall.getFullName())) continue;
                    ArrayList<RfNamedElement> extendCallStack = this.callStacks.get(childCall.getFullName());
                    callStack.addAll(extendCallStack);
                    this.callStacks.put(namedElement.getFullName(), callStack);
                    this.unstableCauses.put(namedElement.getFullName(), childCall);
                    if (namedElement.isPure()) {
                        this.unstableElements.put(namedElement.getFullName(), namedElement);
                    } else {
                        this.unstableChildrenElements.put(namedElement.getFullName(), childCall);
                    }
                    return;
                }
            }
        }
        if ((allCalls = namedElement.getFunctionCallsWithPrefix("", 2)) == null || allCalls.isEmpty()) {
            return;
        }
        for (RfFunctionCall call : allCalls) {
            RfFunction calledFunction;
            if (call.getName().indexOf("get_randstate") <= -1 || (calledFunction = call.getFunction()) == null) continue;
            return;
        }
        Object unstableCause = this.isFunctionOrActionBlockUnstable(namedElement, allCalls);
        if (unstableCause != null) {
            this.unstableElements.put(namedElement.getFullName(), namedElement);
            this.callStacks.put(namedElement.getFullName(), callStack);
            this.unstableCauses.put(namedElement.getFullName(), unstableCause);
            return;
        }
        for (RfFunctionCall call : allCalls) {
            ArrayList<RfNamedElement> extendCallStack;
            RfFunction calledFunction = call.getFunction();
            if (calledFunction == null) continue;
            RfNamedElement namedElementInGenericScope = calledFunction.getElementInGenericScope();
            if (namedElementInGenericScope instanceof RfFunction) {
                calledFunction = (RfFunction)namedElementInGenericScope;
            }
            if (this.skipMethodsFromScope.containsKey(calledFunction.getFullName()) && this.skipMethodsFromScope.get(calledFunction.getFullName()).equals(namedElement.getFullName())) continue;
            this.analyzeElement(calledFunction);
            if (this.unstableElements.containsKey(calledFunction.getFullName())) {
                this.unstableElements.put(namedElement.getFullName(), namedElement);
                extendCallStack = this.callStacks.get(calledFunction.getFullName());
                callStack.addAll(extendCallStack);
                this.callStacks.put(namedElement.getFullName(), callStack);
                this.unstableCauses.put(namedElement.getFullName(), call);
                return;
            }
            if (!this.unstableChildrenElements.containsKey(calledFunction.getFullName())) continue;
            this.unstableElements.put(namedElement.getFullName(), namedElement);
            extendCallStack = this.callStacks.get(this.unstableChildrenElements.get(calledFunction.getFullName()).getFullName());
            callStack.addAll(extendCallStack);
            this.callStacks.put(namedElement.getFullName(), callStack);
            this.unstableCauses.put(namedElement.getFullName(), call);
            return;
        }
    }

    protected abstract Object isFunctionOrActionBlockUnstable(RfNamedElement var1, List<RfFunctionCall> var2);

    protected abstract String getUnstableCause(RfNamedElement var1, boolean var2);

    protected abstract boolean checkIfValidHit(RfNamedElement var1, Set<RfActionBlock> var2);

    @Override
    public void clean() {
        super.clean();
        if (this.visitedFunctions != null) {
            this.visitedFunctions.clear();
        }
        if (this.unstableElements != null) {
            this.unstableElements.clear();
        }
        if (this.unstableChildrenElements != null) {
            this.unstableChildrenElements.clear();
        }
        if (this.callStacks != null) {
            this.callStacks.clear();
        }
        if (this.unstableCauses != null) {
            this.unstableCauses.clear();
        }
    }
}

