/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractRangeArrayCheck
extends OVMComplianceCheck {
    protected AbstractRangeArrayCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (!(namedElement instanceof RfField) && !(namedElement instanceof RfTypeAlias)) {
                return true;
            }
            RfAssociatedType field = (RfAssociatedType)namedElement;
            RfDefElement fieldDeclaration = field.getDeclaration();
            if (fieldDeclaration == null || fieldDeclaration.getParserPath() == null) {
                return true;
            }
            if (field.isPredefined() || field instanceof RfModportPort) {
                return true;
            }
            if (field instanceof RfField && ((RfField)field).isEnumElement()) {
                return true;
            }
            if (this.fOVMProject.isOVMFile(field.getFile().getName())) {
                return true;
            }
            if (this.checkPrewaiver(fieldDeclaration.getParserPath())) {
                return true;
            }
            this.notifyCheckAlive();
            DataType dataType = field.getDataType();
            if (dataType == null) {
                return true;
            }
            List<IndexType> dimensions = this.getDimensions(dataType);
            if (dimensions == null) {
                return true;
            }
            for (IndexType dimension : dimensions) {
                IHidObject rangeObj = dimension.getRangeObject();
                if (rangeObj == null || !(rangeObj instanceof RfHidOperator)) continue;
                this.addHitCheck(rangeObj, namedElement);
            }
            return true;
        });
    }

    protected abstract List<IndexType> getDimensions(DataType var1);

    protected abstract void addHitCheck(IHidObject var1, RfNamedElement var2);

    private boolean checkPrewaiver(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }
}

