/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractReservedPhraseCheck
extends OVMComplianceCheck {
    protected String allowedType;
    protected String reservedPhrase;
    protected boolean isPrefix;

    protected AbstractReservedPhraseCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.setParameterValues();
        Map<ParserPath, Set<RfNamedElement>> allowedElements = this.getAllowedElements();
        if (allowedElements == null) {
            return;
        }
        this.fOVMProject.getRfProject().accept(new LocalRfNamedElementVisitor(allowedElements));
    }

    public boolean hasInvalidName(RfNamedElement element, String reserved, boolean isPrefix) {
        if (element == null || element.getName() == null) {
            return false;
        }
        return isPrefix ? element.getName().startsWith(reserved) : element.getName().endsWith(reserved);
    }

    protected abstract void setParameterValues();

    protected abstract Map<ParserPath, Set<RfNamedElement>> getAllowedElements();

    private final class LocalRfNamedElementVisitor
    implements IRfNamedElementVisitor {
        private Map<ParserPath, Set<RfNamedElement>> allowedElements;

        public LocalRfNamedElementVisitor(Map<ParserPath, Set<RfNamedElement>> allowedElements2) {
            this.allowedElements = allowedElements2;
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (namedElement.isPredefined()) {
                return true;
            }
            if (namedElement.getDeclaration() == null) {
                return true;
            }
            AbstractReservedPhraseCheck.this.notifyCheckAlive();
            if (!AbstractReservedPhraseCheck.this.hasInvalidName(namedElement, AbstractReservedPhraseCheck.this.reservedPhrase, AbstractReservedPhraseCheck.this.isPrefix)) {
                return true;
            }
            RfNamedElement rfNamedElement = namedElement;
            if (rfNamedElement instanceof RfCovercross && (var2_3 = (RfCovercross)rfNamedElement) == (RfCovercross)var3_2 && !covercross.isNamed()) {
                return true;
            }
            if (namedElement instanceof RfCovergroup var4_5 && covergroup.isAnonymous()) {
                return true;
            }
            ParserPath parserPath = namedElement.getDeclaration().getParserPath();
            Set<RfNamedElement> localElements = this.allowedElements.get(parserPath);
            if (localElements != null && !localElements.isEmpty() && localElements.contains(namedElement)) {
                return true;
            }
            AbstractReservedPhraseCheck.this.addHit(namedElement, "'" + LintUtils.getNamedElementFullName(namedElement) + "' is not " + AbstractReservedPhraseCheck.this.allowedType + ", but has " + AbstractReservedPhraseCheck.this.reservedPhrase + " " + (AbstractReservedPhraseCheck.this.isPrefix ? "prefix" : "suffix") + "!");
            return true;
        }
    }
}

