/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.utils.Utils;

public abstract class AbstractSVAPatternDetector
extends OVMComplianceCheck {
    private static final String EMPTY = "";
    private static final String ANY = "_ANY_";
    private static final String ANY_OP = "_ANY_OP_";
    private static final List<String> ALL_SEQUENCE_OPERATORS = Arrays.asList("or", "and", "intersect", "within", "throughout", "#-#", "#=#", "##_ANY_", "|->", "|=>", "->", "until", "s_until", "until_with", "s_until_with", "implies", "iff");

    protected AbstractSVAPatternDetector(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    private IHidObject parsePattern(String pattern) {
        RfProject rfProject = this.fOVMProject.getRfProject();
        IProject project = rfProject.getProject();
        List invocations = BuildConfigManager.getInvocations((IProject)project);
        if (invocations == null || invocations.isEmpty()) {
            return null;
        }
        Invocation lastInvocation = (Invocation)invocations.get(invocations.size() - 1);
        String defaultKeywordSet = BuildConfigManager.getDefaultKeywordSet((Invocation)lastInvocation);
        Map extensionKeywordsetMap = BuildConfigManager.getExtensionKeywordSetMap((Invocation)lastInvocation);
        IBuildConfigParserConstants.ToolCompat toolCompat = lastInvocation.getToolCompat();
        return Utils.getInstance().parsePattern(pattern, defaultKeywordSet, extensionKeywordsetMap, toolCompat, true, rfProject);
    }

    private Set<String> expandOperatorWildcard(HashSet<String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> expandedPatterns = new HashSet<String>();
        for (String pattern : patterns) {
            if (!pattern.contains(ANY_OP)) {
                expandedPatterns.add(pattern);
                continue;
            }
            for (String operator : ALL_SEQUENCE_OPERATORS) {
                expandedPatterns.add(pattern.replace(ANY_OP, operator));
            }
        }
        return expandedPatterns;
    }

    public void performCheckOnAllClockingEvents(OVMProject project, Set<Integer> numericalAssertKind, Set<Integer> numericalPropertySequenceKind) {
        List<IHidOperator> clockingEvents;
        NullProtectedList<RfNamedElement> allSequencesAndProperties = new NullProtectedList<RfNamedElement>();
        if (numericalPropertySequenceKind.contains(2)) {
            allSequencesAndProperties.addAll(project.getAllSequences());
        }
        if (numericalPropertySequenceKind.contains(1)) {
            allSequencesAndProperties.addAll(project.getAllProperties());
        }
        for (RfNamedElement assertExpect : this.fOVMProject.getAllAssertsExpects()) {
            if (!(assertExpect instanceof RfAssertExpect) || !numericalAssertKind.contains(((RfAssertExpect)assertExpect).getAssertType())) continue;
            this.notifyCheckAlive();
            clockingEvents = ((RfAssertExpect)assertExpect).getClockingEvents();
            this.checkClockingEvents(clockingEvents, assertExpect);
        }
        for (RfNamedElement propSeq : allSequencesAndProperties) {
            if (!(propSeq instanceof RfPropertySequence)) continue;
            this.notifyCheckAlive();
            clockingEvents = ((RfPropertySequence)propSeq).getClockingEvents();
            this.checkClockingEvents(clockingEvents, propSeq);
        }
    }

    public void detectPattern(OVMProject project, HashSet<String> patterns, String hitMessagePattern, Set<Integer> numericalAssertKind, Set<Integer> numericalPropertySequenceKind) {
        this.detectPattern(project, patterns, hitMessagePattern, numericalAssertKind, numericalPropertySequenceKind, false);
    }

    public void detectPattern(OVMProject project, HashSet<String> patterns, String hitMessagePattern, Set<Integer> numericalAssertKind, Set<Integer> numericalPropertySequenceKind, boolean filter) {
        NullProtectedList<RfNamedElement> allSequencesAndProperties = new NullProtectedList<RfNamedElement>();
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        RfAssertExpect[] allAssertExpects = rfProject.getAllAssertExpects();
        if (numericalPropertySequenceKind.contains(2)) {
            allSequencesAndProperties.addAll(project.getAllSequences());
        }
        if (numericalPropertySequenceKind.contains(1)) {
            allSequencesAndProperties.addAll(project.getAllProperties());
        }
        Set<String> expandedWildcardPatterns = this.expandOperatorWildcard(patterns);
        for (String pattern : expandedWildcardPatterns) {
            IHidObject patternTree = this.parsePattern(pattern);
            if (patternTree == null) continue;
            if (patternTree instanceof RfHidOperator var14_14 && propertySpec.isPropertySpec()) {
                patternTree = propertySpec.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR ? propertySpec.getLHValue() : propertySpec.getFirstRHValue();
            }
            RfAssertExpect[] rfAssertExpectArray = allAssertExpects;
            int n = allAssertExpects.length;
            int n2 = 0;
            while (n2 < n) {
                RfAssertExpect assertExpect = rfAssertExpectArray[n2];
                if (assertExpect != null) {
                    this.notifyCheckAlive();
                    RfPackage enclosingPackage = assertExpect.getEnclosingScope(RfPackage.class);
                    if ((enclosingPackage == null || !this.fOVMProject.isOVMElement(enclosingPackage)) && numericalAssertKind.contains(assertExpect.getAssertType()) && (expressionTree = assertExpect.getExpression()) != null && this.checkAssertExpression(patternTree, expressionTree, matchedExpressionString = new StringBuilder(), assertExpect)) {
                        this.addLocalHit(assertExpect, MessageFormat.format(hitMessagePattern, pattern, matchedExpressionString), filter);
                    }
                }
                ++n2;
            }
            for (RfNamedElement sequence : allSequencesAndProperties) {
                if (!(sequence instanceof RfPropertySequence) || (expressionTree = ((RfPropertySequence)sequence).getExpression()) == null || !this.checkAssertExpression(patternTree, expressionTree, matchedExpressionString = new StringBuilder(), sequence)) continue;
                this.addLocalHit(sequence, MessageFormat.format(hitMessagePattern, pattern, matchedExpressionString), filter);
            }
        }
    }

    public void checkClockingEvents(List<IHidOperator> clockingEvents, RfNamedElement assertionPropSeq) {
    }

    protected boolean checkAssertExpression(IHidObject pattern, IHidObject expression, StringBuilder matchedExpressionString, RfNamedElement assertion) {
        HashMap<String, String> patternToExpressionMapping = new HashMap<String, String>();
        HashMap<String, String> expressionToPatternMapping = new HashMap<String, String>();
        if (AbstractSVAPatternDetector.checkPattern(pattern, expression, patternToExpressionMapping, expressionToPatternMapping)) {
            matchedExpressionString.append(HidUtils.toNiceString((IHidObject)expression));
            return true;
        }
        if (expression instanceof IHidOperator) {
            return this.checkOperands(pattern, (IHidOperator)expression, matchedExpressionString);
        }
        if (expression instanceof IHidAccessArgs) {
            return this.checkArguments(pattern, (IHidAccessArgs)expression, matchedExpressionString);
        }
        return false;
    }

    public boolean checkOperands(IHidObject pattern, IHidOperator expression, StringBuilder matchedExpressionString) {
        IHidObject lhValue = expression.getLHValue();
        ListContainer rhValues = expression.getRHValues();
        boolean isDisableIffExpression = expression.isDisableIffExpr();
        if (!isDisableIffExpression && this.checkAssertExpression(pattern, lhValue, matchedExpressionString, null)) {
            return true;
        }
        if (rhValues == null || rhValues.isEmpty()) {
            return false;
        }
        for (IHidObject rhValue : rhValues) {
            if (!this.checkAssertExpression(pattern, rhValue, matchedExpressionString, null)) continue;
            return true;
        }
        return false;
    }

    public boolean checkArguments(IHidObject pattern, IHidAccessArgs expression, StringBuilder matchedExpressionString) {
        List argumentValues = expression.getArgumentValues();
        if (argumentValues == null || argumentValues.isEmpty()) {
            return false;
        }
        for (IHidObject argument : argumentValues) {
            if (!this.checkAssertExpression(pattern, argument, matchedExpressionString, null)) continue;
            return true;
        }
        return false;
    }

    static boolean checkPattern(IHidObject pattern, IHidObject expression, Map<String, String> patternToExpressionMapping, Map<String, String> expressionToPatternMapping) {
        if (pattern == null || expression == null) {
            return false;
        }
        switch (pattern.getHidKind()) {
            case ACCESS: {
                if (!(expression instanceof RfHidAccess)) {
                    return false;
                }
                boolean argumentCheckResult = true;
                RfHidAccess patternAccess = (RfHidAccess)pattern;
                RfHidAccess expressionAccess = (RfHidAccess)expression;
                Hid patternParentHid = patternAccess.getParentHid();
                Hid expressionParentHid = expressionAccess.getParentHid();
                if (patternParentHid == null || expressionParentHid == null || !patternParentHid.getName().equals(expressionParentHid.getName())) {
                    return false;
                }
                if (!(expressionAccess instanceof IHidAccessArgs) || !(patternAccess instanceof IHidAccessArgs)) break;
                List patternArgumentValues = ((IHidAccessArgs)patternAccess).getArgumentValues();
                List expressionArgumentValues = ((IHidAccessArgs)expressionAccess).getArgumentValues();
                if (patternArgumentValues == null) {
                    return false;
                }
                if (expressionArgumentValues == null) {
                    return false;
                }
                if (patternArgumentValues.size() != expressionArgumentValues.size()) {
                    return false;
                }
                int i = 0;
                while (i < patternArgumentValues.size()) {
                    argumentCheckResult &= AbstractSVAPatternDetector.checkPattern((IHidObject)patternArgumentValues.get(i), (IHidObject)expressionArgumentValues.get(i), patternToExpressionMapping, expressionToPatternMapping);
                    ++i;
                }
                return argumentCheckResult;
            }
            case IMPLICIT: {
                return AbstractSVAPatternDetector.checkVariableOrConstant(expression, ((RfHidImplicit)pattern).getName(), patternToExpressionMapping, expressionToPatternMapping);
            }
            case HID: {
                if (expression instanceof RfHidOperator && ((RfHidOperator)expression).isLogicalNot()) {
                    return false;
                }
                return AbstractSVAPatternDetector.checkVariableOrConstant(expression, ((RfHid)pattern).getName(), patternToExpressionMapping, expressionToPatternMapping);
            }
            case OPERATOR: {
                int patternOperatorType;
                if (!(expression instanceof RfHidOperator)) {
                    return false;
                }
                RfHidOperator patternOperator = (RfHidOperator)pattern;
                RfHidOperator expressionOperator = (RfHidOperator)expression;
                int expressionOperatorType = expressionOperator.getOperatorType();
                if (expressionOperatorType != (patternOperatorType = patternOperator.getOperatorType())) {
                    return false;
                }
                if (!expressionOperator.getOperatorText().equals(patternOperator.getOperatorText())) {
                    return false;
                }
                ListContainer patternRHValues = patternOperator.getRHValues();
                ListContainer expressionRHValues = expressionOperator.getRHValues();
                if (patternRHValues != null && expressionRHValues != null) {
                    int expressionSize;
                    int patternSize = patternRHValues.size();
                    if (patternSize != (expressionSize = expressionRHValues.size())) {
                        return false;
                    }
                    int i = patternSize - 1;
                    while (i >= 0) {
                        IHidObject expressionRHValue;
                        IHidObject patternRHValue = (IHidObject)patternRHValues.get(i);
                        if (!AbstractSVAPatternDetector.checkPattern(patternRHValue, expressionRHValue = (IHidObject)expressionRHValues.get(i), patternToExpressionMapping, expressionToPatternMapping)) {
                            return false;
                        }
                        --i;
                    }
                } else if (patternRHValues != null && expressionRHValues == null || patternRHValues == null && expressionRHValues != null) {
                    return false;
                }
                return AbstractSVAPatternDetector.checkPattern(patternOperator.getLHValue(), expressionOperator.getLHValue(), patternToExpressionMapping, expressionToPatternMapping);
            }
        }
        return true;
    }

    static boolean checkVariableOrConstant(IHidObject expression, String patternName, Map<String, String> patternToExpressionMapping, Map<String, String> expressionToPatternMapping) {
        String expressionName;
        if (ANY.equals(patternName)) {
            return true;
        }
        if (patternName.startsWith("_") && patternName.endsWith("_")) {
            String expressionString = HidUtils.toNiceString((IHidObject)expression);
            if (expressionString.isEmpty()) {
                return false;
            }
            if (patternToExpressionMapping.containsKey(patternName)) {
                return patternToExpressionMapping.get(patternName).equals(expressionString);
            }
            patternToExpressionMapping.put(patternName, expressionString);
            if (expressionToPatternMapping.containsKey(expressionString)) {
                return expressionToPatternMapping.get(expressionString).equals(patternName);
            }
            expressionToPatternMapping.put(expressionString, patternName);
            return true;
        }
        String string = expressionName = expression instanceof RfHid ? ((RfHid)expression).getName() : EMPTY;
        if (expressionName == null || expressionName.isEmpty()) {
            String string2 = expressionName = expression instanceof RfHidImplicit ? ((RfHidImplicit)expression).getName() : EMPTY;
        }
        if (expressionName == null || expressionName.isEmpty()) {
            String string3 = expressionName = expression instanceof RfHidOperator ? HidUtils.toNiceString((IHidObject)expression) : EMPTY;
        }
        return patternName.equals(expressionName);
    }

    public Set<Integer> getNumericalAssertKind(HashSet<String> literalAssertionKind) {
        HashSet<Integer> numericalAssertKinds = new HashSet<Integer>();
        for (String elementKind : literalAssertionKind) {
            if (elementKind.equals("immediate_assert")) {
                numericalAssertKinds.add(0);
            }
            if (elementKind.equals("concurrent_assert")) {
                numericalAssertKinds.add(2);
            }
            if (elementKind.equals("expect")) {
                numericalAssertKinds.add(1);
            }
            if (elementKind.equals("immediate_assume")) {
                numericalAssertKinds.add(3);
            }
            if (elementKind.equals("concurrent_assume")) {
                numericalAssertKinds.add(4);
            }
            if (elementKind.equals("immediate_cover")) {
                numericalAssertKinds.add(5);
            }
            if (elementKind.equals("concurrent_cover_sequence")) {
                numericalAssertKinds.add(7);
            }
            if (elementKind.equals("concurrent_cover_property")) {
                numericalAssertKinds.add(6);
            }
            if (!elementKind.equals("restrict")) continue;
            numericalAssertKinds.add(8);
        }
        return numericalAssertKinds;
    }

    public Set<Integer> getNumericalPropertySequenceKind(HashSet<String> literalPropertySequenceKind) {
        HashSet<Integer> numericalPropertySequenceKinds = new HashSet<Integer>();
        for (String elementKind : literalPropertySequenceKind) {
            if (elementKind.equals("property")) {
                numericalPropertySequenceKinds.add(1);
            }
            if (!elementKind.equals("sequence")) continue;
            numericalPropertySequenceKinds.add(2);
        }
        return numericalPropertySequenceKinds;
    }

    public void addLocalHit(RfNamedElement elm, String details, boolean filter) {
        this.addHit(elm, details);
    }

    public IHidObject getDisableIffExpressionTree(RfAssertExpect assertExpect) {
        if (!assertExpect.hasDisabledIff()) {
            return null;
        }
        DisableIffVisitor visitor = new DisableIffVisitor();
        assertExpect.visitHidObject(this.fOVMProject.getRfProject(), visitor);
        return visitor.getDisableConditionExpressionTree();
    }

    class DisableIffVisitor
    implements IHidVisitor<RfHidOperator> {
        private IHidObject disableConditionExpressionTree;

        DisableIffVisitor() {
        }

        public boolean visit(RfHidOperator operator) {
            AbstractSVAPatternDetector.this.notifyCheckAlive();
            if (!operator.isDisableIffExpr()) {
                return true;
            }
            IHidObject iffHid = operator.getLHValue();
            if (!(iffHid instanceof RfHidOperator)) {
                return true;
            }
            if (!((RfHidOperator)iffHid).isIffExpression()) {
                return true;
            }
            this.disableConditionExpressionTree = ((RfHidOperator)iffHid).getLHValue();
            if (this.disableConditionExpressionTree == null) {
                return true;
            }
            return true;
        }

        private IHidObject getDisableConditionExpressionTree() {
            return this.disableConditionExpressionTree;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

