/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

public abstract class AbstractSVAssertsVisitor
extends OVMComplianceCheck {
    public AbstractSVAssertsVisitor(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    public void performCheckOnAssertions(OVMProject project, Set<Integer> numericalAssertKind, Set<Integer> numericalPropertySequenceKind, HashSet<String> allowedSampleValueFunctions) {
        ParserPath parserPath;
        RfFileDef file;
        NullProtectedList<RfNamedElement> allSequencesAndProperties = new NullProtectedList<RfNamedElement>();
        if (numericalPropertySequenceKind.contains(1)) {
            allSequencesAndProperties.addAll(project.getAllProperties());
        }
        for (RfNamedElement assertExpect : this.fOVMProject.getAllAssertsExpects()) {
            if (!(assertExpect instanceof RfAssertExpect) || !numericalAssertKind.contains(((RfAssertExpect)assertExpect).getAssertType()) || (file = assertExpect.getFile()) == null || (parserPath = file.getParserPath()) == null || !this.isValidElement(assertExpect, parserPath)) continue;
            this.notifyCheckAlive();
            this.visitAssertionSignalsOrDisableCondition(assertExpect, parserPath, allowedSampleValueFunctions);
        }
        for (RfNamedElement sequenceOrProperty : allSequencesAndProperties) {
            if (!(sequenceOrProperty instanceof RfPropertySequence) || (file = sequenceOrProperty.getFile()) == null || (parserPath = file.getParserPath()) == null || !this.isValidElement(sequenceOrProperty, parserPath)) continue;
            this.notifyCheckAlive();
            this.visitAssertionSignalsOrDisableCondition(sequenceOrProperty, parserPath, allowedSampleValueFunctions);
        }
    }

    private boolean isValidElement(RfNamedElement element, ParserPath parserPath) {
        RfPackage enclosingPackage = element.getEnclosingScope(RfPackage.class);
        if (enclosingPackage != null && this.fOVMProject.isOVMElement(enclosingPackage)) {
            return false;
        }
        return !this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public void visitAssertionSignalsOrDisableCondition(RfNamedElement assertExpect, ParserPath parserPath, HashSet<String> allowedSampleValueFunctions) {
    }

    public void visitExpressionsTree(IHidObject expressionTree, ParserPath parserPath, HashSet<String> allowedSampleValueFunctions) {
        if (expressionTree == null || expressionTree instanceof RfHidImplicit) {
            return;
        }
        if (!(expressionTree instanceof RfHidOperator) && !(expressionTree instanceof RfHidAccessArgs)) {
            this.addErrorMessage(expressionTree, parserPath, null);
            return;
        }
        this.notifyCheckAlive();
        if (expressionTree instanceof RfHidOperator) {
            IHidObject lhValue = ((RfHidOperator)expressionTree).getLHValue();
            this.visitExpressionsTree(lhValue, parserPath, allowedSampleValueFunctions);
            ListContainer rhValues = ((RfHidOperator)expressionTree).getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return;
            }
            for (IHidObject rhValue : rhValues) {
                this.visitExpressionsTree(rhValue, parserPath, allowedSampleValueFunctions);
            }
            return;
        }
        Hid calledFunction = ((RfHidAccessArgs)expressionTree).getParentHid();
        if (calledFunction == null) {
            return;
        }
        IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)calledFunction);
        if (resolvedElement == null || !(resolvedElement instanceof RfFunction)) {
            return;
        }
        if (allowedSampleValueFunctions.contains(resolvedElement.getName())) {
            return;
        }
        List methodCalls = MethodCallUtils.getMethodCalls((IHid)calledFunction);
        for (MethodCall methodCall : methodCalls) {
            Map argVals = methodCall.argumentValuesMapRaw;
            for (IHidObject hidOjs : argVals.values()) {
                this.visitExpressionsTree(hidOjs, parserPath, allowedSampleValueFunctions);
            }
        }
    }

    public void addErrorMessage(IHidObject notSampletVariable, ParserPath parserPath, HidOccurrence occurence) {
        IHid hid = HidUtils.getHidFrom((IHidObject)notSampletVariable);
        if (!(hid instanceof RfHid)) {
            return;
        }
        IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)hid);
        if (!(resolvedElement instanceof RfNamedElement)) {
            return;
        }
        String message = this.computeErrorMessage((RfNamedElement)resolvedElement);
        if (occurence == null) {
            this.addHit(parserPath, (RfHid)hid, message);
            return;
        }
        this.addHit(parserPath, occurence, message);
    }

    public abstract String computeErrorMessage(RfNamedElement var1);

    public Set<Integer> getNumericalAssertKind(HashSet<String> literalAssertionKind) {
        HashSet<Integer> numericalAssertKinds = new HashSet<Integer>();
        for (String elementKind : literalAssertionKind) {
            if (elementKind.equals("immediate_assert")) {
                numericalAssertKinds.add(0);
            }
            if (elementKind.equals("concurrent_assert")) {
                numericalAssertKinds.add(2);
            }
            if (elementKind.equals("expect")) {
                numericalAssertKinds.add(1);
            }
            if (elementKind.equals("immediate_assume")) {
                numericalAssertKinds.add(3);
            }
            if (elementKind.equals("concurrent_assume")) {
                numericalAssertKinds.add(4);
            }
            if (elementKind.equals("immediate_cover")) {
                numericalAssertKinds.add(5);
            }
            if (elementKind.equals("concurrent_cover_sequence")) {
                numericalAssertKinds.add(7);
            }
            if (elementKind.equals("concurrent_cover_property")) {
                numericalAssertKinds.add(6);
            }
            if (!elementKind.equals("restrict")) continue;
            numericalAssertKinds.add(8);
        }
        return numericalAssertKinds;
    }

    public Set<Integer> getNumericalPropertySequenceKind(HashSet<String> literalPropertySequenceKind) {
        HashSet<Integer> numericalPropertySequenceKinds = new HashSet<Integer>();
        for (String elementKind : literalPropertySequenceKind) {
            if (elementKind.equals("property")) {
                numericalPropertySequenceKinds.add(1);
            }
            if (!elementKind.equals("sequence")) continue;
            numericalPropertySequenceKinds.add(2);
        }
        return numericalPropertySequenceKinds;
    }
}

