/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.svtb.AbstractMaxHitsPerFileCheck;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

public abstract class AbstractSVTBSimpleIssues
extends AbstractMaxHitsPerFileCheck {
    DocumentManager docManager;

    public AbstractSVTBSimpleIssues(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected String getFailMessage(SVTBIssues issue, ParserPath parserPath) {
        return this.getFailMessage(issue);
    }

    protected abstract String getFailMessage(SVTBIssues var1);

    protected abstract Map<ParserPath, List<SVTBIssues>> getSVTBIssues();

    @Override
    public void performCheckImpl() {
        this.docManager = this.getDocumentManager();
        Map<ParserPath, List<SVTBIssues>> allIssues = this.getSVTBIssues();
        block0: for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
            List<SVTBIssues> issues;
            int hitCounterPerFile = 0;
            ParserPath parserPath = entry.getKey();
            if (this.checkPreWaivers(parserPath) || (issues = entry.getValue()) == null) continue;
            for (SVTBIssues issue : issues) {
                OVMComplianceHit hit = this.addHit(parserPath, issue.getLine(), this.getFailMessage(issue, parserPath), issue.getReparseInfo(), this.isForceFailure(issue.getReparseInfo()), this.getVerissimoAutofixAdditionalInfo(issue), this.isHidden(hitCounterPerFile));
                if (hit != null) {
                    ++hitCounterPerFile;
                }
                if (this.reachedMaxHitCountInFile(hitCounterPerFile)) continue block0;
            }
        }
        this.docManager.deactivate();
    }

    protected boolean isForceFailure(ReparseInfo reparseInfo) {
        return false;
    }

    protected VerissimoAutofixAdditionalInfo getVerissimoAutofixAdditionalInfo(SVTBIssues issue) {
        return new VerissimoAutofixAdditionalInfo(issue);
    }

    private DocumentManager getDocumentManager() {
        DocumentManager docManager = new DocumentManager();
        try {
            docManager.activate();
        }
        catch (IllegalStateException illegalStateException) {}
        return docManager;
    }

    protected int getOffsetOnLine(IDocument document, SVTBIssues issue) {
        int lineStartOffset = 0;
        int offsetOnLine = 0;
        try {
            lineStartOffset = document.getLineOffset(issue.getLine() - 1);
            offsetOnLine = issue.getOffset() - lineStartOffset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return offsetOnLine;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

