/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;

public abstract class AbstractSingleStatementCheck
extends AbstractSVTBSimpleIssues {
    protected ContentReader contentReader = new ContentReader();
    @CheckParameter(defaultValue="false", description="When <allowSameLine> is true, it will check that the next line is also empty.", name="checkNextLineEmpty", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckNextLineEmpty;
    @CheckParameter(defaultValue="", description="Comma separated list of keywords that can be on the same line when <allowSameLine> is true. Possible values: if, for, foreach, forever, while, repeat, do, fork, assert, else, wait.", name="allowedKeywords", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pAllowedKeywords;
    public static final String EMPTY_NEXT_LINE_HIT_MESSAGE = "Next line should be empty or contain only whitespaces!";

    public AbstractSingleStatementCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected boolean isEmptyLine(ParserPath parserPath, int line) {
        String nextLineString = this.contentReader.getLine(parserPath, line);
        if (nextLineString == null) {
            return true;
        }
        return nextLineString.trim().isEmpty();
    }

    @Override
    public void clean() {
        super.clean();
        if (this.contentReader != null) {
            this.contentReader.clear();
        }
    }

    class ContentReader {
        private Map<ParserPath, List<String>> readFiles = new HashMap<ParserPath, List<String>>();

        protected ContentReader() {
        }

        String getLine(ParserPath parserPath, Integer line) {
            List<String> fileContent;
            if (!this.readFiles.containsKey(parserPath)) {
                this.readFile(parserPath);
            }
            if ((fileContent = this.readFiles.get(parserPath)).size() <= line - 1) {
                return null;
            }
            return fileContent.get(line - 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void readFile(ParserPath parserPath) {
            BufferedReader reader = null;
            String line = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(parserPath.path));
                    if (!this.readFiles.containsKey(parserPath)) {
                        this.readFiles.put(parserPath, new ArrayList());
                    }
                    while ((line = reader.readLine()) != null) {
                        this.readFiles.get(parserPath).add(line);
                    }
                    return;
                }
                catch (FileNotFoundException e) {
                    AbstractSingleStatementCheck.this.fOVMProject.notifyCheckException(AbstractSingleStatementCheck.this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (reader == null) return;
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException e2) {
                        AbstractSingleStatementCheck.this.fOVMProject.notifyCheckException(AbstractSingleStatementCheck.this, e2);
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                    return;
                }
                catch (IOException e) {
                    AbstractSingleStatementCheck.this.fOVMProject.notifyCheckException(AbstractSingleStatementCheck.this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (reader == null) return;
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException e3) {
                        AbstractSingleStatementCheck.this.fOVMProject.notifyCheckException(AbstractSingleStatementCheck.this, e3);
                        DVTLogger.INSTANCE.logError((Throwable)e3);
                    }
                    return;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        AbstractSingleStatementCheck.this.fOVMProject.notifyCheckException(AbstractSingleStatementCheck.this, e);
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }

        protected void clear() {
            this.readFiles.clear();
        }
    }
}

