/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

public abstract class AbstractStaticCastToTypeCheck
extends OVMComplianceCheck {
    public AbstractStaticCastToTypeCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(42);
    }

    protected abstract String getFailMessage();

    protected abstract boolean isTypeAllowed(String var1, RfNamedElement var2);

    protected void checkStaticCast() {
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(42);
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
            ParserPath parserPath = entry.getKey();
            if (this.checkPrewaivers(parserPath)) continue;
            List<SVTBIssues> issues = entry.getValue();
            RfFileDef filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
            if (filedef == null || issues == null) continue;
            for (SVTBIssues issue : issues) {
                RfDefElement defScope = filedef.getScope(issue.getOffset(), true);
                RfNamedElement scope = defScope.getNamedElement();
                String info = issue.getInfo();
                if (info == null || this.isTypeAllowed(info, scope)) continue;
                this.addHit(parserPath, issue.getLine(), this.getFailMessage(), issue.getReparseInfo());
            }
        }
    }

    protected boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

