/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

public abstract class AbstractTimescaleAtFileLevel
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Only modules matching namePattern are checked. When empty, check all modules.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern namePattern;

    protected AbstractTimescaleAtFileLevel(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(37);
    }

    public abstract Collection<RfNamedElement> getComponents();

    protected abstract String getComponentType();

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    @Override
    public void performCheckImpl() {
        Collection<RfNamedElement> allComponents = this.getComponents();
        if (allComponents == null || allComponents.isEmpty()) {
            return;
        }
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(37);
        for (RfNamedElement component : allComponents) {
            if (this.analyzeComponent(allIssues, component)) continue;
            this.addHit(component, "File of " + this.getComponentType() + " '" + component.getName() + "' does not include a `timescale at file scope");
        }
    }

    protected boolean analyzeComponent(Map<ParserPath, List<SVTBIssues>> allIssues, RfNamedElement component) {
        Matcher m;
        if (component == null) {
            return false;
        }
        if (this.checkPreWaivers(component.getFile())) {
            return false;
        }
        String componentName = component.getName();
        if (componentName == null) {
            return false;
        }
        this.notifyCheckAlive();
        if (!this.namePattern.pattern().isEmpty() && !(m = this.namePattern.matcher(componentName)).matches()) {
            return false;
        }
        ParserPath parserPath = component.getDeclaration().getParserPath();
        List<SVTBIssues> fileTimescales = allIssues.get(parserPath);
        if (fileTimescales == null || fileTimescales.isEmpty()) {
            return false;
        }
        boolean timescaleAtProjectLevel = false;
        RfFileDef filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
        if (filedef == null) {
            return false;
        }
        for (SVTBIssues issue : fileTimescales) {
            RfDefElement defScope = filedef.getScope(issue.getOffset(), true);
            if (defScope instanceof RfFileDef) {
                timescaleAtProjectLevel = true;
                break;
            }
            if (issue.getLine() != component.getLine() || component.getDeclaration().getReparseInfo() == null) continue;
            timescaleAtProjectLevel = true;
            break;
        }
        return timescaleAtProjectLevel;
    }
}

