/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;

public abstract class AbstractTypeAndDirectionCheck
extends OVMComplianceCheck {
    protected int implicitType;

    protected AbstractTypeAndDirectionCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfDefElement> elementsToCheck = this.getAllElementsToCheck();
        if (elementsToCheck == null || elementsToCheck.isEmpty()) {
            return;
        }
        for (RfDefElement element : elementsToCheck) {
            List<RfField> members;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(element.getParserPath()) || (members = this.getCheckedMembers(element)) == null || members.isEmpty()) continue;
            boolean foundMemberWithNonDefaultDirection = false;
            for (RfField member : members) {
                DataType dataType = member.getDataType();
                if (dataType == null) continue;
                if (this.checkMemberDataType() && (dataType.hasImplicitType() || dataType.isInherited())) {
                    this.addHit(member, String.valueOf(this.getMemberInfo(member)) + " is declared with implicit data type!");
                }
                if (!this.checkMemberDirection() || foundMemberWithNonDefaultDirection || dataType.hasImplicitDirection() || dataType.getRawDirection() == this.implicitType) continue;
                foundMemberWithNonDefaultDirection = true;
            }
            if (!this.checkMemberDirection() || !foundMemberWithNonDefaultDirection) continue;
            boolean encounteredMemberWithNonDefaultDirection = false;
            for (RfField member : members) {
                DataType dataType = member.getDataType();
                if (dataType == null) continue;
                if (!dataType.hasImplicitDirection()) {
                    if (dataType.getRawDirection() == this.implicitType) continue;
                    encounteredMemberWithNonDefaultDirection = true;
                    continue;
                }
                if (this.shouldSkip() && !encounteredMemberWithNonDefaultDirection) continue;
                this.addHit(member, String.valueOf(this.getMemberInfo(member)) + " is declared with implicit direction!");
            }
        }
    }

    protected abstract List<RfDefElement> getAllElementsToCheck();

    protected abstract List<RfField> getCheckedMembers(Object var1);

    protected abstract String getMemberInfo(Object var1);

    protected abstract boolean checkMemberDataType();

    protected abstract boolean checkMemberDirection();

    protected abstract boolean shouldSkip();

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

