/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractUsedFunctionReturnValueCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="", name="skipCallsCastedToVoid", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN, isVisible=false)
    protected boolean pSkipCallsCastedToVoidValue;
    @CheckParameter(defaultValue="false", description="", name="skipTasks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN, isVisible=false)
    protected boolean pSkipTasksValue;

    protected AbstractUsedFunctionReturnValueCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(1001);
    }

    protected void reportUnusedFunctionReturnValues(String fullName, boolean predefinedMethod) {
        AssignmentMethodVisitor assignmentVisitor = new AssignmentMethodVisitor(fullName, predefinedMethod);
        this.fOVMProject.getRfProject().visitHidObject(null, assignmentVisitor);
        this.fOVMProject.getRfProject().visitHidObject(null, new MethodCallVisitor(fullName, predefinedMethod, assignmentVisitor.getAssignedCalls(), assignmentVisitor.getVoidCastCalls()));
    }

    private boolean checkPreWaivers(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }

    private class AssignmentMethodVisitor
    implements IHidVisitor<IHidOperator> {
        private ParserPath parserPath;
        private String fullName;
        private boolean predefinedMethod;
        private Map<ParserPath, Set<HidOccurrence>> assignedCalls;
        private Map<ParserPath, Set<HidOccurrence>> voidCastCalls;
        private RfNamedElement scope;

        public AssignmentMethodVisitor(String fullName, boolean predefinedMethod) {
            this.fullName = fullName;
            this.predefinedMethod = predefinedMethod;
            this.assignedCalls = new HashMap<ParserPath, Set<HidOccurrence>>();
            this.voidCastCalls = new HashMap<ParserPath, Set<HidOccurrence>>();
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidOperator operator) {
            if (!(operator.hasOccurrence(HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION) || operator.hasOccurrence(HidOperatorQualifier.IS_ASSERT_EXPRESSION) || operator.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) || operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN) || operator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE) || operator.isVoidCast() || operator.isReturnStatement())) {
                return true;
            }
            if (AbstractUsedFunctionReturnValueCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            AbstractUsedFunctionReturnValueCheck.this.notifyCheckAlive();
            if (AbstractUsedFunctionReturnValueCheck.this.pSkipTasksValue && this.scope instanceof RfFunction && ((RfFunction)this.scope).isTask()) {
                return true;
            }
            if (operator.isReturnStatement()) {
                Set operators = HidUtils.flattenToOperators((IHidOperator)operator);
                if (operators != null) {
                    for (IHidOperator op : operators) {
                        this.checkOperatorValue(op.getLHValue());
                        this.checkOperatorValue(op.getFirstRHValue());
                    }
                }
                return true;
            }
            if (operator.isVoidCast()) {
                IHidObject voidCastValue = operator.getLHValue();
                if (AbstractUsedFunctionReturnValueCheck.this.pSkipCallsCastedToVoidValue) {
                    this.checkOperatorValue(voidCastValue);
                    return true;
                }
                Hid rhValue = null;
                if (voidCastValue instanceof RfHidAccessArgs) {
                    rhValue = ((RfHidAccessArgs)voidCastValue).getParentHid();
                }
                if (rhValue instanceof RfHid) {
                    Set<HidOccurrence> localCalls = this.voidCastCalls.get(this.parserPath);
                    if (localCalls == null) {
                        localCalls = new HashSet<HidOccurrence>();
                        this.voidCastCalls.put(this.parserPath, localCalls);
                    }
                    localCalls.add(((RfHid)rhValue).getOccurrence());
                }
            }
            ListContainer rhValues = operator.getRHValues();
            if (operator.hasOccurrence(HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION) || operator.hasOccurrence(HidOperatorQualifier.IS_ASSERT_EXPRESSION)) {
                Set operators = HidUtils.flattenToOperators((IHidOperator)operator);
                if (operators != null) {
                    for (IHidOperator op : operators) {
                        this.checkOperatorValue(op.getLHValue());
                        this.checkOperatorValue(op.getFirstRHValue());
                    }
                }
                return true;
            }
            if (rhValues == null) {
                return true;
            }
            for (Hid rhValue : rhValues) {
                this.checkOperatorValue((IHidObject)rhValue);
            }
            return true;
        }

        protected void checkOperatorValue(IHidObject rhValue) {
            if (rhValue instanceof RfHidAccessArgs) {
                RfHidAccessArgs hidArgs = (RfHidAccessArgs)rhValue;
                rhValue = hidArgs.getParentHid();
            }
            if (!(rhValue instanceof RfHid)) {
                return;
            }
            RfHid rhHid = (RfHid)rhValue;
            if (!rhHid.isMethodCall(false)) {
                return;
            }
            IRfNamedElement element = rhHid.getElement();
            if (!(element instanceof RfFunction)) {
                return;
            }
            RfFunction function = (RfFunction)element;
            if (this.predefinedMethod != function.isPredefined() || !this.fullName.equals(function.getFullName())) {
                return;
            }
            Set<HidOccurrence> localCalls = this.assignedCalls.get(this.parserPath);
            if (localCalls == null) {
                localCalls = new HashSet<HidOccurrence>();
                this.assignedCalls.put(this.parserPath, localCalls);
            }
            localCalls.add(rhHid.getOccurrence());
        }

        public Map<ParserPath, Set<HidOccurrence>> getAssignedCalls() {
            return this.assignedCalls;
        }

        public Map<ParserPath, Set<HidOccurrence>> getVoidCastCalls() {
            return this.voidCastCalls;
        }

        public Class<IHidOperator> getType() {
            return IHidOperator.class;
        }
    }

    private class MethodCallVisitor
    extends RfHidVisitor {
        private String fullName;
        private boolean predefinedMethod;
        private RfNamedElement scope;
        private Map<ParserPath, Set<HidOccurrence>> assignedCalls;
        private Map<ParserPath, Set<HidOccurrence>> voidCastCalls;

        public MethodCallVisitor(String fullName, boolean predefinedMethod, Map<ParserPath, Set<HidOccurrence>> assignedCalls, Map<ParserPath, Set<HidOccurrence>> voidCastCalls) {
            this.fullName = fullName;
            this.predefinedMethod = predefinedMethod;
            this.assignedCalls = assignedCalls;
            this.voidCastCalls = voidCastCalls;
        }

        public boolean visit(RfHid rfHid) {
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            if (AbstractUsedFunctionReturnValueCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            AbstractUsedFunctionReturnValueCheck.this.notifyCheckAlive();
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (AbstractUsedFunctionReturnValueCheck.this.pSkipTasksValue && this.scope instanceof RfFunction && ((RfFunction)this.scope).isTask()) {
                return true;
            }
            if (this.predefinedMethod != function.isPredefined() || !this.fullName.equals(function.getFullName())) {
                return true;
            }
            Set<HidOccurrence> localCalls = this.assignedCalls.get(this.parserPath);
            if (localCalls != null && localCalls.contains(rfHid.getOccurrence())) {
                return true;
            }
            localCalls = this.voidCastCalls.get(this.parserPath);
            boolean isCastToVoid = localCalls != null && localCalls.contains(rfHid.getOccurrence());
            AbstractUsedFunctionReturnValueCheck.this.addHit(this.parserPath, rfHid.getOccurrence(), "'" + HidUtils.toNiceString((IHidObject)rfHid) + "' return value is not used!", new VerissimoAutofixAdditionalInfo((Object)rfHid, new DVTPair((Object)this.scope, (Object)isCastToVoid)));
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

