/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.svtb.ICITElementsVisitorImpl;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

public class CITElementsVisitor {
    private String fElementKind;
    private boolean fCheckTypedefs;
    private boolean fEnforceExclusivity;
    private HashSet<String> fSkipIfTypedefTo;
    private HashSet<String> fSkipDeclaredInsideMacrosWithPrefixes;
    private boolean fSkipNestedTypedefsOfStructs;
    private HashSet<String> fSkipFieldsOfType;
    private OVMProject fOVMProject;
    private ICITElementsVisitorImpl fICITElementsVisitorImpl;
    private static final String[] elementKinds = new String[]{"package", "module", "class", "interface class", "non-interface class", "interface", "struct", "union", "enum", "typedef", "clocking", "modport", "covergroup", "function", "task", "parameter", "enum item", "assert", "sequence", "property", "assume", "cover", "constraint", "field"};

    public CITElementsVisitor(OVMProject aOVMProject, ICITElementsVisitorImpl aCITElementsVisitorImpl, String aElementKind, boolean aCheckTypedefs, boolean enforceExclusivity, HashSet<String> aSkipIfTypedefTo, HashSet<String> aSkipDeclaredInsideMacrosWithPrefixes, boolean aSkipNestedTypedefsOfStructs, HashSet<String> aSkipFieldsOfType) {
        this.fOVMProject = aOVMProject;
        this.fICITElementsVisitorImpl = aCITElementsVisitorImpl;
        this.fElementKind = aElementKind;
        this.fCheckTypedefs = aCheckTypedefs;
        this.fEnforceExclusivity = enforceExclusivity;
        this.fSkipIfTypedefTo = aSkipIfTypedefTo;
        this.fSkipDeclaredInsideMacrosWithPrefixes = aSkipDeclaredInsideMacrosWithPrefixes;
        this.fSkipNestedTypedefsOfStructs = aSkipNestedTypedefsOfStructs;
        this.fSkipFieldsOfType = aSkipFieldsOfType;
    }

    private Collection<? extends RfNamedElement> getElementsOfKind(String kind) {
        NullProtectedList<RfNamedElement> result;
        block35: {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block34: {
                                result = new NullProtectedList<RfNamedElement>();
                                if (!"class".equals(kind)) break block34;
                                result.addAll(this.fOVMProject.getAllNonXVMClasses());
                                if (!this.fCheckTypedefs) break block35;
                                result.addAll(this.fOVMProject.getAllTypedefs());
                                break block35;
                            }
                            if (!"non-interface class".equals(kind)) break block36;
                            List nonInterfaceClasses = this.fOVMProject.getAllNonXVMClasses().stream().filter(el -> !((RfClass)el).isInterfaceClass()).collect(Collectors.toCollection(ArrayList::new));
                            result.addAll(nonInterfaceClasses);
                            if (!this.fCheckTypedefs) break block35;
                            result.addAll(this.fOVMProject.getAllTypedefs());
                            break block35;
                        }
                        if (!"interface class".equals(kind)) break block37;
                        List interfaceClasses = this.fOVMProject.getAllNonXVMClasses().stream().filter(el -> ((RfClass)el).isInterfaceClass()).collect(Collectors.toCollection(ArrayList::new));
                        result.addAll(interfaceClasses);
                        if (!this.fCheckTypedefs) break block35;
                        result.addAll(this.fOVMProject.getAllTypedefs());
                        break block35;
                    }
                    if (!"interface".equals(kind)) break block38;
                    result.addAll(this.fOVMProject.getAllInterfaces());
                    if (!this.fCheckTypedefs) break block35;
                    result.addAll(this.fOVMProject.getAllTypedefs());
                    break block35;
                }
                if ("package".equals(kind)) {
                    return this.fOVMProject.getAllPackages();
                }
                if ("struct".equals(kind)) {
                    return this.fOVMProject.getAllTypedefs();
                }
                if ("union".equals(kind)) {
                    return this.fOVMProject.getAllTypedefs();
                }
                if ("enum".equals(kind)) {
                    return this.fOVMProject.getAllTypedefs();
                }
                if ("constraint".equals(kind)) {
                    return this.fOVMProject.getAllConstraints();
                }
                if ("clocking".equals(kind)) {
                    return this.fOVMProject.getAllClockingBlocks();
                }
                if (!"modport".equals(kind)) break block39;
                result.addAll(this.fOVMProject.getAllModports());
                if (!this.fCheckTypedefs) break block35;
                result.addAll(this.fOVMProject.getAllTypedefs());
                break block35;
            }
            if ("covergroup".equals(kind)) {
                return this.fOVMProject.getAllCovergroups();
            }
            if ("function".equals(kind)) {
                return this.fOVMProject.getAllFunctions();
            }
            if ("task".equals(kind)) {
                return this.fOVMProject.getAllTasks();
            }
            if ("typedef".equals(kind)) {
                List allTypedefs = this.fOVMProject.getAllTypedefs().stream().filter(el -> !(el instanceof RfForwardTypedef)).collect(Collectors.toCollection(ArrayList::new));
                result.addAll(allTypedefs);
            } else if ("enum item".equals(kind)) {
                for (RfNamedElement element : this.fOVMProject.getAllTypedefs()) {
                    List<RfField> enumElements;
                    RfNamedElement associatedType;
                    if (!(element instanceof RfAssociatedType) || !((associatedType = LintUtils.getAssociatedFinalType((RfAssociatedType)element)) instanceof RfStruct) || !((RfStruct)associatedType).isEnum() || (enumElements = ((RfStruct)associatedType).getEnumElementsWithPrefix("", 2, 1)) == null) continue;
                    result.addAll(enumElements);
                }
                for (RfNamedElement field : this.fOVMProject.getAllFields()) {
                    Collection members;
                    IRfNamedElement transientType;
                    if (!(field instanceof RfField) || (transientType = ((RfField)field).getAssociatedType()) == null || (members = transientType.getMembers(false, false)) == null) continue;
                    for (IRfNamedElement member : members) {
                        if (!(member instanceof RfField) || !((RfField)member).isEnumElement()) continue;
                        result.add((RfField)member);
                    }
                }
            } else if ("parameter".equals(kind)) {
                for (RfNamedElement type : this.fOVMProject.getAllTypes()) {
                    Collection<RfNamedElement> members = type.getMembers();
                    if (members == null) continue;
                    for (RfNamedElement member : members) {
                        if (!(member instanceof RfField) || !((RfField)member).isParameter()) continue;
                        result.add(member);
                    }
                }
            } else if ("module".equals(kind)) {
                result.addAll(this.fOVMProject.getAllModules());
            } else if ("assert".equals(kind)) {
                List allAssertsExpects = this.fOVMProject.getAllAssertsExpects().stream().filter(el -> el instanceof RfAssertExpect && !((RfAssertExpect)el).isAssume() && !((RfAssertExpect)el).isCover()).collect(Collectors.toCollection(ArrayList::new));
                result.addAll(allAssertsExpects);
            } else if ("sequence".equals(kind)) {
                result.addAll(this.fOVMProject.getAllSequences());
            } else if ("property".equals(kind)) {
                result.addAll(this.fOVMProject.getAllProperties());
            } else if ("assume".equals(kind)) {
                List allAssumes = this.fOVMProject.getAllAssertsExpects().stream().filter(el -> el instanceof RfAssertExpect && ((RfAssertExpect)el).isAssume()).collect(Collectors.toCollection(ArrayList::new));
                result.addAll(allAssumes);
            } else if ("cover".equals(kind)) {
                List allCovers = this.fOVMProject.getAllAssertsExpects().stream().filter(el -> el instanceof RfAssertExpect && ((RfAssertExpect)el).isCover()).collect(Collectors.toCollection(ArrayList::new));
                result.addAll(allCovers);
            } else if ("field".equals(kind)) {
                for (RfNamedElement field : this.fOVMProject.getAllFields()) {
                    if (((RfField)field).isEnumElement() || ((RfField)field).isFromEmbeddedCovergroupDef() || this.fSkipFieldsOfType == null || this.fSkipFieldsOfType.isEmpty()) continue;
                    IRfNamedElement assocType = ((RfField)field).getAssociatedType();
                    DataType dataType = ((RfField)field).getDataType();
                    if (this.fSkipFieldsOfType.contains("enum") && assocType instanceof RfStruct && dataType != null && dataType.containsTypeName("enum/") || this.fSkipFieldsOfType.contains("struct") && assocType instanceof RfStruct && dataType != null && dataType.containsTypeName("struct/") || this.fSkipFieldsOfType.contains("union") && assocType instanceof RfStruct && dataType != null && dataType.containsTypeName("union/") || this.fSkipFieldsOfType.contains("class") && assocType instanceof RfClass || this.fSkipFieldsOfType.contains("interface") && assocType instanceof RfInterface || this.fSkipFieldsOfType.contains("typedef") && assocType instanceof RfTypeAlias) continue;
                    result.add(field);
                }
            }
        }
        return result;
    }

    public void visit() {
        HashSet<RfNamedElement> elementsToCheck = new HashSet<RfNamedElement>();
        HashSet<RfNamedElement> elementsNotToCheck = new HashSet<RfNamedElement>();
        this.initElements(elementsToCheck, elementsNotToCheck);
        for (RfNamedElement elementToCheck : elementsToCheck) {
            this.checkElement(elementToCheck, true);
        }
        for (RfNamedElement elementToCheck : elementsNotToCheck) {
            this.checkElement(elementToCheck, false);
        }
    }

    private void checkElement(RfNamedElement elementToCheck, boolean isOfElementKind) {
        if (elementToCheck == null) {
            return;
        }
        if (elementToCheck instanceof RfProject || elementToCheck instanceof RfLibrary) {
            return;
        }
        boolean isTypedefMsg = false;
        if (isOfElementKind) {
            if (elementToCheck instanceof RfTypeAlias) {
                RfTypeAlias typeAlias = (RfTypeAlias)elementToCheck;
                IRfNamedElement typedefTarget = this.getTypedefTarget(typeAlias);
                if ("enum".equals(this.fElementKind) && this.getTypedefTargetForPrefix(typeAlias, "enum/") == null) {
                    return;
                }
                if ("struct".equals(this.fElementKind) && this.getTypedefTargetForPrefix(typeAlias, "struct/") == null) {
                    return;
                }
                if ("union".equals(this.fElementKind) && this.getTypedefTargetForPrefix(typeAlias, "union/") == null) {
                    return;
                }
                if ("typedef".equals(this.fElementKind)) {
                    if (this.fSkipIfTypedefTo.contains("enum") && this.getTypedefTargetForPrefix(typeAlias, "enum/") != null) {
                        return;
                    }
                    if (this.fSkipIfTypedefTo.contains("struct") && this.getTypedefTargetForPrefix(typeAlias, "struct/") != null) {
                        return;
                    }
                    if (this.fSkipIfTypedefTo.contains("union") && this.getTypedefTargetForPrefix(typeAlias, "union/") != null) {
                        return;
                    }
                    if (this.fSkipIfTypedefTo.contains("class") && typedefTarget instanceof RfClass) {
                        return;
                    }
                    if (this.fSkipIfTypedefTo.contains("interface class") && typedefTarget instanceof RfClass && ((RfClass)typedefTarget).isInterfaceClass()) {
                        return;
                    }
                    if (this.fSkipIfTypedefTo.contains("non-interface class") && typedefTarget instanceof RfClass && !((RfClass)typedefTarget).isInterfaceClass()) {
                        return;
                    }
                    if (this.fSkipIfTypedefTo.contains("interface") && typedefTarget instanceof RfInterface) {
                        return;
                    }
                    if (this.fSkipIfTypedefTo.contains("modport") && typedefTarget instanceof RfModport) {
                        return;
                    }
                }
                if ("class".equals(this.fElementKind)) {
                    if (!(typedefTarget instanceof RfClass)) {
                        return;
                    }
                    isTypedefMsg = true;
                }
                if ("inteface class".equals(this.fElementKind)) {
                    if (!(typedefTarget instanceof RfClass) || !((RfClass)typedefTarget).isInterfaceClass()) {
                        return;
                    }
                    isTypedefMsg = true;
                }
                if ("non-inteface class".equals(this.fElementKind)) {
                    if (!(typedefTarget instanceof RfClass) || ((RfClass)typedefTarget).isInterfaceClass()) {
                        return;
                    }
                    isTypedefMsg = true;
                }
                if ("interface".equals(this.fElementKind)) {
                    if (!(typedefTarget instanceof RfInterface)) {
                        return;
                    }
                    isTypedefMsg = true;
                }
                if ("modport".equals(this.fElementKind)) {
                    if (!(typedefTarget instanceof RfModport)) {
                        return;
                    }
                    isTypedefMsg = true;
                }
            } else if ("enum item".equals(this.fElementKind) ? !(elementToCheck instanceof RfField) : "enum".equals(this.fElementKind) || "struct".equals(this.fElementKind) || "union".equals(this.fElementKind) || "typedef".equals(this.fElementKind)) {
                return;
            }
        }
        if (LintUtils.isInsideMacroWithPrefix(elementToCheck, this.fSkipDeclaredInsideMacrosWithPrefixes)) {
            return;
        }
        String hitPrefix = String.valueOf(isOfElementKind ? this.fElementKind : elementToCheck.getKindName()) + (isTypedefMsg ? " typedef" : "") + " '" + elementToCheck.getName() + "' ";
        this.fICITElementsVisitorImpl.visitCITElement(elementToCheck, hitPrefix, isOfElementKind);
    }

    private void initElements(Set<RfNamedElement> elementsToCheck, Set<RfNamedElement> elementsNotToCheck) {
        String[] stringArray = elementKinds;
        int n = elementKinds.length;
        int n2 = 0;
        while (n2 < n) {
            String kind = stringArray[n2];
            if (kind.equals(this.fElementKind)) {
                elementsToCheck.addAll(this.getElementsOfKind(kind));
            } else if (this.fEnforceExclusivity) {
                elementsNotToCheck.addAll(this.getElementsOfKind(kind));
            }
            ++n2;
        }
        elementsNotToCheck.removeAll(elementsToCheck);
    }

    RfNamedElement getTypedefTargetForPrefix(RfTypeAlias aTypeAlias, String aElementKindPrefix) {
        if (aTypeAlias == null) {
            return null;
        }
        IRfNamedElement translatedType = !this.fSkipNestedTypedefsOfStructs ? aTypeAlias.getTranslatedType() : aTypeAlias.getAssociatedType();
        if (translatedType instanceof RfNamedElement && translatedType.getName() != null && translatedType.getName().startsWith(aElementKindPrefix)) {
            return (RfNamedElement)translatedType;
        }
        return null;
    }

    IRfNamedElement getTypedefTarget(RfTypeAlias aTypeAlias) {
        if (aTypeAlias == null) {
            return null;
        }
        return aTypeAlias.getTranslatedType();
    }
}

