/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.model.reflection.IRfPredefinedGate;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="21.1.19")
@CheckID(value="R.1001")
@CheckName(value="R.1001")
@CheckLabel(labels={RuleLabel.DESIGN, RuleLabel.SYNTHESIS})
@CheckTitle(value="Do not use MOS switches")
@CheckDescription(value="Reports MOS switches, such as cmos, rcmos, pmos, rpmos, nmos and rnmos, that are not synthesizable. Except for custom or analog design, transistor-level design is generally discouraged because behavior and timing are difficult to predict under all possible circumstances.\n\nExamples:\n\nmodule top();\n\twire gnd;\n\tlogic f;\n\twire x, y;\n\n\tnmos nx (f, gnd, x); // not allowed\n\tpmos ny (f, gnd, y); // not allowed\n\tcmos nz (f, gnd, x, y); // not allowed\n\trnmos rnx (f, gnd, y); // not allowed\n\trpmos rny (f, gnd, y); // not allowed\n\trcmos rnz (f, gnd, y); // not allowed\nendmodule\n")
public class Check_R_1001
extends OVMComplianceCheck {
    public static final Set<String> HIT_GATES = new HashSet<String>();

    public Check_R_1001(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        HIT_GATES.add("cmos");
        HIT_GATES.add("rcmos");
        HIT_GATES.add("nmos");
        HIT_GATES.add("pmos");
        HIT_GATES.add("rnmos");
        HIT_GATES.add("rpmos");
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfInstance)) {
                    return true;
                }
                IRfPredefinedGate gate = ((RfInstance)namedElement).getPredefinedGate();
                if (gate == null) {
                    return true;
                }
                Check_R_1001.this.notifyCheckAlive();
                if (!HIT_GATES.contains(gate.getName())) {
                    return true;
                }
                Check_R_1001.this.addHit(namedElement, String.valueOf(StringUtils.capitalize((String)gate.getName())) + " switch: '" + LintUtils.getNamedElementFullName(namedElement) + "' used!");
                return true;
            }
        });
    }
}

