/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.10.1")
@CheckName(value="SVTB.10.1")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.PARENTHESIS, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Use parentheses to define operator precedence")
@CheckDescription(value="Do not rely on operator precedence rules. Use parentheses to make the operator order clear.\nParentheses are required when:\n1) mixing operators of different precedence groups\n2) in known cases of confusion\nExcept for:\na) assignment operators (well known lowest precedence)\nb) concatenation and indexing (these are like parentheses themselves)\nc) scoping operators (:: and .) (well known highest precedence)\nd) unary operators (+, -, ! etc.) (well known highest precedence)\ne) constraint expression implication (->) (known construct for declaring conditional relations)\n\nExamples:\nmyvar = 1 && 3 | 4; // unclear\nmyvar = 1 && (3 | 4); // clear\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_10_1
extends AbstractSVTBSimpleIssues {
    @CheckParameter(defaultValue="", description="Comma separated list of operators that are allowed in the same expression without parenthesis. You can define more sets, for example: allowedOperators_1: +, -, *, /, % and allowedOperators_2: ==, !=, ||, &&.", name="allowedOperators", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> allowedOperator;
    private static final String pAllowedOperatorsPrefix = "allowedOperators";

    public Check_SVTB_10_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(45);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Multiple operators without parentheses: " + (issue != null ? issue.getInfo() : "");
    }

    private HashMap<String, Set<Integer>> getDefaultAllowedOperators() {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        HashSet<Integer> aos = null;
        aos = new HashSet<Integer>();
        aos.add(462);
        aos.add(463);
        aos.add(464);
        result.put("ao1", aos);
        aos = new HashSet();
        aos.add(465);
        aos.add(467);
        result.put("ao2", aos);
        aos = new HashSet();
        aos.add(469);
        aos.add(470);
        aos.add(507);
        aos.add(508);
        result.put("ao3", aos);
        aos = new HashSet();
        aos.add(487);
        aos.add(486);
        aos.add(489);
        aos.add(488);
        aos.add(128);
        result.put("ao4", aos);
        aos = new HashSet();
        aos.add(482);
        aos.add(483);
        aos.add(484);
        aos.add(485);
        aos.add(502);
        aos.add(504);
        result.put("ao5", aos);
        aos = new HashSet();
        aos.add(475);
        aos.add(476);
        result.put("ao6", aos);
        aos = new HashSet();
        aos.add(534);
        aos.add(535);
        result.put("ao7", aos);
        return result;
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        HashMap<String, Set<Integer>> allowedOperators = this.extractOperatorSets(pAllowedOperatorsPrefix);
        allowedOperators.putAll(this.getDefaultAllowedOperators());
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(45);
        Set<ParserPath> keySet = allIssues.keySet();
        for (ParserPath filename : keySet) {
            List<SVTBIssues> perFileIssues;
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(filename, this) || (perFileIssues = allIssues.get(filename)) == null || perFileIssues.isEmpty()) continue;
            this.notifyCheckAlive();
            ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
            for (SVTBIssues issue : perFileIssues) {
                Object obj;
                Map<String, Object> iMeta = issue.getMeta();
                if (iMeta == null || !((obj = iMeta.get("operators")) instanceof Collection)) continue;
                Collection operators = (Collection)obj;
                if (operators.isEmpty()) {
                    filteredList.add(issue);
                    continue;
                }
                if (this.findAllowedSet(operators, allowedOperators)) continue;
                filteredList.add(issue);
            }
            filteredMap.put(filename, filteredList);
        }
        return filteredMap;
    }

    private boolean findAllowedSet(Collection<Integer> aOperators, HashMap<String, Set<Integer>> aAllowedOperators) {
        if (aOperators == null || aAllowedOperators == null) {
            return false;
        }
        boolean foundAllowedSet = false;
        for (Set<Integer> allowedSet : aAllowedOperators.values()) {
            if (!allowedSet.containsAll(aOperators)) continue;
            foundAllowedSet = true;
            break;
        }
        return foundAllowedSet;
    }

    private HashMap<String, Set<Integer>> extractOperatorSets(String aAllowedOperatorsParamPrefix) {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        Map<String, String> allParameters = this.getProperties();
        for (Map.Entry<String, String> entry : allParameters.entrySet()) {
            String parameter = entry.getKey();
            if (parameter == null || !parameter.startsWith(aAllowedOperatorsParamPrefix)) continue;
            result.put(parameter, this.extractOperatorSet(entry.getValue()));
        }
        return result;
    }

    private Set<Integer> extractOperatorSet(String aOperatorSetString) {
        String[] operators;
        HashSet<Integer> result = new HashSet<Integer>();
        if (aOperatorSetString == null) {
            return result;
        }
        String[] stringArray = operators = aOperatorSetString.split(",");
        int n = operators.length;
        int n2 = 0;
        while (n2 < n) {
            String operator = stringArray[n2];
            int vltt = LintUtils.stringOperatorToVlogLexerTokenType(operator);
            if (vltt != -1) {
                result.add(vltt);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean isValidParameter(String key) {
        return key != null && key.startsWith(pAllowedOperatorsPrefix);
    }

    @Override
    protected boolean isForceFailure(ReparseInfo reparseInfo) {
        return LintUtils.isInsideXVMReportingMacro(this.fOVMProject.getLibraryKind() == 2, reparseInfo);
    }
}

