/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="16.1.22")
@CheckID(value="SVTB.10.13.1")
@CheckName(value="SVTB.10.13.1")
@CheckLabel(labels={RuleLabel.OPERATOR})
@CheckTitle(value="Do not use force statements")
@CheckDescription(value="Do not use force statements\n\nExamples:\n\nclass my_class;\n\tinteger a;\n\tinteger b;\n\n\tfunction void foo()\n\t\tforce a = b + 1; // not allowed\n\t\ta = b + 1; // allowed\n\tendfunction\nendclass\n")
public class Check_SVTB_10_13_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of method full name patterns to be skipped.", name="skipMethodPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected HashSet<Pattern> pSkipMethodPatterns;

    public Check_SVTB_10_13_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public void setHolder(IHidHolder holder) {
                this.scope = ((RfHidHolder)holder).getScope();
            }

            public boolean visit(HidOperator hidOp) {
                if (!hidOp.hasOccurrence(HidOperatorQualifier.IS_PROCEDURAL_FORCE_ASSIGN)) {
                    return true;
                }
                Check_SVTB_10_13_1.this.notifyCheckAlive();
                HidOperatorOccurrence oc = hidOp.getOccurrence();
                if (oc.hasQualifier(HidOperatorQualifier.IS_PROCEDURAL_FORCE_ASSIGN) && (Check_SVTB_10_13_1.this.pSkipMethodPatterns.isEmpty() || !Check_SVTB_10_13_1.this.isInsideFunction((RfNamedElement)this.scope))) {
                    Check_SVTB_10_13_1.this.addHit(this.parserPath, (HidOccurrence)oc, "Force " + HidUtils.toNiceString((IHidObject)hidOp) + " statement was used!");
                }
                return true;
            }
        });
    }

    private boolean isInsideFunction(RfNamedElement scope) {
        RfNamedElement enclosingScope = scope;
        while (!(enclosingScope instanceof RfFunction)) {
            if (enclosingScope != null) {
                enclosingScope = enclosingScope.getEnclosingScope();
                continue;
            }
            return false;
        }
        for (Pattern pattern : this.pSkipMethodPatterns) {
            if (!pattern.matcher(enclosingScope.getFullName()).matches()) continue;
            return true;
        }
        return false;
    }
}

