/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractOperatorInConstraint;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.30")
@CheckID(value="SVTB.10.15")
@CheckName(value="SVTB.10.15")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CONSTRAINT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Use maximum one relational operation in a constraint expression")
@CheckDescription(value="Use maximum one relational operation in a constraint expression.\n\nFor example, to make the whole expression a==b==c true, c will have to be equal to the result of a==b, and not to be equal to a and equal to b. This means that c will always be either 0 or 1, as the result of a==b is either 0 or 1.\n\nNot Allowed:\n    constraint level_c { a==b==c; }\n\nAllowed:\n    constraint level_c { a==b; b==c; }\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_15
extends AbstractOperatorInConstraint {
    @CheckParameter(defaultValue="false", description="When this is set to true, the rule will allow multiple relational operations if they are separated by parentheses.", name="allowOperatorsInParentheses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowParanthesisSeparation;

    public Check_SVTB_10_15(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkOperators(RfHidOperator op, List<IHidObject> hidValues, HashMap<RfHidOperator, String> hits, ParserPath parserPath) {
        if (this.isRelationalOperator(op)) {
            for (IHidObject hid : hidValues) {
                if (!(hid instanceof RfHidOperator) || !this.isRelationalOperator((RfHidOperator)hid) || this.pAllowParanthesisSeparation && this.checkParanthesisParity(op, (RfHidOperator)hid, parserPath)) continue;
                hits.put(op, "Constraint expression '" + HidUtils.toString((IHidObject)op, (boolean)true, (boolean)true) + "' has more than one relational operation!");
                return;
            }
        }
    }

    private boolean isRelationalOperator(RfHidOperator op) {
        return op.isRelational() || op.isEqualityOrInequality() || op.isWildcardEquality();
    }
}

