/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.34")
@CheckID(value="SVTB.10.16")
@CheckName(value="SVTB.10.16")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.ENUM, RuleLabel.FORMAT_SPECIFIER, RuleLabel.PREDEFINED_METHOD, RuleLabel.ARGUMENT})
@CheckTitle(value="Do not use an enum argument with '%s' format specifier")
@CheckDescription(value="Do not use an enum argument directly with '%s' format specifier because the result is inconsistent across simulators.\nThe name of an enum can be printed using 'enum.name()'.\n\nExamples:\n\ntypedef enum { circle, ellipse, freeform } ClosedCurve;\nfunction void foo()\n\tClosedCurve f;\n\t$display(\"%s\", f); // not allowed\n\t$display(\"%s\", f.name()); // allowed\nendfunction\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_16
extends OVMComplianceCheck {
    private static final Set<HidFlatteningOption> ARG_FLATTENING = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));

    public Check_SVTB_10_16(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidObject>(){
            protected ParserPath parserPath;

            public boolean visit(IHidObject hidObject) {
                if (Check_SVTB_10_16.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (hidObject.getHidKind() == IHidObject.HidKind.HID) {
                    RfHid hid = (RfHid)hidObject;
                    if (!hid.isMethodCall(false)) {
                        return true;
                    }
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                    if (methodCalls.isEmpty()) {
                        return true;
                    }
                    for (MethodCall methodCall : methodCalls) {
                        if (!LintUtilsConstants.PRINT_TASKS_WITH_VALUE_PLUS_ARGS.contains(methodCall.getMethodName())) continue;
                        Check_SVTB_10_16.this.notifyCheckAlive();
                        if (methodCall.argumentValuesMapRaw == null) continue;
                        int index = -1;
                        HashSet<Integer> elementIndex = new HashSet<Integer>();
                        for (Map.Entry argumentValue : methodCall.argumentValuesMapRaw.entrySet()) {
                            if (++index == 0) {
                                this.getSpecifierIndex(elementIndex, (IHidObject)argumentValue.getValue());
                            }
                            if (!(argumentValue.getKey() instanceof RfField) || !elementIndex.contains(index)) continue;
                            IHidObject hidValue = (IHidObject)argumentValue.getValue();
                            if (hidValue instanceof RfHidOperator var11_11 && hidOperator.isConditionalTernary()) {
                                for (IHidObject rhValue : hidOperator.getRHValues()) {
                                    this.checkArgument(rhValue, methodCall.occurrence);
                                }
                            }
                            if (hidValue instanceof RfHidAccess) {
                                hidValue = ((RfHidAccess)hidValue).getParentHid();
                            }
                            this.checkArgument(hidValue, methodCall.occurrence);
                        }
                    }
                }
                return true;
            }

            private void getSpecifierIndex(HashSet<Integer> elementIndex, IHidObject value) {
                if (!(value instanceof RfHidImplicit)) {
                    return;
                }
                String string = value.toString();
                int index = 0;
                int i = 0;
                while (string.contains("%")) {
                    ++index;
                    i = string.indexOf(37);
                    if (i == -1 || i == string.length() - 1) break;
                    char specifier = string.charAt(i + 1);
                    string = string.substring(i + 2);
                    if (specifier != 's') continue;
                    elementIndex.add(index);
                }
            }

            private boolean checkArgument(IHidObject rhValue, HidOccurrence occurrence) {
                if (rhValue instanceof RfHidAccess) {
                    rhValue = ((RfHidAccess)rhValue).getParentHid();
                }
                if (!(rhValue instanceof IHid)) {
                    return false;
                }
                IRfNamedElement element = ((IHid)rhValue).getElement();
                if (!(element instanceof RfField) && !(element instanceof RfFunction)) {
                    return false;
                }
                IRfNamedElement associatedType = ((RfAssociatedType)element).getAssociatedType();
                if (!(associatedType instanceof RfAssociatedType)) {
                    return false;
                }
                RfNamedElement type = LintUtils.getAssociatedFinalType((RfAssociatedType)associatedType);
                if (type instanceof RfStruct && ((RfStruct)type).isEnum()) {
                    boolean isForce = LintUtils.isInsideXVMReportingMacro(Check_SVTB_10_16.this.fOVMProject.getLibraryKind() == 2, occurrence.getReparseInfo());
                    String message = element instanceof RfFunction ? "Method '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "' returns an enum type that " : "Enum '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "'";
                    Check_SVTB_10_16.this.addHit(this.parserPath, occurrence, String.valueOf(message) + " is used as argument for '%s' format specifier!", isForce);
                }
                return true;
            }

            public void setHolder(IHidHolder holder) {
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

