/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="17.1.5")
@CheckID(value="SVTB.10.17")
@CheckName(value="SVTB.10.17")
@CheckLabel(labels={RuleLabel.OPERATOR})
@CheckTitle(value="Timeformat must be set whenever timeunit and timeprecision are set")
@CheckDescription(value="Every <elementKind> that contains timeunit and timeprecision statements must also set the timeformat using $timeformat().\n\nExamples:\n\ninterface I_good; // allowed\n\ttimeunit 1s;\n\ttimeprecision 1ns;\n\ttask t();\n\t\t$timeformat(-9, 15, \" ms\", 100);\n\tendtask\nendinterface\n\ninterface I_bad; // not allowed\n\ttimeunit 1s;\n\ttimeprecision 1ns;\nendinterface\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_17
extends OVMComplianceCheck {
    private final String XVM_RUN_TEST;
    private static final String TIMEFORMAT = "$timeformat";
    @CheckParameter(defaultValue="module, program, interface", description="Apply only for elements of type module, package, program, interface, top_module, run_test_module. Comma separated list. A top_module is a module specified in the configuration file with -top and a run_test_module is a module that calls the XVM run_test method.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public HashSet<String> pElementKindValue;

    public Check_SVTB_10_17(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.XVM_RUN_TEST = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::run_test");
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> designElements = this.getDesignElements();
        this.notifyCheckAlive();
        for (RfNamedElement element : designElements) {
            if (this.checkPreWaivers(element.getFile()) || !this.hasTimePrecision(element) || !this.hasTimeUnit(element)) continue;
            this.notifyCheckAlive();
            NullProtectedList<RfFunction> functions = new NullProtectedList<RfFunction>();
            List<RfActionBlock> actionBlocks = element.getLocalMembers(RfActionBlock.class);
            if (this.checkActionBlocks(actionBlocks, functions)) continue;
            functions.addAll(element.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            functions.addAll(element.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            if (this.checkDesignElementFunctions(functions)) continue;
            this.addHit(element, "Timeformat not set in " + LintUtils.getElementKind(element) + " '" + LintUtils.getNamedElementFullName(element) + "'!");
        }
    }

    private NullProtectedList<RfNamedElement> getDesignElements() {
        NullProtectedList<RfNamedElement> designElements = new NullProtectedList<RfNamedElement>();
        if (this.pElementKindValue.contains("module")) {
            designElements.addAll(this.fOVMProject.getAllModules());
        }
        if (this.pElementKindValue.contains("interface")) {
            designElements.addAll(this.fOVMProject.getAllInterfaces());
        }
        if (this.pElementKindValue.contains("program")) {
            designElements.addAll(this.fOVMProject.getAllPrograms());
        }
        if (this.pElementKindValue.contains("package")) {
            designElements.addAll(this.fOVMProject.getAllPackages());
        }
        if (this.pElementKindValue.contains("top_module") && !this.pElementKindValue.contains("module")) {
            designElements.addAll(LintUtils.getTopModules(this.fOVMProject));
        }
        if (this.pElementKindValue.contains("run_test_module") && !this.pElementKindValue.contains("module")) {
            NullProtectedList<RfNamedElement> allModules = this.fOVMProject.getAllModules();
            block0: for (RfNamedElement module : allModules) {
                List<RfFunctionCall> calls = module.getFunctionCallsWithPrefix("", 2);
                if (this.checkFunctionCallsForRunTestCall(calls)) {
                    designElements.add(module);
                    continue;
                }
                List<RfFunction> functions = module.getLocalMembers(RfFunction.class);
                if (functions == null || functions.isEmpty()) continue;
                for (RfFunction function : functions) {
                    calls = function.getFunctionCallsWithPrefix("", 2);
                    if (!this.checkFunctionCallsForRunTestCall(calls)) continue;
                    designElements.add(module);
                    continue block0;
                }
            }
        }
        return designElements;
    }

    public boolean checkFunctionCallsForRunTestCall(List<RfFunctionCall> functionCalls) {
        if (functionCalls == null || functionCalls.isEmpty()) {
            return false;
        }
        for (RfFunctionCall functionCall : functionCalls) {
            RfFunction function;
            String functionCallFullName = functionCall.getFullName();
            if (!functionCallFullName.equals("run_test") && !functionCallFullName.equals(this.XVM_RUN_TEST) || (function = functionCall.getFunction()) == null || !function.getFullName().equals(this.XVM_RUN_TEST)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTimePrecision(RfNamedElement namedElement) {
        if (namedElement instanceof RfModule && ((RfModule)namedElement).hasDirectiveTimeprecision()) {
            return true;
        }
        if (namedElement instanceof RfInterface && ((RfInterface)namedElement).hasDirectiveTimeprecision()) {
            return true;
        }
        if (namedElement instanceof RfProgram && ((RfProgram)namedElement).hasDirectiveTimeprecision()) {
            return true;
        }
        return namedElement instanceof RfPackage && ((RfPackage)namedElement).hasDirectiveTimeprecision();
    }

    public boolean hasTimeUnit(RfNamedElement namedElement) {
        if (namedElement instanceof RfModule && ((RfModule)namedElement).hasDirectiveTimeunit()) {
            return true;
        }
        if (namedElement instanceof RfInterface && ((RfInterface)namedElement).hasDirectiveTimeunit()) {
            return true;
        }
        if (namedElement instanceof RfProgram && ((RfProgram)namedElement).hasDirectiveTimeunit()) {
            return true;
        }
        return namedElement instanceof RfPackage && ((RfPackage)namedElement).hasDirectiveTimeunit();
    }

    public boolean checkDesignElementFunctions(NullProtectedList<RfFunction> functions) {
        HashSet<RfFunction> visited = new HashSet<RfFunction>();
        for (RfFunction function : functions) {
            if (!this.checkFunction(function, visited)) continue;
            return true;
        }
        return false;
    }

    public boolean checkFunction(RfFunction function, Set<RfFunction> visited) {
        if (function == null || visited.contains(function)) {
            return false;
        }
        visited.add(function);
        List<RfFunctionCall> functionCalls = function.getFunctionCallsWithPrefix("", 2);
        if (functionCalls == null || functionCalls.isEmpty()) {
            return false;
        }
        for (RfFunctionCall functionCall : functionCalls) {
            if (this.isTimeFormatCall(functionCall)) {
                return true;
            }
            RfFunction aux = functionCall.getFunction();
            if (aux == null || !this.checkFunction(aux, visited)) continue;
            return true;
        }
        return false;
    }

    public boolean isTimeFormatCall(RfFunctionCall functionCall) {
        if (functionCall == null) {
            return false;
        }
        return functionCall.getName().equals(TIMEFORMAT);
    }

    public boolean checkActionBlocks(List<RfActionBlock> actionBlocks, NullProtectedList<RfFunction> functions) {
        if (actionBlocks == null || actionBlocks.isEmpty()) {
            return false;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            List<RfFunctionCall> timeFormatCalls = actionBlock.getFunctionCallsWithPrefix(TIMEFORMAT, 1);
            if (!timeFormatCalls.isEmpty()) {
                return true;
            }
            List<RfFunctionCall> localFunctionCalls = actionBlock.getFunctionCallsWithPrefix("", 2);
            if (localFunctionCalls == null || localFunctionCalls.isEmpty()) continue;
            for (RfFunctionCall functionCall : localFunctionCalls) {
                RfFunction function = functionCall.getFunction();
                if (function == null) continue;
                functions.add(function);
            }
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

